/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AlphaNum12;
import org.stellar.sdk.xdr.AlphaNum4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TrustLineAsset
implements XdrElement {
    private AssetType discriminant;
    private AlphaNum4 alphaNum4;
    private AlphaNum12 alphaNum12;
    private PoolID liquidityPoolID;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                this.alphaNum4.encode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                this.alphaNum12.encode(stream);
                break;
            }
            case ASSET_TYPE_POOL_SHARE: {
                this.liquidityPoolID.encode(stream);
            }
        }
    }

    public static TrustLineAsset decode(XdrDataInputStream stream) throws IOException {
        TrustLineAsset decodedTrustLineAsset = new TrustLineAsset();
        AssetType discriminant = AssetType.decode(stream);
        decodedTrustLineAsset.setDiscriminant(discriminant);
        switch (decodedTrustLineAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                decodedTrustLineAsset.alphaNum4 = AlphaNum4.decode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                decodedTrustLineAsset.alphaNum12 = AlphaNum12.decode(stream);
                break;
            }
            case ASSET_TYPE_POOL_SHARE: {
                decodedTrustLineAsset.liquidityPoolID = PoolID.decode(stream);
            }
        }
        return decodedTrustLineAsset;
    }

    public static TrustLineAsset fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TrustLineAsset.fromXdrByteArray(bytes);
    }

    public static TrustLineAsset fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TrustLineAsset.decode(xdrDataInputStream);
    }

    @Generated
    public static TrustLineAssetBuilder builder() {
        return new TrustLineAssetBuilder();
    }

    @Generated
    public TrustLineAssetBuilder toBuilder() {
        return new TrustLineAssetBuilder().discriminant(this.discriminant).alphaNum4(this.alphaNum4).alphaNum12(this.alphaNum12).liquidityPoolID(this.liquidityPoolID);
    }

    @Generated
    public AssetType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public AlphaNum4 getAlphaNum4() {
        return this.alphaNum4;
    }

    @Generated
    public AlphaNum12 getAlphaNum12() {
        return this.alphaNum12;
    }

    @Generated
    public PoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    @Generated
    public void setDiscriminant(AssetType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAlphaNum4(AlphaNum4 alphaNum4) {
        this.alphaNum4 = alphaNum4;
    }

    @Generated
    public void setAlphaNum12(AlphaNum12 alphaNum12) {
        this.alphaNum12 = alphaNum12;
    }

    @Generated
    public void setLiquidityPoolID(PoolID liquidityPoolID) {
        this.liquidityPoolID = liquidityPoolID;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustLineAsset)) {
            return false;
        }
        TrustLineAsset other = (TrustLineAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetType this$discriminant = this.getDiscriminant();
        AssetType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        AlphaNum4 this$alphaNum4 = this.getAlphaNum4();
        AlphaNum4 other$alphaNum4 = other.getAlphaNum4();
        if (this$alphaNum4 == null ? other$alphaNum4 != null : !((Object)this$alphaNum4).equals(other$alphaNum4)) {
            return false;
        }
        AlphaNum12 this$alphaNum12 = this.getAlphaNum12();
        AlphaNum12 other$alphaNum12 = other.getAlphaNum12();
        if (this$alphaNum12 == null ? other$alphaNum12 != null : !((Object)this$alphaNum12).equals(other$alphaNum12)) {
            return false;
        }
        PoolID this$liquidityPoolID = this.getLiquidityPoolID();
        PoolID other$liquidityPoolID = other.getLiquidityPoolID();
        return !(this$liquidityPoolID == null ? other$liquidityPoolID != null : !((Object)this$liquidityPoolID).equals(other$liquidityPoolID));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrustLineAsset;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        AlphaNum4 $alphaNum4 = this.getAlphaNum4();
        result = result * 59 + ($alphaNum4 == null ? 43 : ((Object)$alphaNum4).hashCode());
        AlphaNum12 $alphaNum12 = this.getAlphaNum12();
        result = result * 59 + ($alphaNum12 == null ? 43 : ((Object)$alphaNum12).hashCode());
        PoolID $liquidityPoolID = this.getLiquidityPoolID();
        result = result * 59 + ($liquidityPoolID == null ? 43 : ((Object)$liquidityPoolID).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TrustLineAsset(discriminant=" + this.getDiscriminant() + ", alphaNum4=" + this.getAlphaNum4() + ", alphaNum12=" + this.getAlphaNum12() + ", liquidityPoolID=" + this.getLiquidityPoolID() + ")";
    }

    @Generated
    public TrustLineAsset() {
    }

    @Generated
    public TrustLineAsset(AssetType discriminant, AlphaNum4 alphaNum4, AlphaNum12 alphaNum12, PoolID liquidityPoolID) {
        this.discriminant = discriminant;
        this.alphaNum4 = alphaNum4;
        this.alphaNum12 = alphaNum12;
        this.liquidityPoolID = liquidityPoolID;
    }

    @Generated
    public static class TrustLineAssetBuilder {
        @Generated
        private AssetType discriminant;
        @Generated
        private AlphaNum4 alphaNum4;
        @Generated
        private AlphaNum12 alphaNum12;
        @Generated
        private PoolID liquidityPoolID;

        @Generated
        TrustLineAssetBuilder() {
        }

        @Generated
        public TrustLineAssetBuilder discriminant(AssetType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public TrustLineAssetBuilder alphaNum4(AlphaNum4 alphaNum4) {
            this.alphaNum4 = alphaNum4;
            return this;
        }

        @Generated
        public TrustLineAssetBuilder alphaNum12(AlphaNum12 alphaNum12) {
            this.alphaNum12 = alphaNum12;
            return this;
        }

        @Generated
        public TrustLineAssetBuilder liquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
            return this;
        }

        @Generated
        public TrustLineAsset build() {
            return new TrustLineAsset(this.discriminant, this.alphaNum4, this.alphaNum12, this.liquidityPoolID);
        }

        @Generated
        public String toString() {
            return "TrustLineAsset.TrustLineAssetBuilder(discriminant=" + this.discriminant + ", alphaNum4=" + this.alphaNum4 + ", alphaNum12=" + this.alphaNum12 + ", liquidityPoolID=" + this.liquidityPoolID + ")";
        }
    }
}

