// Code generated by gobind. DO NOT EDIT.

// Java class mysterium.MobileNode is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java github.com/mysteriumnetwork/node/mobile/mysterium
package mysterium;

import go.Seq;

/**
 * MobileNode represents node object tuned for mobile device.
 */
public final class MobileNode implements Seq.Proxy {
	static { Mysterium.touch(); }
	
	private final int refnum;
	
	@Override public final int incRefnum() {
	      Seq.incGoRef(refnum, this);
	      return refnum;
	}
	
	MobileNode(int refnum) { this.refnum = refnum; Seq.trackGoRef(refnum, this); }
	
	public MobileNode() { this.refnum = __New(); Seq.trackGoRef(refnum, this); }
	
	private static native int __New();
	
	/**
	 * CalculateEstimates calculates average service times
	 */
	public native Estimates calculateEstimates(double amount);
	/**
	 * Connect connects to given provider.
	 */
	public native ConnectResponse connect(ConnectRequest req);
	/**
	 * CreatePaymentGatewayOrder creates a payment order.
	 */
	public native byte[] createPaymentGatewayOrder(CreatePaymentGatewayOrderReq req) throws Exception;
	/**
	 * Disconnect disconnects or cancels current connection.
	 */
	public native void disconnect() throws Exception;
	/**
	 * ExchangeRate returns MYST rate in quote currency.
	 */
	public native double exchangeRate(String quote) throws Exception;
	/**
	 * ExportIdentity exports a given identity address encrypting it with the new passphrase.
	 */
	public native byte[] exportIdentity(String identityAddress, String newPassphrase) throws Exception;
	/**
	 * ForceBalanceUpdate force updates balance and returns the updated balance.
	 */
	public native GetBalanceResponse forceBalanceUpdate(GetBalanceRequest req);
	/**
	 * GatewayClientCallback triggers payment callback for google from client side.
	 */
	public native void gatewayClientCallback(GatewayClientCallbackReq req) throws Exception;
	/**
	 * GetBalance returns current balance.
	 */
	public native GetBalanceResponse getBalance(GetBalanceRequest req) throws Exception;
	/**
	 * GetCountries returns service proposals number per country from API.
	go mobile does not support complex slices.
	 */
	public native byte[] getCountries(GetProposalsRequest req) throws Exception;
	/**
	 * GetDefaultCurrency returns the current default currency set.
	 */
	public native String getDefaultCurrency();
	/**
	 * GetGateways returns possible payment gateways.
	 */
	public native byte[] getGateways(GetGatewaysRequest req) throws Exception;
	/**
	 * GetIdentity finds first identity and unlocks it.
	If there is no identity default one will be created.
	 */
	public native GetIdentityResponse getIdentity(GetIdentityRequest req) throws Exception;
	/**
	 * GetIdentityRegistrationFees returns identity registration fees.
	 */
	public native GetIdentityRegistrationFeesResponse getIdentityRegistrationFees() throws Exception;
	/**
	 * GetLocation return current location including country and IP.
	 */
	public native GetLocationResponse getLocation() throws Exception;
	/**
	 * GetNATType return current NAT type after a probe.
	 */
	public native String getNATType() throws Exception;
	/**
	 * GetPaymentGatewayOrder gets an order by ID.
	 */
	public native byte[] getPaymentGatewayOrder(GetPaymentOrderRequest req) throws Exception;
	/**
	 * GetPaymentGatewayOrderInvoice gets the invoice for an order.
	 */
	public native byte[] getPaymentGatewayOrderInvoice(GetPaymentOrderRequest req) throws Exception;
	/**
	 * GetProposals returns service proposals from API or cache. Proposals returned as JSON byte array since
	go mobile does not support complex slices.
	 */
	public native byte[] getProposals(GetProposalsRequest req) throws Exception;
	/**
	 * GetProposalsByPreset returns service proposals by presetID.
	 */
	public native byte[] getProposalsByPreset(long presetID) throws Exception;
	/**
	 * GetStatus returns current connection state and provider info if connected to VPN.
	 */
	public native byte[] getStatus() throws Exception;
	/**
	 * GetUnsettledEarnings returns unsettled earnings.
	 */
	public native GetBalanceResponse getUnsettledEarnings(GetBalanceRequest req) throws Exception;
	/**
	 * HealthCheck returns node health check data.
	 */
	public native HealthCheckData healthCheck();
	/**
	 * ImportIdentity import a given identity address given data (json as string) and the
	current passphrase.
	
	Identity can only be imported if it is registered.
	 */
	public native String importIdentity(byte[] data, String passphrase) throws Exception;
	/**
	 * IsFreeRegistrationEligible returns true if free registration is possible for a given identity.
	 */
	public native boolean isFreeRegistrationEligible(String identityAddress) throws Exception;
	/**
	 * ListConsumerSessions list consumer sessions
	 */
	public native byte[] listConsumerSessions(SessionFilter filter) throws Exception;
	/**
	 * ListPaymentGatewayOrders lists all payment orders.
	 */
	public native byte[] listPaymentGatewayOrders(ListOrdersRequest req) throws Exception;
	/**
	 * ListProposalFilterPresets lists system and user created filter presets for proposals
	see ProposalFilterPreset for contract
	 */
	public native byte[] listProposalFilterPresets() throws Exception;
	/**
	 * MigrateHermes migrate from old to active Hermes
	 */
	public native void migrateHermes(String id) throws Exception;
	/**
	 * MigrateHermesStatus migrate from old to active Hermes
	 */
	public native byte[] migrateHermesStatus(String id) throws Exception;
	/**
	 * OverrideWireguardConnection overrides default wireguard connection implementation to more mobile adapted one.
	 */
	public native void overrideWireguardConnection(WireguardTunnelSetup wgTunnelSetup);
	/**
	 * Reconnect is deprecated, we are doing reconnect now in the connection manager.
	TODO remove this from mobile app and here too.
	 */
	public native ConnectResponse reconnect(ConnectRequest req);
	/**
	 * RegisterBalanceChangeCallback registers callback which is called on identity balance change.
	 */
	public native void registerBalanceChangeCallback(BalanceChangeCallback cb);
	/**
	 * RegisterConnectionStatusChangeCallback registers callback which is called on active connection
	status change.
	 */
	public native void registerConnectionStatusChangeCallback(ConnectionStatusChangeCallback cb);
	/**
	 * RegisterIdentity starts identity registration in background.
	 */
	public native void registerIdentity(RegisterIdentityRequest req) throws Exception;
	/**
	 * RegisterIdentityRegistrationChangeCallback registers callback which is called on identity registration status change.
	 */
	public native void registerIdentityRegistrationChangeCallback(IdentityRegistrationChangeCallback cb);
	/**
	 * RegisterOrderUpdatedCallback registers OrderStatusChanged callback.
	 */
	public native void registerOrderUpdatedCallback(OrderUpdatedCallback cb);
	/**
	 * RegisterServiceStatusChangeCallback registers callback which is called on active connection
	status change.
	 */
	public native void registerServiceStatusChangeCallback(ServiceStatusChangeCallback cb);
	/**
	 * RegisterStatisticsChangeCallback registers callback which is called on active connection
	statistics change.
	 */
	public native void registerStatisticsChangeCallback(StatisticsChangeCallback cb);
	/**
	 * RegistrationTokenReward returns the reward amount for a given token.
	 */
	public native double registrationTokenReward(String token) throws Exception;
	/**
	 * ResidentCountry resident country
	 */
	public native String residentCountry();
	/**
	 * SendFeedback sends user feedback via feedback reported.
	 */
	public native void sendFeedback(SendFeedbackRequest req) throws Exception;
	/**
	 * SetUserConfig sets a user values in the configuration file
	 */
	public native void setUserConfig(String key, String value) throws Exception;
	/**
	 * Shutdown function stops running mobile node.
	 */
	public native void shutdown() throws Exception;
	/**
	 * StartProvider starts all provider services (provider mode)
	 */
	public native void startProvider();
	/**
	 * StopProvider stops all provider services, started by StartProvider
	 */
	public native void stopProvider();
	/**
	 * UpdateResidentCountry updates resident country
	 */
	public native void updateResidentCountry(ResidentCountryUpdateRequest r) throws Exception;
	/**
	 * WaitUntilDies function returns when node stops.
	 */
	public native void waitUntilDies() throws Exception;
	@Override public boolean equals(Object o) {
		if (o == null || !(o instanceof MobileNode)) {
		    return false;
		}
		MobileNode that = (MobileNode)o;
		return true;
	}
	
	@Override public int hashCode() {
	    return java.util.Arrays.hashCode(new Object[] {});
	}
	
	@Override public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("MobileNode").append("{");
		return b.append("}").toString();
	}
}

