/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.heterogeneous;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import network.nerve.heterogeneous.core.HtgWalletApi;
import network.nerve.heterogeneous.core.MetaMaskWalletApi;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.utils.Numeric;

public class HeterogeneousTool {
    private String symbol;
    private String chainName;
    private String rpcAddress;
    private HtgWalletApi htgWalletApi;

    public HeterogeneousTool(String symbol, String chainName, String rpcAddress) {
        this.symbol = symbol;
        this.chainName = chainName;
        this.rpcAddress = rpcAddress;
        this.htgWalletApi = HtgWalletApi.getInstance(this.symbol, this.chainName, this.rpcAddress);
    }

    public MetaMaskWalletApi metaMask() {
        return this.htgWalletApi;
    }

    public String assembleTransferMainAsset(String fromAddress, String toAddress, BigDecimal amount, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        RawTransaction rawTransaction = this.htgWalletApi.createSendMainAssetWithoutSign(fromAddress, toAddress, amount, gasLimit, gasPrice);
        return Numeric.toHexString((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction));
    }

    public String assembleTransferERC20Token(String fromAddress, String toAddress, BigInteger amount, String contractAddress, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        RawTransaction rawTransaction = this.htgWalletApi.createTransferERC20TokenWithoutSign(fromAddress, toAddress, amount, contractAddress, gasLimit, gasPrice);
        return Numeric.toHexString((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction));
    }

    public String assembleRechargeMainAsset(String fromAddress, BigInteger value, String toAddress, String multySignContractAddress) throws Exception {
        RawTransaction rawTransaction = this.htgWalletApi.createRechargeMainAssetWithoutSign(fromAddress, value, toAddress, multySignContractAddress);
        return Numeric.toHexString((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction));
    }

    public String addFeeRechargeMainAsset(String fromAddress, BigInteger value, String toAddress, String multySignContractAddress, BigInteger gasPrice, BigInteger nonce) throws Exception {
        RawTransaction rawTransaction = this.htgWalletApi.createRechargeMainAssetWithoutSign(fromAddress, value, toAddress, multySignContractAddress, gasPrice, nonce);
        return Numeric.toHexString((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction));
    }

    public String assembleRechargeERC20Token(String fromAddress, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress) throws Exception {
        RawTransaction rawTransaction = this.htgWalletApi.createRechargeErc20WithoutSign(fromAddress, value, toAddress, multySignContractAddress, bep20ContractAddress);
        return Numeric.toHexString((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction));
    }

    public String addFeeRechargeErc20(String fromAddress, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress, BigInteger gasPrice, BigInteger nonce) throws Exception {
        RawTransaction rawTransaction = this.htgWalletApi.createRechargeErc20WithoutSign(fromAddress, value, toAddress, multySignContractAddress, bep20ContractAddress, gasPrice, nonce);
        return Numeric.toHexString((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction));
    }

    public BigDecimal getBalance(String address) throws Exception {
        return this.htgWalletApi.getBalance(address);
    }

    public BigInteger getErc20Balance(String address, String contractAddress) throws Exception {
        return this.htgWalletApi.getERC20Balance(address, contractAddress);
    }

    public String authorization(String fromAddress, String multySignContractAddress, String erc20ContractAddress) throws Exception {
        RawTransaction rawTransaction = this.htgWalletApi.authorizationWithoutSign(fromAddress, multySignContractAddress, erc20ContractAddress);
        return Numeric.toHexString((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction));
    }

    public boolean isAuthorized(String fromAddress, String multySignContractAddress, String erc20ContractAddress) throws Exception {
        return this.htgWalletApi.isAuthorized(fromAddress, multySignContractAddress, erc20ContractAddress);
    }

    public TransactionReceipt getTxReceipt(String txHash) throws Exception {
        return this.htgWalletApi.getTxReceipt(txHash);
    }

    public int getContractTokenDecimals(String tokenContract) throws Exception {
        return this.htgWalletApi.getContractTokenDecimals(tokenContract);
    }

    public BigInteger totalSupply(String contractAddress) throws Exception {
        return this.htgWalletApi.totalSupply(contractAddress);
    }

    public BigInteger getCurrentGasPrice() throws IOException {
        return this.htgWalletApi.getCurrentGasPrice();
    }

    public List<Type> callViewFunction(String contractAddress, Function function) throws Exception {
        return this.htgWalletApi.callViewFunction(contractAddress, function);
    }

    public EthSendTransaction sendTxAsync(String txHex) throws Exception {
        return this.htgWalletApi.sendAsync(txHex);
    }

    public String ethSign(String priKey, String dataHex) {
        return this.htgWalletApi.ethSign(priKey, dataHex);
    }

    public String personalSign(String priKey, String data) {
        return this.htgWalletApi.personalSign(priKey, data);
    }

    public String signTypedDataV4(String priKey, String json) throws IOException {
        return this.htgWalletApi.signTypedDataV4(priKey, json);
    }
}

