/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.heterogeneous.core;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java8.util.Optional;
import network.nerve.heterogeneous.constant.Constant;
import network.nerve.heterogeneous.core.BusinessRuntimeException;
import network.nerve.heterogeneous.core.ExceptionFunction;
import network.nerve.heterogeneous.core.MetaMaskWalletApi;
import network.nerve.heterogeneous.core.WalletApi;
import network.nerve.heterogeneous.crypto.StructuredDataEncoder;
import network.nerve.heterogeneous.model.Block;
import network.nerve.heterogeneous.model.EthSendTransactionPo;
import network.nerve.heterogeneous.utils.HexUtil;
import network.nerve.heterogeneous.utils.JsonRpcUtil;
import network.nerve.heterogeneous.utils.RpcResult;
import network.nerve.heterogeneous.utils.StringUtils;
import network.nerve.heterogeneous.utils.Tools;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.http.HttpService;
import org.web3j.utils.Numeric;

public class HtgWalletApi
implements WalletApi,
MetaMaskWalletApi {
    private static Logger Log = LoggerFactory.getLogger((String)HtgWalletApi.class.getName());
    private String rpcAddress;
    private String symbol;
    private String chainName;
    private int chainId = -1;
    protected Web3j web3j;

    private HtgWalletApi(String symbol, String chainName, String rpcAddress) {
        this.symbol = symbol;
        this.chainName = chainName;
        this.rpcAddress = rpcAddress;
        this.init();
    }

    private HtgWalletApi(String symbol, String chainName) {
        this.symbol = symbol;
        this.chainName = chainName;
    }

    public static HtgWalletApi getInstance(String symbol, String chainName, String rpcAddress) {
        return new HtgWalletApi(symbol, chainName, rpcAddress);
    }

    public static HtgWalletApi getInstance(String symbol, String chainName) {
        return new HtgWalletApi(symbol, chainName);
    }

    private void init() {
        this.initialize();
        if (this.web3j == null) {
            this.web3j = this.newInstanceWeb3j(this.rpcAddress);
        }
    }

    private int chainId() {
        if (this.chainId <= 0) {
            try {
                BigInteger _chainId = ((EthChainId)this.web3j.ethChainId().send()).getChainId();
                if (_chainId == null) {
                    throw new RuntimeException("empty chain id");
                }
                this.chainId = _chainId.intValue();
                return this.chainId;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.chainId;
    }

    public boolean restartApi(String rpcAddress, int chainId) {
        if (StringUtils.isBlank(rpcAddress)) {
            throw new RuntimeException("empty rpcAddress");
        }
        try {
            this.rpcAddress = rpcAddress;
            this.chainId = chainId;
            this.shutdownWeb3j();
            this.init();
            return true;
        }
        catch (Exception e) {
            Log.error("\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private void shutdownWeb3j() {
        if (this.web3j != null) {
            this.web3j.shutdown();
            this.web3j = null;
        }
    }

    public EthSendTransaction transferERC20Token(String from, String to, BigInteger value, String privateKey, String contractAddress, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        String hexValue = this.createTransferERC20Token(from, to, value, privateKey, contractAddress, gasLimit, gasPrice).getTxHex();
        EthSendTransaction ethSendTransaction = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        return ethSendTransaction;
    }

    public RawTransaction createTransferERC20TokenWithoutSign(String from, String to, BigInteger value, String contractAddress, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        BigInteger nonce = this.getNonce(from);
        Function function = new Function("transfer", Arrays.asList(new Address(to), new Uint256(value)), Arrays.asList(new TypeReference<Type>(){}));
        String encodedFunction = FunctionEncoder.encode((Function)function);
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)contractAddress, (String)encodedFunction);
        return rawTransaction;
    }

    @Override
    public EthSendTransactionPo createTransferERC20Token(String from, String to, BigInteger value, String privateKey, String contractAddress, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        RawTransaction rawTransaction = this.createTransferERC20TokenWithoutSign(from, to, value, contractAddress, gasLimit, gasPrice);
        Credentials credentials = Credentials.create((String)privateKey);
        byte[] signMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)this.chainId(), (Credentials)credentials);
        String hexValue = Numeric.toHexString((byte[])signMessage);
        return new EthSendTransactionPo(from, rawTransaction, hexValue);
    }

    public String sendMainAsset(String fromAddress, String privateKey, String toAddress, BigDecimal value, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        String hexValue = this.createSendMainAsset(fromAddress, privateKey, toAddress, value, gasLimit, gasPrice).getTxHex();
        EthSendTransaction send = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        return send.getTransactionHash();
    }

    public RawTransaction createSendMainAssetWithoutSign(String fromAddress, String toAddress, BigDecimal value, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        BigDecimal ethBalance = this.getBalance(fromAddress);
        if (ethBalance == null) {
            throw new RuntimeException(String.format("\u83b7\u53d6\u5f53\u524d\u5730\u5740%s\u4f59\u989d\u5931\u8d25", this.symbol));
        }
        BigInteger bigIntegerValue = this.convertMainAssetToWei(value);
        if (ethBalance.toBigInteger().compareTo(bigIntegerValue.add(gasLimit.multiply(gasPrice))) < 0) {
            throw new RuntimeException("\u8d26\u6237\u91d1\u989d\u5c0f\u4e8e\u8f6c\u8d26\u91d1\u989d\u4e0e\u624b\u7eed\u8d39\u4e4b\u548c!");
        }
        BigInteger nonce = this.getNonce(fromAddress);
        if (nonce == null) {
            throw new RuntimeException("\u83b7\u53d6\u5f53\u524d\u5730\u5740nonce\u5931\u8d25");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        RawTransaction etherTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)toAddress, (BigInteger)bigIntegerValue);
        return etherTransaction;
    }

    @Override
    public EthSendTransactionPo createSendMainAsset(String fromAddress, String privateKey, String toAddress, BigDecimal value, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        RawTransaction etherTransaction = this.createSendMainAssetWithoutSign(fromAddress, toAddress, value, gasLimit, gasPrice);
        Credentials credentials = Credentials.create((String)privateKey);
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)etherTransaction, (long)this.chainId(), (Credentials)credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        return new EthSendTransactionPo(fromAddress, etherTransaction, hexValue);
    }

    public void initialize() {
    }

    public long getBlockHeight() throws Exception {
        BigInteger blockHeight = this.timeOutWrapperFunction("getBlockHeight", null, args -> ((EthBlockNumber)this.web3j.ethBlockNumber().send()).getBlockNumber());
        if (blockHeight != null) {
            return blockHeight.longValue();
        }
        return 0L;
    }

    private <T, R> R timeOutWrapperFunction(String functionName, T arg, ExceptionFunction<T, R> fucntion) throws Exception {
        return this.timeOutWrapperFunctionReal(functionName, fucntion, 0, arg);
    }

    private <T, R> R timeOutWrapperFunctionReal(String functionName, ExceptionFunction<T, R> fucntion, int times, T arg) throws Exception {
        try {
            return fucntion.apply(arg);
        }
        catch (Exception e) {
            if (e instanceof BusinessRuntimeException || times > 1) {
                throw e;
            }
            this.restartApi(this.rpcAddress, this.chainId);
            return this.timeOutWrapperFunctionReal(functionName, fucntion, times + 1, arg);
        }
    }

    protected void checkIfResetWeb3j(int times) {
        int mod = times % 3;
        if (mod == 2 && this.web3j != null && this.rpcAddress != null) {
            this.restartApi(this.rpcAddress, this.chainId);
        }
    }

    private Web3j newInstanceWeb3j(String rpcAddress) {
        return Web3j.build((Web3jService)new HttpService(rpcAddress));
    }

    public Block getBlock(String hash) throws Exception {
        EthBlock.Block block = this.timeOutWrapperFunction("getBlock", hash, args -> ((EthBlock)this.web3j.ethGetBlockByHash(args, true).send()).getBlock());
        if (block == null) {
            return null;
        }
        return this.createBlock(block);
    }

    public Block getBlock(long height) throws Exception {
        EthBlock.Block block = this.getBlockByHeight(height);
        return this.createBlock(block);
    }

    private Block createBlock(EthBlock.Block block) {
        Block simpleBlock = new Block();
        simpleBlock.setHeight(block.getNumber().longValue());
        simpleBlock.setHash(block.getHash());
        List transactions = block.getTransactions();
        if (transactions != null && transactions.size() > 0) {
            ArrayList<network.nerve.heterogeneous.model.Transaction> list = new ArrayList<network.nerve.heterogeneous.model.Transaction>();
            for (int i = 0; i < transactions.size(); ++i) {
                org.web3j.protocol.core.methods.response.Transaction transaction = this.getTransaction(block.getNumber().longValue(), i);
                network.nerve.heterogeneous.model.Transaction transferTransaction = new network.nerve.heterogeneous.model.Transaction();
                transferTransaction.setFromAddress(transaction.getFrom());
                transferTransaction.setToAddress(transaction.getTo());
                BigDecimal value = HtgWalletApi.convertWeiToHt(transaction.getValue());
                transferTransaction.setAmount(value);
                transferTransaction.setTxHash(transaction.getHash());
                list.add(transferTransaction);
            }
            simpleBlock.setTransactions(list);
        }
        return simpleBlock;
    }

    public org.web3j.protocol.core.methods.response.Transaction getTransaction(Long height, Integer index) {
        Request ethTransactionRequest = this.web3j.ethGetTransactionByBlockNumberAndIndex((DefaultBlockParameter)new DefaultBlockParameterNumber(height.longValue()), new BigInteger(index.toString()));
        org.web3j.protocol.core.methods.response.Transaction transaction = null;
        try {
            EthTransaction send = (EthTransaction)ethTransactionRequest.send();
            if (send.getTransaction().isPresent()) {
                transaction = (org.web3j.protocol.core.methods.response.Transaction)send.getTransaction().get();
            } else {
                Log.error("\u4ea4\u6613\u8be6\u60c5\u83b7\u53d6\u5931\u8d25:" + transaction + ",height:" + height + ",index:" + index);
            }
        }
        catch (IOException e) {
            Log.error(e.getMessage());
        }
        return transaction;
    }

    public static BigDecimal convertWeiToHt(BigInteger balance) {
        BigDecimal cardinalNumber = new BigDecimal("1000000000000000000");
        BigDecimal decimalBalance = new BigDecimal(balance);
        BigDecimal value = decimalBalance.divide(cardinalNumber, 18, RoundingMode.DOWN);
        return value;
    }

    public EthBlock.Block getBlockByHeight(Long height) throws Exception {
        EthBlock.Block block = this.timeOutWrapperFunction("getBlockByHeight", height, args -> ((EthBlock)this.web3j.ethGetBlockByNumber((DefaultBlockParameter)new DefaultBlockParameterNumber(args.longValue()), true).send()).getBlock());
        return block;
    }

    public BigDecimal getBalance(String address) throws Exception {
        BigDecimal balance = this.timeOutWrapperFunction("getBalance", address, args -> {
            EthGetBalance send = (EthGetBalance)this.web3j.ethGetBalance(args, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
            if (send != null) {
                return new BigDecimal(send.getBalance());
            }
            return BigDecimal.ZERO;
        });
        return balance;
    }

    public BigInteger getERC20Balance(String address, String contractAddress) throws Exception {
        return this.getERC20BalanceReal(address, contractAddress, DefaultBlockParameterName.PENDING, 0);
    }

    public BigInteger getERC20Balance(String address, String contractAddress, DefaultBlockParameterName status) throws Exception {
        return this.getERC20BalanceReal(address, contractAddress, status, 0);
    }

    private BigInteger getERC20BalanceReal(String address, String contractAddress, DefaultBlockParameterName status, int times) throws Exception {
        try {
            this.checkIfResetWeb3j(times);
            Function function = new Function("balanceOf", Arrays.asList(new Address(address)), Arrays.asList(new TypeReference<Address>(){}));
            String encode = FunctionEncoder.encode((Function)function);
            Transaction ethCallTransaction = Transaction.createEthCallTransaction((String)address, (String)contractAddress, (String)encode);
            EthCall ethCall = (EthCall)this.web3j.ethCall(ethCallTransaction, (DefaultBlockParameter)status).sendAsync().get();
            String value = (String)ethCall.getResult();
            BigInteger balance = new BigInteger(value.substring(2), 16);
            return balance;
        }
        catch (Exception e) {
            String message = e.getMessage();
            boolean isTimeOut = Tools.isTimeOutError(message);
            if (isTimeOut) {
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                return this.getERC20BalanceReal(address, contractAddress, status, times + 1);
            }
            throw e;
        }
    }

    public EthSendTransaction sendTransaction(String fromAddress, String secretKey, Map<String, BigDecimal> transferRequests) {
        return null;
    }

    public String sendTransaction(String toAddress, String fromAddress, String secretKey, BigDecimal amount) {
        String result = null;
        if (toAddress.length() != 42) {
            return null;
        }
        if (secretKey == null) {
            Log.error("\u8d26\u6237\u79c1\u94a5\u4e0d\u5b58\u5728!");
        }
        try {
            result = this.sendMainAsset(fromAddress, secretKey, toAddress, amount, Constant.GAS_LIMIT_OF_MAIN, this.getCurrentGasPrice());
        }
        catch (Exception e) {
            Log.error("send fail", (Throwable)e);
        }
        return result;
    }

    public EthSendTransaction sendTransaction(String toAddress, String fromAddress, String secretKey, BigDecimal amount, String contractAddress) throws Exception {
        if (toAddress.length() != 42) {
            return null;
        }
        if (secretKey == null) {
            Log.error("\u8d26\u6237\u79c1\u94a5\u4e0d\u5b58\u5728!");
        }
        EthSendTransaction result = this.transferERC20Token(fromAddress, toAddress, amount.toBigInteger(), secretKey, contractAddress, this.getCurrentGasPrice(), Constant.GAS_LIMIT_OF_ERC20);
        return result;
    }

    public BigInteger getNonce(String from) throws Exception {
        BigInteger nonce = this.timeOutWrapperFunction("getNonce", from, args -> {
            EthGetTransactionCount transactionCount = (EthGetTransactionCount)this.web3j.ethGetTransactionCount(args, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).sendAsync().get();
            return transactionCount.getTransactionCount();
        });
        return nonce;
    }

    public EthSendTransaction send(String hexValue) {
        EthSendTransaction ethSendTransaction = null;
        try {
            ethSendTransaction = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).send();
        }
        catch (IOException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        return ethSendTransaction;
    }

    public EthSendTransaction sendAsync(String hexValue) throws Exception {
        return (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).sendAsync().get();
    }

    public BigInteger convertMainAssetToWei(BigDecimal value) {
        BigDecimal cardinalNumber = new BigDecimal("1000000000000000000");
        value = value.multiply(cardinalNumber);
        return value.toBigInteger();
    }

    public String convertToNewAddress(String address) {
        return address;
    }

    public EthSendTransactionPo rechargeMainAsset(String fromAddress, String prikey, BigInteger value, String toAddress, String multySignContractAddress) throws Exception {
        return this.rechargeMainAsset(fromAddress, prikey, value, toAddress, multySignContractAddress, null, null);
    }

    public EthSendTransactionPo rechargeMainAsset(String fromAddress, String prikey, BigInteger value, String toAddress, String multySignContractAddress, BigInteger gasPrice, BigInteger nonce) throws Exception {
        Function txFunction = this.getCrossOutFunction(toAddress, value, "0x0000000000000000000000000000000000000000");
        return this.sendTx(fromAddress, prikey, txFunction, value, multySignContractAddress, gasPrice, nonce);
    }

    @Override
    public EthSendTransactionPo createRechargeMainAssetWithGas(String fromAddress, String prikey, BigInteger value, String toAddress, String multySignContractAddress, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        Function txFunction = this.getCrossOutFunction(toAddress, value, "0x0000000000000000000000000000000000000000");
        return this.createSendTxWithGas(fromAddress, prikey, txFunction, value, multySignContractAddress, gasLimit, gasPrice);
    }

    public EthSendTransactionPo createRechargeMainAsset(String fromAddress, String prikey, BigInteger value, String toAddress, String multySignContractAddress) throws Exception {
        Function txFunction = this.getCrossOutFunction(toAddress, value, "0x0000000000000000000000000000000000000000");
        return this.createSendTx(fromAddress, prikey, txFunction, value, multySignContractAddress);
    }

    public RawTransaction createRechargeMainAssetWithoutSign(String fromAddress, BigInteger value, String toAddress, String multySignContractAddress) throws Exception {
        Function txFunction = this.getCrossOutFunction(toAddress, value, "0x0000000000000000000000000000000000000000");
        return this.createSendTxWithoutSign(fromAddress, txFunction, value, multySignContractAddress);
    }

    public RawTransaction createRechargeMainAssetWithoutSign(String fromAddress, BigInteger value, String toAddress, String multySignContractAddress, BigInteger gasPrice, BigInteger nonce) throws Exception {
        Function txFunction = this.getCrossOutFunction(toAddress, value, "0x0000000000000000000000000000000000000000");
        return this.createSendTxWithoutSign(fromAddress, txFunction, value, multySignContractAddress, gasPrice, nonce);
    }

    public EthSendTransactionPo rechargeErc20(String fromAddress, String prikey, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress) throws Exception {
        return this.rechargeErc20(fromAddress, prikey, value, toAddress, multySignContractAddress, bep20ContractAddress, null, null);
    }

    public EthSendTransactionPo rechargeErc20(String fromAddress, String prikey, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress, BigInteger gasPrice, BigInteger nonce) throws Exception {
        Function crossOutFunction = this.getCrossOutFunction(toAddress, value, bep20ContractAddress);
        return this.sendTx(fromAddress, prikey, crossOutFunction, value, multySignContractAddress, gasPrice, nonce);
    }

    @Override
    public EthSendTransactionPo createRechargeErc20WithGas(String fromAddress, String prikey, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        Function crossOutFunction = this.getCrossOutFunction(toAddress, value, bep20ContractAddress);
        return this.createSendTxWithGas(fromAddress, prikey, crossOutFunction, null, multySignContractAddress, gasLimit, gasPrice);
    }

    public EthSendTransactionPo createRechargeErc20(String fromAddress, String prikey, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress) throws Exception {
        Function crossOutFunction = this.getCrossOutFunction(toAddress, value, bep20ContractAddress);
        return this.createSendTx(fromAddress, prikey, crossOutFunction, null, multySignContractAddress);
    }

    public RawTransaction createRechargeErc20WithoutSign(String fromAddress, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress) throws Exception {
        Function crossOutFunction = this.getCrossOutFunction(toAddress, value, bep20ContractAddress);
        return this.createSendTxWithoutSign(fromAddress, crossOutFunction, null, multySignContractAddress);
    }

    public RawTransaction createRechargeErc20WithoutSign(String fromAddress, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress, BigInteger gasPrice, BigInteger nonce) throws Exception {
        Function crossOutFunction = this.getCrossOutFunction(toAddress, value, bep20ContractAddress);
        return this.createSendTxWithoutSign(fromAddress, crossOutFunction, null, multySignContractAddress, gasPrice, nonce);
    }

    public String authorization(String fromAddress, String prikey, String multySignContractAddress, String bep20Address) throws Exception {
        BigInteger approveAmount = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16);
        Function approveFunction = this.getERC20ApproveFunction(multySignContractAddress, approveAmount);
        String authHash = this.sendTx(fromAddress, prikey, approveFunction, null, bep20Address).getTxHash();
        return authHash;
    }

    public RawTransaction authorizationWithoutSign(String fromAddress, String multySignContractAddress, String bep20Address) throws Exception {
        BigInteger approveAmount = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16);
        Function approveFunction = this.getERC20ApproveFunction(multySignContractAddress, approveAmount);
        RawTransaction rawTransaction = this.createSendTxWithoutSign(fromAddress, approveFunction, null, bep20Address);
        return rawTransaction;
    }

    public boolean isAuthorized(String fromAddress, String multySignContractAddress, String bep20Address) throws Exception {
        Function allowanceFunction = new Function("allowance", Arrays.asList(new Address(fromAddress), new Address(multySignContractAddress)), Arrays.asList(new TypeReference<Uint256>(){}));
        BigInteger approveAmount = new BigInteger("39600000000000000000000000000");
        BigInteger allowanceAmount = (BigInteger)this.callViewFunction(bep20Address, allowanceFunction).get(0).getValue();
        return allowanceAmount.compareTo(approveAmount) > 0;
    }

    private Function getCrossOutFunction(String toAddress, BigInteger value, String erc20) {
        ArrayList<Object> inputParameters = new ArrayList<Object>();
        inputParameters.add(new Utf8String(toAddress));
        inputParameters.add(new Uint256(value));
        inputParameters.add(new Address(erc20));
        ArrayList<4> outputParameters = new ArrayList<4>();
        outputParameters.add(new TypeReference<Type>(){});
        return new Function("crossOut", inputParameters, outputParameters);
    }

    protected Function getERC20ApproveFunction(String spender, BigInteger value) {
        ArrayList<Object> inputParameters = new ArrayList<Object>();
        inputParameters.add(new Address(spender));
        inputParameters.add(new Uint256(value));
        ArrayList<5> outputParameters = new ArrayList<5>();
        outputParameters.add(new TypeReference<Type>(){});
        return new Function("approve", inputParameters, outputParameters);
    }

    public EthSendTransactionPo sendTx(String fromAddress, String priKey, Function txFunction, String contract) throws Exception {
        return this.sendTx(fromAddress, priKey, txFunction, null, contract);
    }

    public EthSendTransactionPo sendTx(String fromAddress, String priKey, Function txFunction, BigInteger value, String contract) throws Exception {
        return this.sendTx(fromAddress, priKey, txFunction, value, contract, null, null);
    }

    public EthSendTransactionPo sendTx(String fromAddress, String priKey, Function txFunction, BigInteger value, String contract, BigInteger gasPrice, BigInteger nonce) throws Exception {
        EthCall ethCall = this.validateContractCall(fromAddress, contract, txFunction, value);
        if (ethCall.isReverted()) {
            throw new Exception("verify error - " + ethCall.getRevertReason());
        }
        BigInteger estimateGas = this.ethEstimateGas(fromAddress, contract, txFunction, value);
        if (estimateGas.compareTo(BigInteger.ZERO) == 0) {
            throw new Exception("estimateGas error");
        }
        BigInteger gasLimit = estimateGas;
        return this.callContract(fromAddress, priKey, contract, gasLimit, txFunction, value, gasPrice, nonce);
    }

    public RawTransaction createSendTxWithoutSign(String fromAddress, Function txFunction, BigInteger value, String contract) throws Exception {
        EthCall ethCall = this.validateContractCall(fromAddress, contract, txFunction, value);
        if (ethCall.isReverted()) {
            throw new Exception("verify error - " + ethCall.getRevertReason());
        }
        BigInteger estimateGas = this.ethEstimateGas(fromAddress, contract, txFunction, value);
        if (estimateGas.compareTo(BigInteger.ZERO) == 0) {
            throw new Exception("estimateGas error");
        }
        BigInteger gasLimit = estimateGas;
        return this.createCallContractWithoutSign(fromAddress, contract, gasLimit, txFunction, value, null);
    }

    public RawTransaction createSendTxWithoutSign(String fromAddress, Function txFunction, BigInteger value, String contract, BigInteger gasPrice, BigInteger nonce) throws Exception {
        EthCall ethCall = this.validateContractCall(fromAddress, contract, txFunction, value);
        if (ethCall.isReverted()) {
            throw new Exception("verify error - " + ethCall.getRevertReason());
        }
        BigInteger estimateGas = this.ethEstimateGas(fromAddress, contract, txFunction, value);
        if (estimateGas.compareTo(BigInteger.ZERO) == 0) {
            throw new Exception("estimateGas error");
        }
        BigInteger gasLimit = estimateGas;
        return this.createCallContractWithoutSign(fromAddress, contract, gasLimit, txFunction, value, gasPrice, nonce);
    }

    public EthSendTransactionPo createSendTx(String fromAddress, String priKey, Function txFunction, BigInteger value, String contract) throws Exception {
        EthCall ethCall = this.validateContractCall(fromAddress, contract, txFunction, value);
        if (ethCall.isReverted()) {
            throw new Exception("verify error - " + ethCall.getRevertReason());
        }
        BigInteger estimateGas = this.ethEstimateGas(fromAddress, contract, txFunction, value);
        if (estimateGas.compareTo(BigInteger.ZERO) == 0) {
            throw new Exception("estimateGas error");
        }
        BigInteger gasLimit = estimateGas;
        return this.createCallContract(fromAddress, priKey, contract, gasLimit, txFunction, value, null);
    }

    private EthSendTransactionPo createSendTxWithGas(String fromAddress, String priKey, Function txFunction, BigInteger value, String contract, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        EthCall ethCall = this.validateContractCall(fromAddress, contract, txFunction, value);
        if (ethCall.isReverted()) {
            throw new Exception("verify error - " + ethCall.getRevertReason());
        }
        return this.createCallContract(fromAddress, priKey, contract, gasLimit, txFunction, value, gasPrice);
    }

    public TransactionReceipt getTxReceipt(String txHash) throws Exception {
        return this.timeOutWrapperFunction("getTxReceipt", txHash, args -> {
            Optional result = ((EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(args).send()).getTransactionReceipt();
            if (result == null || !result.isPresent()) {
                return null;
            }
            return (TransactionReceipt)result.get();
        });
    }

    public List<Type> callViewFunction(String contractAddress, Function function) throws Exception {
        return this.callViewFunction(contractAddress, function, false);
    }

    public List<Type> callViewFunction(String contractAddress, Function function, boolean latest) throws Exception {
        String encode = FunctionEncoder.encode((Function)function);
        ArrayList<Object> argsList = new ArrayList<Object>();
        argsList.add(contractAddress);
        argsList.add(encode);
        argsList.add(latest);
        List typeList = this.timeOutWrapperFunction("callViewFunction", argsList, args -> {
            EthCall ethCall;
            String value;
            String _contractAddress = (String)args.get(0);
            String _encode = (String)args.get(1);
            boolean _latest = (Boolean)args.get(2);
            Transaction ethCallTransaction = Transaction.createEthCallTransaction(null, (String)_contractAddress, (String)_encode);
            DefaultBlockParameterName parameterName = DefaultBlockParameterName.PENDING;
            if (_latest) {
                parameterName = DefaultBlockParameterName.LATEST;
            }
            if (StringUtils.isBlank(value = (String)(ethCall = (EthCall)this.web3j.ethCall(ethCallTransaction, (DefaultBlockParameter)parameterName).sendAsync().get()).getResult())) {
                return null;
            }
            return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
        });
        return typeList;
    }

    private EthSendTransactionPo callContract(String from, String privateKey, String contractAddress, BigInteger gasLimit, Function function) throws Exception {
        return this.callContract(from, privateKey, contractAddress, gasLimit, function, null, null, null);
    }

    private EthSendTransactionPo callContract(String from, String privateKey, String contractAddress, BigInteger gasLimit, Function function, BigInteger value, BigInteger gasPrice, BigInteger nonce) throws Exception {
        value = value == null ? BigInteger.ZERO : value;
        gasPrice = gasPrice == null || gasPrice.compareTo(BigInteger.ZERO) == 0 ? this.getCurrentGasPrice() : gasPrice;
        String encodedFunction = FunctionEncoder.encode((Function)function);
        ArrayList<Object> argsList = new ArrayList<Object>();
        argsList.add(from);
        argsList.add(privateKey);
        argsList.add(contractAddress);
        argsList.add(gasLimit);
        argsList.add(encodedFunction);
        argsList.add(value);
        argsList.add(gasPrice);
        argsList.add(nonce);
        EthSendTransactionPo txPo = this.timeOutWrapperFunction("callContract", argsList, args -> {
            int i = 0;
            String _from = args.get(i++).toString();
            String _privateKey = args.get(i++).toString();
            String _contractAddress = args.get(i++).toString();
            BigInteger _gasLimit = (BigInteger)args.get(i++);
            String _encodedFunction = args.get(i++).toString();
            BigInteger _value = (BigInteger)args.get(i++);
            BigInteger _gasPrice = (BigInteger)args.get(i++);
            BigInteger nonceArg = (BigInteger)args.get(i++);
            Credentials credentials = Credentials.create((String)_privateKey);
            RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)(nonceArg = nonceArg == null || nonceArg.compareTo(BigInteger.ZERO) == 0 ? this.getNonce(_from) : nonceArg), (BigInteger)_gasPrice, (BigInteger)_gasLimit, (String)_contractAddress, (BigInteger)_value, (String)_encodedFunction);
            byte[] signMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)this.chainId(), (Credentials)credentials);
            String hexValue = Numeric.toHexString((byte[])signMessage);
            EthSendTransaction send = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue).sendAsync().get();
            if (send == null) {
                throw new BusinessRuntimeException("send transaction request error");
            }
            if (send.hasError()) {
                throw new BusinessRuntimeException(send.getError().getMessage());
            }
            return new EthSendTransactionPo(send.getTransactionHash(), _from, rawTransaction);
        });
        return txPo;
    }

    private RawTransaction createCallContractWithoutSign(String from, String contractAddress, BigInteger gasLimit, Function function, BigInteger value, BigInteger gasPrice) throws Exception {
        return this.createCallContractWithoutSign(from, contractAddress, gasLimit, function, value, gasPrice, null);
    }

    private RawTransaction createCallContractWithoutSign(String from, String contractAddress, BigInteger gasLimit, Function function, BigInteger value, BigInteger gasPrice, BigInteger nonce) throws Exception {
        value = value == null ? BigInteger.ZERO : value;
        gasPrice = gasPrice == null || gasPrice.compareTo(BigInteger.ZERO) == 0 ? this.getCurrentGasPrice() : gasPrice;
        String encodedFunction = FunctionEncoder.encode((Function)function);
        nonce = nonce == null || nonce.compareTo(BigInteger.ZERO) == 0 ? this.getNonce(from) : nonce;
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)contractAddress, (BigInteger)value, (String)encodedFunction);
        return rawTransaction;
    }

    private EthSendTransactionPo createCallContract(String from, String privateKey, String contractAddress, BigInteger gasLimit, Function function, BigInteger value, BigInteger gasPrice) throws Exception {
        RawTransaction rawTransaction = this.createCallContractWithoutSign(from, contractAddress, gasLimit, function, value, gasPrice);
        Credentials credentials = Credentials.create((String)privateKey);
        byte[] signMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)this.chainId(), (Credentials)credentials);
        String hexValue = Numeric.toHexString((byte[])signMessage);
        return new EthSendTransactionPo(from, rawTransaction, hexValue);
    }

    private EthCall validateContractCall(String from, String contractAddress, Function function) throws Exception {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        return this.validateContractCall(from, contractAddress, encodedFunction, null);
    }

    private EthCall validateContractCall(String from, String contractAddress, Function function, BigInteger value) throws Exception {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        return this.validateContractCall(from, contractAddress, encodedFunction, value);
    }

    private EthCall validateContractCall(String from, String contractAddress, String encodedFunction) throws Exception {
        return this.validateContractCall(from, contractAddress, encodedFunction, null);
    }

    private EthCall validateContractCall(String from, String contractAddress, String encodedFunction, BigInteger value) throws Exception {
        value = value == null ? BigInteger.ZERO : value;
        ArrayList<Object> argsList = new ArrayList<Object>();
        argsList.add(from);
        argsList.add(contractAddress);
        argsList.add(encodedFunction);
        argsList.add(value);
        EthCall ethCall = this.timeOutWrapperFunction("validateContractCall", argsList, args -> {
            String _from = args.get(0).toString();
            String _contractAddress = args.get(1).toString();
            String _encodedFunction = (String)args.get(2);
            BigInteger _value = (BigInteger)args.get(3);
            Transaction tx = new Transaction(_from, null, null, null, _contractAddress, _value, _encodedFunction);
            EthCall _ethCall = (EthCall)this.web3j.ethCall(tx, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
            return _ethCall;
        });
        return ethCall;
    }

    private BigInteger ethEstimateGas(String from, String contractAddress, Function function) throws Exception {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        return this.ethEstimateGas(from, contractAddress, encodedFunction, null);
    }

    private BigInteger ethEstimateGas(String from, String contractAddress, Function function, BigInteger value) throws Exception {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        return this.ethEstimateGas(from, contractAddress, encodedFunction, value);
    }

    private BigInteger ethEstimateGas(String from, String contractAddress, String encodedFunction, BigInteger value) throws Exception {
        value = value == null ? BigInteger.ZERO : value;
        ArrayList<Object> argsList = new ArrayList<Object>();
        argsList.add(from);
        argsList.add(contractAddress);
        argsList.add(encodedFunction);
        argsList.add(value);
        BigInteger gas = this.timeOutWrapperFunction("ethEstimateGas", argsList, args -> {
            String _from = args.get(0).toString();
            String _contractAddress = args.get(1).toString();
            String _encodedFunction = (String)args.get(2);
            BigInteger _value = (BigInteger)args.get(3);
            Transaction tx = new Transaction(_from, null, null, null, _contractAddress, _value, _encodedFunction);
            EthEstimateGas estimateGas = (EthEstimateGas)this.web3j.ethEstimateGas(tx).send();
            if (StringUtils.isBlank((String)estimateGas.getResult())) {
                return BigInteger.ZERO;
            }
            return estimateGas.getAmountUsed();
        });
        return gas;
    }

    public int getContractTokenDecimals(String tokenContract) throws Exception {
        Function allowanceFunction = new Function("decimals", new ArrayList(), Arrays.asList(new TypeReference<Uint8>(){}));
        BigInteger value = (BigInteger)this.callViewFunction(tokenContract, allowanceFunction).get(0).getValue();
        return value.intValue();
    }

    public BigInteger totalSupply(String contractAddress) throws Exception {
        Function allowanceFunction = new Function("totalSupply", new ArrayList(), Arrays.asList(new TypeReference<Uint256>(){}));
        BigInteger value = (BigInteger)this.callViewFunction(contractAddress, allowanceFunction).get(0).getValue();
        return value;
    }

    public BigInteger getCurrentGasPrice() throws IOException {
        return ((EthGasPrice)this.web3j.ethGasPrice().send()).getGasPrice();
    }

    @Override
    public EthSendTransactionPo sendRawTransaction(String privateKey, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) throws Exception {
        RawTransaction rawTransaction;
        byte[] signMessage;
        String hexValue;
        EthSendTransaction send;
        Credentials credentials = Credentials.create((String)privateKey);
        String from = credentials.getAddress();
        nonce = nonce == null ? this.getNonce(from) : nonce;
        BigInteger bigInteger = gasPrice = gasPrice == null || gasPrice.compareTo(BigInteger.ZERO) == 0 ? this.getCurrentGasPrice() : gasPrice;
        if (gasLimit == null || gasLimit.compareTo(BigInteger.ZERO) == 0) {
            gasLimit = StringUtils.isBlank(data) || "0x".equals(data) ? Constant.GAS_LIMIT_OF_MAIN : new BigDecimal(this.ethEstimateGas(from, to, data, value)).multiply(new BigDecimal("1.2")).toBigInteger();
        }
        if ((send = (EthSendTransaction)this.web3j.ethSendRawTransaction(hexValue = Numeric.toHexString((byte[])(signMessage = TransactionEncoder.signMessage((RawTransaction)(rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)(value = value == null ? BigInteger.ZERO : value), (String)data)), (long)this.chainId(), (Credentials)credentials)))).sendAsync().get()) == null) {
            throw new RuntimeException("send transaction request error");
        }
        if (send.hasError()) {
            throw new RuntimeException(send.getError().getMessage());
        }
        return new EthSendTransactionPo(null, from, rawTransaction, hexValue);
    }

    @Override
    public String sendRawTransactionWithoutBroadcast(String privateKey, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) throws Exception {
        Credentials credentials = Credentials.create((String)privateKey);
        String from = credentials.getAddress();
        nonce = nonce == null ? this.getNonce(from) : nonce;
        BigInteger bigInteger = gasPrice = gasPrice == null || gasPrice.compareTo(BigInteger.ZERO) == 0 ? this.getCurrentGasPrice() : gasPrice;
        if (gasLimit == null || gasLimit.compareTo(BigInteger.ZERO) == 0) {
            gasLimit = StringUtils.isBlank(data) || "0x".equals(data) ? Constant.GAS_LIMIT_OF_MAIN : new BigDecimal(this.ethEstimateGas(from, to, data, value)).multiply(new BigDecimal("1.2")).toBigInteger();
        }
        value = value == null ? BigInteger.ZERO : value;
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data);
        byte[] signMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)this.chainId(), (Credentials)credentials);
        String txHex = Numeric.toHexString((byte[])signMessage);
        return txHex;
    }

    @Override
    public EthCall validateRawTransaction(String from, String to, String data, BigInteger value) throws Exception {
        value = value == null ? BigInteger.ZERO : value;
        Transaction tx = new Transaction(from, null, null, null, to, value, data);
        EthCall _ethCall = (EthCall)this.web3j.ethCall(tx, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        return _ethCall;
    }

    @Override
    public EthCall ethCall(String from, String to, BigInteger gasLimit, BigInteger gasPrice, BigInteger value, String data, boolean latest) throws Exception {
        value = value == null ? BigInteger.ZERO : value;
        Transaction tx = new Transaction(from, null, gasPrice, gasLimit, to, value, data);
        DefaultBlockParameterName parameterName = DefaultBlockParameterName.PENDING;
        if (latest) {
            parameterName = DefaultBlockParameterName.LATEST;
        }
        EthCall ethCall = (EthCall)this.web3j.ethCall(tx, (DefaultBlockParameter)parameterName).sendAsync().get();
        return ethCall;
    }

    @Override
    public EthEstimateGas ethEstimateGas(String from, String to, BigInteger gasLimit, BigInteger gasPrice, BigInteger value, String data) throws Exception {
        value = value == null ? BigInteger.ZERO : value;
        Transaction tx = new Transaction(from, null, gasPrice, gasLimit, to, value, data);
        EthEstimateGas estimateGas = (EthEstimateGas)this.web3j.ethEstimateGas(tx).send();
        return estimateGas;
    }

    @Override
    public RpcResult request(String requestURL, String method, List<Object> params) {
        String url = requestURL;
        url = requestURL.endsWith("/") ? url + "ethCall" : url + "/" + "ethCall";
        return JsonRpcUtil.requestForMetaMask(requestURL, this.chainName, method, params);
    }

    @Override
    public String ethSign(String priKey, String dataHex) {
        dataHex = Numeric.cleanHexPrefix((String)dataHex);
        byte[] bytes = HexUtil.decode(dataHex);
        return this.ethSign(priKey, bytes);
    }

    @Override
    public String personalSign(String priKey, String data) {
        byte[] bytes = this.dataToBytes(data);
        Credentials credentials = Credentials.create((String)priKey);
        Sign.SignatureData signatureData = Sign.signPrefixedMessage((byte[])bytes, (ECKeyPair)credentials.getEcKeyPair());
        byte[] bytesValue = ArrayUtils.addAll((byte[])signatureData.getR(), (byte[])signatureData.getS());
        bytesValue = ArrayUtils.addAll((byte[])bytesValue, (byte[])signatureData.getV());
        String result = "0x" + HexUtil.encode(bytesValue);
        return result;
    }

    @Override
    public String signTypedDataV4(String priKey, String json) throws IOException {
        json = json.replace("\\\"", "\"");
        StructuredDataEncoder encoder = new StructuredDataEncoder(json);
        byte[] hash = encoder.hashStructuredData();
        return this.ethSign(priKey, hash);
    }

    private String ethSign(String priKey, byte[] bytes) {
        Credentials credentials = Credentials.create((String)priKey);
        Sign.SignatureData signatureData = Sign.signMessage((byte[])bytes, (ECKeyPair)credentials.getEcKeyPair(), (boolean)false);
        byte[] bytesValue = ArrayUtils.addAll((byte[])signatureData.getR(), (byte[])signatureData.getS());
        bytesValue = ArrayUtils.addAll((byte[])bytesValue, (byte[])signatureData.getV());
        String result = "0x" + HexUtil.encode(bytesValue);
        return result;
    }

    private byte[] dataToBytes(String data) {
        if (StringUtils.isBlank(data)) {
            return null;
        }
        String cleanData = Numeric.cleanHexPrefix((String)data);
        try {
            char[] chars;
            boolean isHex = true;
            for (char c : chars = cleanData.toCharArray()) {
                int digit = Character.digit(c, 16);
                if (digit != -1) continue;
                isHex = false;
                break;
            }
            if (isHex) {
                return HexUtil.decode(cleanData);
            }
            return data.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return data.getBytes(StandardCharsets.UTF_8);
        }
    }
}

