/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.heterogeneous.crypto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import network.nerve.heterogeneous.crypto.EncodeObj;
import network.nerve.heterogeneous.crypto.StructuredData;
import network.nerve.heterogeneous.utils.HexUtil;
import org.web3j.abi.TypeEncoder;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.IntType;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Pair;
import org.web3j.utils.Numeric;

public class StructuredDataEncoder {
    public final StructuredData.EIP712Message jsonMessageObject;
    final String arrayTypeRegex = "^([a-zA-Z_$][a-zA-Z_$0-9]*)((\\[([1-9]\\d*)?\\])+)$";
    final Pattern arrayTypePattern = Pattern.compile("^([a-zA-Z_$][a-zA-Z_$0-9]*)((\\[([1-9]\\d*)?\\])+)$");
    final String bytesTypeRegex = "^bytes[0-9][0-9]?$";
    final Pattern bytesTypePattern = Pattern.compile("^bytes[0-9][0-9]?$");
    final String arrayDimensionRegex = "\\[([1-9]\\d*)?\\]";
    final Pattern arrayDimensionPattern = Pattern.compile("\\[([1-9]\\d*)?\\]");
    final String typeRegex = "^[a-zA-Z_$][a-zA-Z_$0-9]*(\\[([1-9]\\d*)*\\])*$";
    final Pattern typePattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*(\\[([1-9]\\d*)*\\])*$");
    final String identifierRegex = "^[a-zA-Z_$][a-zA-Z_$0-9]*$";
    final Pattern identifierPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");

    public StructuredDataEncoder(String jsonMessageInString) throws IOException, RuntimeException {
        this.jsonMessageObject = this.parseJSONMessage(jsonMessageInString);
    }

    public Set<String> getDependencies(String primaryType) {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        HashSet<String> deps = new HashSet<String>();
        if (!types.containsKey(primaryType)) {
            return deps;
        }
        ArrayList<String> remainingTypes = new ArrayList<String>();
        remainingTypes.add(primaryType);
        while (remainingTypes.size() > 0) {
            String structName = (String)remainingTypes.get(remainingTypes.size() - 1);
            remainingTypes.remove(remainingTypes.size() - 1);
            deps.add(structName);
            for (StructuredData.Entry entry : types.get(primaryType)) {
                if (!types.containsKey(entry.getType()) || deps.contains(entry.getType())) continue;
                remainingTypes.add(entry.getType());
            }
        }
        return deps;
    }

    public String encodeStruct(String structName) {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        StringBuilder structRepresentation = new StringBuilder(structName + "(");
        for (StructuredData.Entry entry : types.get(structName)) {
            structRepresentation.append(String.format("%s %s,", entry.getType(), entry.getName()));
        }
        structRepresentation = new StringBuilder(structRepresentation.substring(0, structRepresentation.length() - 1));
        structRepresentation.append(")");
        return structRepresentation.toString();
    }

    public String encodeType(String primaryType) {
        Set<String> deps = this.getDependencies(primaryType);
        deps.remove(primaryType);
        ArrayList<String> depsAsList = new ArrayList<String>(deps);
        Collections.sort(depsAsList);
        depsAsList.add(0, primaryType);
        StringBuilder result = new StringBuilder();
        for (String structName : depsAsList) {
            result.append(this.encodeStruct(structName));
        }
        return result.toString();
    }

    public byte[] typeHash(String primaryType) {
        return Numeric.hexStringToByteArray((String)Hash.sha3String((String)this.encodeType(primaryType)));
    }

    public List<Integer> getArrayDimensionsFromDeclaration(String declaration) {
        Matcher arrayTypeMatcher = this.arrayTypePattern.matcher(declaration);
        arrayTypeMatcher.find();
        String dimensionsString = arrayTypeMatcher.group(1);
        Matcher dimensionTypeMatcher = this.arrayDimensionPattern.matcher(dimensionsString);
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        while (dimensionTypeMatcher.find()) {
            String currentDimension = dimensionTypeMatcher.group(1);
            if (currentDimension == null) {
                dimensions.add(Integer.parseInt("-1"));
                continue;
            }
            dimensions.add(Integer.parseInt(currentDimension));
        }
        return dimensions;
    }

    public List<Pair> getDepthsAndDimensions(Object data, int depth) {
        if (!(data instanceof List)) {
            return new ArrayList<Pair>();
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        List dataAsArray = (List)data;
        list.add(new Pair((Object)depth, (Object)dataAsArray.size()));
        for (Object subdimensionalData : dataAsArray) {
            list.addAll(this.getDepthsAndDimensions(subdimensionalData, depth + 1));
        }
        return list;
    }

    public List<Integer> getArrayDimensionsFromData(Object data) throws RuntimeException {
        List<Pair> depthsAndDimensions = this.getDepthsAndDimensions(data, 0);
        Map<Object, List<Pair>> groupedByDepth = depthsAndDimensions.stream().collect(Collectors.groupingBy(Pair::getFirst));
        HashMap depthDimensionsMap = new HashMap();
        for (Map.Entry<Object, List<Pair>> entry : groupedByDepth.entrySet()) {
            ArrayList<Integer> pureDimensions = new ArrayList<Integer>();
            for (Pair depthDimensionPair : entry.getValue()) {
                pureDimensions.add((Integer)depthDimensionPair.getSecond());
            }
            depthDimensionsMap.put((Integer)entry.getKey(), pureDimensions);
        }
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        for (Map.Entry entry : depthDimensionsMap.entrySet()) {
            TreeSet setOfDimensionsInParticularDepth = new TreeSet((Collection)entry.getValue());
            if (setOfDimensionsInParticularDepth.size() != 1) {
                throw new RuntimeException(String.format("Depth %d of array data has more than one dimensions", entry.getKey()));
            }
            dimensions.add((Integer)setOfDimensionsInParticularDepth.stream().findFirst().get());
        }
        return dimensions;
    }

    public List<Object> flattenMultidimensionalArray(final Object data) {
        if (!(data instanceof List)) {
            return new ArrayList<Object>(){
                {
                    this.add(data);
                }
            };
        }
        ArrayList<Object> flattenedArray = new ArrayList<Object>();
        for (Object arrayItem : (List)data) {
            flattenedArray.addAll(this.flattenMultidimensionalArray(arrayItem));
        }
        return flattenedArray;
    }

    public byte[] encodeData(String primaryType, HashMap<String, Object> data) throws RuntimeException {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        ArrayList<String> encTypes = new ArrayList<String>();
        ArrayList<Object> encValues = new ArrayList<Object>();
        encTypes.add("bytes32");
        encValues.add(this.typeHash(primaryType));
        for (StructuredData.Entry field : types.get(primaryType)) {
            Object value = data.get(field.getName());
            EncodeObj encodeObj = this.encodeField(types, field.getType(), value);
            encTypes.add(encodeObj.getName());
            encValues.add(encodeObj.getValue());
        }
        byte[] result = this.rawEncode(encTypes, encValues);
        return result;
    }

    public EncodeObj encodeField(HashMap<String, List<StructuredData.Entry>> types, String type, Object value) {
        EncodeObj obj = new EncodeObj();
        if (type.equals("string")) {
            obj.setName("bytes32");
            obj.setValue(Numeric.hexStringToByteArray((String)Hash.sha3String((String)((String)value))));
        } else if (type.equals("bytes")) {
            obj.setName("bytes32");
            obj.setValue(Hash.sha3((byte[])Numeric.hexStringToByteArray((String)((String)value))));
        } else if (types.containsKey(type)) {
            byte[] hashedValue = Hash.sha3((byte[])this.encodeData(type, (HashMap)value));
            obj.setName("bytes32");
            obj.setValue(hashedValue);
        } else if (this.bytesTypePattern.matcher(type).find()) {
            obj.setName(type);
            obj.setValue(Numeric.hexStringToByteArray((String)((String)value)));
        } else if (this.arrayTypePattern.matcher(type).find()) {
            String baseTypeName = type.substring(0, type.indexOf(91));
            List<Object> arrayItems = this.flattenMultidimensionalArray(value);
            ArrayList<String> encTypes2 = new ArrayList<String>();
            ArrayList<Object> encValues2 = new ArrayList<Object>();
            for (Object item : arrayItems) {
                if (baseTypeName.equals("address")) {
                    encTypes2.add(baseTypeName);
                    encValues2.add(item);
                    continue;
                }
                if (!types.containsKey(baseTypeName)) continue;
                encTypes2.add("bytes32");
                EncodeObj obj2 = this.encodeField(types, baseTypeName, (HashMap)item);
                encValues2.add(obj2.getValue());
            }
            byte[] arrayEncodings = this.rawEncode(encTypes2, encValues2);
            byte[] hashedValue = Hash.sha3((byte[])arrayEncodings);
            obj.setName("bytes32");
            obj.setValue(hashedValue);
        } else {
            obj.setName(type);
            obj.setValue(value);
        }
        return obj;
    }

    public byte[] rawEncode(List<String> encTypes, List<Object> encValues) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < encTypes.size(); ++i) {
            Constructor<?>[] constructors;
            Class typeClazz = AbiTypes.getType((String)encTypes.get(i));
            Object encValue = encValues.get(i);
            if (IntType.class.isAssignableFrom(typeClazz)) {
                String s = encValue.toString();
                encValue = HexUtil.isHexStr(s) ? new BigInteger(s.substring(2), 16) : new BigInteger(encValue.toString());
            }
            boolean atleastOneConstructorExistsForGivenParametersType = false;
            for (Constructor<?> constructor : constructors = typeClazz.getConstructors()) {
                try {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    byte[] temp = Numeric.hexStringToByteArray((String)TypeEncoder.encode((Type)((Type)typeClazz.getDeclaredConstructor(parameterTypes).newInstance(encValue))));
                    baos.write(temp, 0, temp.length);
                    atleastOneConstructorExistsForGivenParametersType = true;
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                }
            }
            if (atleastOneConstructorExistsForGivenParametersType) continue;
            throw new RuntimeException(String.format("Received an invalid argument for which no constructor exists for the ABI Class %s", typeClazz.getSimpleName()));
        }
        return baos.toByteArray();
    }

    public byte[] hashMessage(String primaryType, HashMap<String, Object> data) throws RuntimeException {
        return Hash.sha3((byte[])this.encodeData(primaryType, data));
    }

    public byte[] hashDomain() throws RuntimeException {
        ObjectMapper oMapper = new ObjectMapper();
        HashMap data = (HashMap)oMapper.convertValue((Object)this.jsonMessageObject.getDomain(), HashMap.class);
        if (data.get("chainId") != null) {
            data.put("chainId", ((HashMap)data.get("chainId")).get("value"));
        } else {
            data.remove("chainId");
        }
        data.put("verifyingContract", ((HashMap)data.get("verifyingContract")).get("value"));
        return Hash.sha3((byte[])this.encodeData("EIP712Domain", data));
    }

    public void validateStructuredData(StructuredData.EIP712Message jsonMessageObject) throws RuntimeException {
        for (String structName : jsonMessageObject.getTypes().keySet()) {
            List<StructuredData.Entry> fields = jsonMessageObject.getTypes().get(structName);
            for (StructuredData.Entry entry : fields) {
                if (!this.identifierPattern.matcher(entry.getName()).find()) {
                    throw new RuntimeException(String.format("Invalid Identifier %s in %s", entry.getName(), structName));
                }
                if (this.typePattern.matcher(entry.getType()).find()) continue;
                throw new RuntimeException(String.format("Invalid Type %s in %s", entry.getType(), structName));
            }
        }
    }

    public StructuredData.EIP712Message parseJSONMessage(String jsonMessageInString) throws IOException, RuntimeException {
        ObjectMapper mapper = new ObjectMapper();
        StructuredData.EIP712Message tempJSONMessageObject = (StructuredData.EIP712Message)mapper.readValue(jsonMessageInString, StructuredData.EIP712Message.class);
        this.validateStructuredData(tempJSONMessageObject);
        return tempJSONMessageObject;
    }

    public byte[] hashStructuredData() throws RuntimeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String messagePrefix = "\u0019\u0001";
        byte[] prefix = "\u0019\u0001".getBytes();
        baos.write(prefix, 0, prefix.length);
        byte[] domainHash = this.hashDomain();
        baos.write(domainHash, 0, domainHash.length);
        byte[] dataHash = this.hashMessage(this.jsonMessageObject.getPrimaryType(), (HashMap)this.jsonMessageObject.getMessage());
        baos.write(dataHash, 0, dataHash.length);
        byte[] result = baos.toByteArray();
        return Hash.sha3((byte[])result);
    }

    public byte[] encodeDataMessage() {
        byte[] bytes = this.encodeData(this.jsonMessageObject.getPrimaryType(), (HashMap)this.jsonMessageObject.getMessage());
        return bytes;
    }
}

