/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.heterogeneous.crypto;

import java.math.BigInteger;
import network.nerve.heterogeneous.crypto.RawTransaction;
import network.nerve.heterogeneous.crypto.Sign;
import network.nerve.heterogeneous.crypto.SignedRawTransaction;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.utils.Numeric;

public class TransactionDecoder {
    public static RawTransaction decode(String hexTransaction) {
        byte[] transaction = Numeric.hexStringToByteArray((String)hexTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        BigInteger nonce = ((RlpString)values.getValues().get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.getValues().get(1)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.getValues().get(2)).asPositiveBigInteger();
        String to = ((RlpString)values.getValues().get(3)).asString();
        BigInteger value = ((RlpString)values.getValues().get(4)).asPositiveBigInteger();
        String data = ((RlpString)values.getValues().get(5)).asString();
        if (values.getValues().size() == 6 || values.getValues().size() == 8 && ((RlpString)values.getValues().get(7)).getBytes().length == 10 || values.getValues().size() == 9 && ((RlpString)values.getValues().get(8)).getBytes().length == 10) {
            return RawTransaction.createTransaction(nonce, gasPrice, gasLimit, to, value, data);
        }
        byte[] v = ((RlpString)values.getValues().get(6)).getBytes();
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(7)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(8)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(nonce, gasPrice, gasLimit, to, value, data, signatureData);
    }
}

