/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.basic;

import java.math.BigInteger;
import network.nerve.core.exception.NulsRuntimeException;

public class TransactionFeeCalculator {
    public static final BigInteger NORMAL_PRICE_PRE_1024_BYTES = BigInteger.valueOf(100000L);
    public static final BigInteger CROSSTX_PRICE_PRE_1024_BYTES = BigInteger.valueOf(1000000L);
    public static final int KB = 1024;

    public static final BigInteger getNormalTxFee(int size) {
        BigInteger fee = NORMAL_PRICE_PRE_1024_BYTES.multiply(new BigInteger(String.valueOf(size / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(NORMAL_PRICE_PRE_1024_BYTES);
        }
        return fee;
    }

    public static final BigInteger getConsensusTxFee(int size, long unit) {
        BigInteger unitBigInteger = BigInteger.valueOf(unit);
        BigInteger fee = unitBigInteger.multiply(new BigInteger(String.valueOf(size / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(unitBigInteger);
        }
        return fee;
    }

    public static final BigInteger getNormalUnsignedTxFee(int size) {
        BigInteger fee = NORMAL_PRICE_PRE_1024_BYTES.multiply(new BigInteger(String.valueOf((size += 110) / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(NORMAL_PRICE_PRE_1024_BYTES);
        }
        return fee;
    }

    public static final BigInteger getCrossTxFee(int size) {
        BigInteger fee = CROSSTX_PRICE_PRE_1024_BYTES.multiply(new BigInteger(String.valueOf(size / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(CROSSTX_PRICE_PRE_1024_BYTES);
        }
        return fee;
    }

    public static final BigInteger getFee(int size, BigInteger price) {
        if (price.compareTo(NORMAL_PRICE_PRE_1024_BYTES) < 0) {
            throw new NulsRuntimeException(new Exception("entity is error"));
        }
        if (price.compareTo(CROSSTX_PRICE_PRE_1024_BYTES) > 0) {
            throw new NulsRuntimeException(new Exception("entity is error"));
        }
        BigInteger fee = price.multiply(new BigInteger(String.valueOf(size / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(price);
        }
        return fee;
    }
}

