/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.util.HashMap;
import java.util.Map;
import network.nerve.core.log.logback.LogAppender;
import network.nerve.core.log.logback.NulsLogger;
import network.nerve.core.model.StringUtils;
import org.slf4j.LoggerFactory;

public class LoggerBuilder {
    private static final Map<String, NulsLogger> CONTAINER = new HashMap<String, NulsLogger>();
    private static final Level DEFAULT_LEVEL = Level.DEBUG;
    public static long offSetTime = 0L;

    public static NulsLogger getLogger(String fileName) {
        Level level = StringUtils.isNotBlank(System.getProperty("log.level")) ? Level.toLevel((String)System.getProperty("log.level")) : DEFAULT_LEVEL;
        return LoggerBuilder.getLogger(fileName, level, level);
    }

    public static NulsLogger getLogger(String fileName, int chainId) {
        Level level = StringUtils.isNotBlank(System.getProperty("log.level")) ? Level.toLevel((String)System.getProperty("log.level")) : DEFAULT_LEVEL;
        return LoggerBuilder.getLogger("chain_" + chainId + "_" + fileName, level, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NulsLogger getLogger(String fileName, Level fileLevel, Level consoleLevel) {
        NulsLogger logger = CONTAINER.get(fileName);
        if (logger != null) {
            return logger;
        }
        Class<LoggerBuilder> clazz = LoggerBuilder.class;
        synchronized (LoggerBuilder.class) {
            logger = LoggerBuilder.build(fileName, fileLevel, consoleLevel);
            CONTAINER.put(fileName, logger);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return logger;
        }
    }

    private static NulsLogger build(String fileName, Level fileLevel, Level consoleLevel) {
        RollingFileAppender fileAppender = LogAppender.getAppender(fileName, fileLevel);
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger(fileAppender.getEncoder().toString());
        logger.setAdditive(false);
        logger.addAppender((Appender)fileAppender);
        Appender<ILoggingEvent> consoleAppender = LogAppender.createConsoleAppender(consoleLevel);
        logger.addAppender(consoleAppender);
        return new NulsLogger(logger);
    }

    static {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("io.netty");
        logger.setAdditive(false);
        logger.setLevel(Level.ERROR);
        Logger mongodbLogger = context.getLogger("org.mongodb.driver.protocol.command");
        mongodbLogger.setAdditive(false);
        mongodbLogger.setLevel(Level.ERROR);
        Logger mongodbLogger2 = context.getLogger("org.mongodb.driver.cluster");
        mongodbLogger2.setAdditive(false);
        mongodbLogger2.setLevel(Level.ERROR);
    }
}

