/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.parse.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import network.nerve.core.model.StringUtils;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class IniEntity {
    private final Ini ini;

    public IniEntity(Ini ini) {
        this.ini = ini;
    }

    public String getCfgValue(String section, String key) throws Exception {
        Profile.Section ps = (Profile.Section)this.ini.get((Object)section);
        if (null == ps) {
            throw new Exception("CONFIGURATION_ITEM_DOES_NOT_EXIST");
        }
        String value = (String)ps.get((Object)key);
        if (StringUtils.isBlank(value)) {
            throw new Exception("CONFIGURATION_ITEM_DOES_NOT_EXIST");
        }
        return value;
    }

    public <T> T getCfgValue(String section, String key, T defaultValue) {
        Profile.Section ps = (Profile.Section)this.ini.get((Object)section);
        if (null == ps) {
            return defaultValue;
        }
        String value = (String)ps.get((Object)key);
        if (StringUtils.isBlank(value)) {
            return defaultValue;
        }
        return IniEntity.getValueByType(value, defaultValue);
    }

    protected static <T> T getValueByType(String value, T defaultValue) {
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(Integer.parseInt(value));
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(Long.parseLong(value));
        }
        if (defaultValue instanceof Float) {
            return (T)Float.valueOf(Float.parseFloat(value));
        }
        if (defaultValue instanceof Double) {
            return (T)Double.valueOf(Double.parseDouble(value));
        }
        if (defaultValue instanceof Boolean) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(value));
        }
        return (T)value;
    }

    public Profile.Section getSection(String section) throws Exception {
        Profile.Section ps = (Profile.Section)this.ini.get((Object)section);
        if (null == ps) {
            throw new Exception("CONFIGURATION_ITEM_DOES_NOT_EXIST");
        }
        return ps;
    }

    public List<String> getSectionList() {
        Set entrySet = this.ini.entrySet();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : entrySet) {
            list.add((String)entry.getKey());
        }
        return list;
    }

    public String toString() {
        return this.ini.toString();
    }
}

