/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.netty.handler.message;

import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import network.nerve.core.log.Log;
import network.nerve.core.parse.JSONUtils;
import network.nerve.core.rpc.model.message.Message;
import network.nerve.core.rpc.model.message.MessageType;
import network.nerve.core.rpc.model.message.Request;
import network.nerve.core.rpc.model.message.Response;
import network.nerve.core.rpc.netty.channel.ConnectData;
import network.nerve.core.rpc.netty.channel.manager.ConnectManager;
import network.nerve.core.rpc.netty.processor.RequestMessageProcessor;
import network.nerve.core.rpc.netty.processor.container.RequestContainer;
import network.nerve.core.rpc.netty.processor.container.ResponseContainer;

public class TextMessageHandler
implements Runnable,
Comparable<TextMessageHandler> {
    private SocketChannel channel;
    private Message message;
    private int priority;
    private Request request;

    public TextMessageHandler(SocketChannel channel, Message message, int priority) {
        this.channel = channel;
        this.message = message;
        this.priority = priority;
    }

    @Override
    public int compareTo(TextMessageHandler o) {
        return Integer.compare(o.priority, this.priority);
    }

    @Override
    public void run() {
        this.handler();
    }

    private void handler() {
        try {
            ConnectData connectData = ConnectManager.CHANNEL_DATA_MAP.get(this.channel);
            switch (MessageType.valueOf(this.message.getMessageType())) {
                case NegotiateConnection: {
                    RequestMessageProcessor.negotiateConnectionResponse((Channel)this.channel, this.message);
                    break;
                }
                case Unsubscribe: {
                    RequestMessageProcessor.unsubscribe(connectData, this.message);
                    break;
                }
                case Request: {
                    String messageId = this.message.getMessageID();
                    if (!ConnectManager.isPureDigital(this.request.getSubscriptionEventCounter()) && !ConnectManager.isPureDigital(this.request.getSubscriptionPeriod())) {
                        RequestMessageProcessor.callCommandsWithPeriod((Channel)this.channel, this.request.getRequestMethods(), messageId, false);
                    } else {
                        for (int tryCount = 0; connectData == null && tryCount < 3; ++tryCount) {
                            TimeUnit.SECONDS.sleep(2L);
                            connectData = ConnectManager.CHANNEL_DATA_MAP.get(this.channel);
                        }
                        if (connectData == null) {
                            RequestMessageProcessor.serviceNotStarted((Channel)this.channel, messageId);
                            break;
                        }
                        if (ConnectManager.isPureDigital(this.request.getSubscriptionPeriod())) {
                            connectData.getRequestPeriodLoopQueue().offer(new Object[]{this.message, this.request});
                            connectData.getIdToPeriodMessageMap().put(messageId, this.message);
                        }
                        if (ConnectManager.isPureDigital(this.request.getSubscriptionEventCounter())) {
                            connectData.subscribeByEvent(this.message, this.request);
                            RequestMessageProcessor.callCommandsWithPeriod((Channel)this.channel, this.request.getRequestMethods(), messageId, true);
                        }
                    }
                    if (!"1".equals(this.request.getRequestAck())) break;
                    RequestMessageProcessor.ack((Channel)this.channel, messageId);
                    break;
                }
                case RequestOnly: {
                    connectData.getRequestOnlyQueue().offer(JSONUtils.map2pojo((Map)this.message.getMessageData(), Request.class));
                    break;
                }
                case NegotiateConnectionResponse: 
                case Ack: {
                    ResponseContainer resContainer = RequestContainer.getResponseContainer((String)((Map)this.message.getMessageData()).get("RequestID"));
                    if (resContainer == null || resContainer.getFuture() == null) break;
                    resContainer.getFuture().complete(new Response());
                    break;
                }
                case Response: {
                    Response response = JSONUtils.map2pojo((Map)this.message.getMessageData(), Response.class);
                    if (ConnectManager.INVOKE_MAP.containsKey(response.getRequestID())) {
                        connectData.getResponseAutoQueue().offer(response);
                        break;
                    }
                    ResponseContainer responseContainer = RequestContainer.getResponseContainer(response.getRequestID());
                    if (responseContainer != null && responseContainer.getFuture() != null) {
                        responseContainer.getFuture().complete(response);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }
}

