/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.model.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import network.nerve.core.basic.Result;
import network.nerve.core.constant.ErrorCode;
import network.nerve.kit.model.dto.RpcErrorCode;
import network.nerve.kit.model.dto.RpcResultError;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RpcResult<T> {
    private String jsonrpc = "2.0";
    private String id;
    private T result;
    private RpcResultError error;

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public T getResult() {
        return this.result;
    }

    public RpcResult setResult(T result) {
        this.result = result;
        return this;
    }

    public RpcResultError getError() {
        return this.error;
    }

    public RpcResult setError(RpcResultError error) {
        this.error = error;
        return this;
    }

    public static <T> RpcResult success(T t) {
        RpcResult<T> rpcResult = new RpcResult<T>();
        rpcResult.setResult(t);
        return rpcResult;
    }

    public static RpcResult failed(RpcResultError error) {
        RpcResult rpcResult = new RpcResult();
        rpcResult.setError(error);
        return rpcResult;
    }

    public static RpcResult failed(RpcErrorCode errorCode) {
        RpcResult rpcResult = new RpcResult();
        RpcResultError error = new RpcResultError(errorCode);
        rpcResult.setError(error);
        return rpcResult;
    }

    public static RpcResult failed(RpcErrorCode errorCode, String data) {
        RpcResult rpcResult = new RpcResult();
        RpcResultError error = new RpcResultError(errorCode);
        error.setData(data);
        rpcResult.setError(error);
        return rpcResult;
    }

    public static RpcResult failed(Result result) {
        RpcResult rpcResult = new RpcResult();
        RpcResultError error = new RpcResultError(result.getErrorCode().getCode(), result.getMsg(), null);
        rpcResult.setError(error);
        return rpcResult;
    }

    public static RpcResult failed(ErrorCode errorCode) {
        RpcResult rpcResult = new RpcResult();
        RpcResultError error = new RpcResultError(errorCode.getCode(), errorCode.getMsg(), null);
        rpcResult.setError(error);
        return rpcResult;
    }

    public static RpcResult failed(ErrorCode errorCode, String data) {
        RpcResult rpcResult = new RpcResult();
        RpcResultError error = new RpcResultError(errorCode.getCode(), errorCode.getMsg(), data);
        rpcResult.setError(error);
        return rpcResult;
    }

    public static RpcResult dataNotFound() {
        RpcResult rpcResult = new RpcResult();
        RpcResultError error = new RpcResultError(RpcErrorCode.DATA_NOT_EXISTS.getCode(), RpcErrorCode.DATA_NOT_EXISTS.getMessage(), null);
        rpcResult.setError(error);
        return rpcResult;
    }

    public static RpcResult paramError() {
        RpcResult rpcResult = new RpcResult();
        RpcResultError error = new RpcResultError(RpcErrorCode.PARAMS_ERROR.getCode(), RpcErrorCode.PARAMS_ERROR.getMessage(), null);
        rpcResult.setError(error);
        return rpcResult;
    }

    public static RpcResult paramError(String data) {
        RpcResult rpcResult = new RpcResult();
        RpcResultError error = new RpcResultError(RpcErrorCode.PARAMS_ERROR.getCode(), RpcErrorCode.PARAMS_ERROR.getMessage(), data);
        rpcResult.setError(error);
        return rpcResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"jsonrpc\":").append('\"').append(this.jsonrpc).append('\"');
        sb.append(",\"id\":").append(this.id);
        sb.append(",\"result\":").append('\"').append(this.result).append('\"');
        sb.append(",\"error\":").append(this.error);
        sb.append('}');
        return sb.toString();
    }
}

