/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.service;

import java.util.Map;
import network.nerve.core.basic.Result;
import network.nerve.core.constant.ErrorCode;
import network.nerve.kit.model.dto.BlockDto;
import network.nerve.kit.model.dto.BlockHeaderDto;
import network.nerve.kit.model.dto.RestFulResult;
import network.nerve.kit.util.RestFulUtil;
import network.nerve.kit.util.ValidateUtil;

public class BlockService {
    private static BlockService instance = new BlockService();

    private BlockService() {
    }

    public static BlockService getInstance() {
        return instance;
    }

    public Result getBlockHeader(long height) {
        Result<BlockHeaderDto> result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/header/height/" + height);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockHeaderDto dto = BlockHeaderDto.mapToPojo(map);
            result.setData(dto);
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBlockHeader(String hash) {
        Result<BlockHeaderDto> result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/header/hash/" + hash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockHeaderDto dto = BlockHeaderDto.mapToPojo(map);
            result.setData(dto);
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBestBlockHeader() {
        Result<BlockHeaderDto> result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/header/newest");
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockHeaderDto dto = BlockHeaderDto.mapToPojo(map);
            result.setData(dto);
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBlock(long height) {
        Result<BlockDto> result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/height/" + height);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockDto dto = BlockDto.mapToPojo(map);
            result.setData(dto);
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBlock(String hash) {
        Result<BlockDto> result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/hash/" + hash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockDto dto = BlockDto.mapToPojo(map);
            result.setData(dto);
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBestBlock() {
        Result<BlockDto> result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/newest");
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockDto dto = BlockDto.mapToPojo(map);
            result.setData(dto);
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getInfo() {
        Result result;
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/info");
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }
}

