/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.txdata;

import java.io.IOException;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;

public class WithdrawalTxData
extends BaseNulsData {
    private String heterogeneousAddress;
    private int heterogeneousChainId;

    public WithdrawalTxData() {
    }

    public WithdrawalTxData(String heterogeneousAddress) {
        this.heterogeneousAddress = heterogeneousAddress;
    }

    public WithdrawalTxData(String heterogeneousAddress, int heterogeneousChainId) {
        this.heterogeneousAddress = heterogeneousAddress;
        this.heterogeneousChainId = heterogeneousChainId;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeString(this.heterogeneousAddress);
        stream.writeUint16(this.heterogeneousChainId);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.heterogeneousAddress = byteBuffer.readString();
        this.heterogeneousChainId = byteBuffer.readUint16();
    }

    @Override
    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfString(this.heterogeneousAddress);
        return size += SerializeUtils.sizeOfUint16();
    }

    public String getHeterogeneousAddress() {
        return this.heterogeneousAddress;
    }

    public void setHeterogeneousAddress(String heterogeneousAddress) {
        this.heterogeneousAddress = heterogeneousAddress;
    }

    public int getHeterogeneousChainId() {
        return this.heterogeneousChainId;
    }

    public void setHeterogeneousChainId(int heterogeneousChainId) {
        this.heterogeneousChainId = heterogeneousChainId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        builder.append(String.format("\theterogeneousAddress: %s", this.heterogeneousAddress)).append(lineSeparator);
        builder.append(String.format("\theterogeneousChainId: %s", this.heterogeneousChainId)).append(lineSeparator);
        return builder.toString();
    }
}

