/*
 * MIT License
 *
 * Copyright (c) 2017-2019 nuls.io
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
package network.nerve.core.core.annotation;

import java.lang.annotation.*;

/**
 * 该注解用来标识类型，当类型上标记了本注解，系统会在初始化阶段实例化该对象，并且对需要自动装载的属性进行赋值
 * 该注解标识的类型生成的对象使用动态代理的方式实例化，会被默认拦截器拦截
 * This annotation is used to identify the type, and when the annotation is marked on the type,
 * the system instantiates the object in the initialization phase and assigns the attributes that need to be automatically loaded.
 * The type generated by the annotation identifier is instantiated using a dynamic proxy and is intercepted by the default interceptor.
 *
 * @author: Niels Wang
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Service {

    /**
     * bean名称，可以为空，默认为空
     * the bean name, it can be empty and the default is empty.
     *
     * @return 对象名称/bean name
     */
    String value() default "";
}
