/*
 * MIT License
 *
 * Copyright (c) 2017-2018 nuls.io
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
package network.nerve.core.rpc.model.message;


import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 取消订阅多个远程方法
 * Unsubscribe to multiple remote methods
 *
 * @author tangyi
 * @date 2018/11/15
 */

public class UnregisterCompoundMethod {
    /**
     * This is the string that identifies the virtual method.
     * If it is empty then all virtual methods registered by the caller should be unregistered.
     */
    @JsonProperty
    private String UnregisterCompoundMethodName;

    @JsonIgnore
    public String getUnregisterCompoundMethodName() {
        return UnregisterCompoundMethodName;
    }

    @JsonIgnore
    public void setUnregisterCompoundMethodName(String UnregisterCompoundMethodName) {
        this.UnregisterCompoundMethodName = UnregisterCompoundMethodName;
    }
}
