/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.basic;

import com.google.common.primitives.UnsignedBytes;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import network.nerve.base.basic.AddressPrefixInf;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.data.Address;
import network.nerve.core.constant.BaseConstant;
import network.nerve.core.crypto.Base58;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.exception.NulsException;
import network.nerve.core.exception.NulsRuntimeException;
import network.nerve.core.log.Log;
import network.nerve.core.model.ByteUtils;
import network.nerve.core.model.StringUtils;
import network.nerve.core.parse.SerializeUtils;
import org.bouncycastle.util.encoders.Hex;

public class AddressTool {
    private static AddressPrefixInf addressPrefixToolsInf = null;
    private static final String ERROR_MESSAGE = "Address prefix can not be null!";
    private static final String[] LENGTHPREFIX = new String[]{"", "a", "b", "c", "d", "e", "f", "g", "h"};
    private static final Map<Integer, byte[]> BLACK_HOLE_ADDRESS_MAP = new ConcurrentHashMap<Integer, byte[]>();
    public static Set<String> BLOCK_HOLE_ADDRESS_SET = new HashSet<String>();
    private static Map<Integer, String> ADDRESS_PREFIX_MAP;

    public static Map<Integer, String> getAddressPreFixMap() {
        return ADDRESS_PREFIX_MAP;
    }

    public static void addPrefix(int chainId, String prefix) {
        if (chainId == 1 || chainId == 2) {
            ADDRESS_PREFIX_MAP.put(chainId, prefix);
        } else {
            ADDRESS_PREFIX_MAP.put(chainId, prefix.toUpperCase());
        }
    }

    public static void init(AddressPrefixInf addressPrefixInf) {
        addressPrefixToolsInf = addressPrefixInf;
    }

    public static String getPrefix(int chainId) {
        if (chainId == 1) {
            return "NULS";
        }
        if (chainId == 2) {
            return "tNULS";
        }
        if (chainId == 9) {
            return "NERVE";
        }
        if (chainId == 5) {
            return "TNVT";
        }
        if (null == ADDRESS_PREFIX_MAP.get(chainId) && null != addressPrefixToolsInf) {
            ADDRESS_PREFIX_MAP.putAll(addressPrefixToolsInf.syncAddressPrefix());
        }
        if (null == ADDRESS_PREFIX_MAP.get(chainId)) {
            return Base58.encode(SerializeUtils.int16ToBytes(chainId)).toUpperCase();
        }
        return ADDRESS_PREFIX_MAP.get(chainId);
    }

    public static String getPrefix(String address) {
        if (address.startsWith("tNULS")) {
            return "tNULS";
        }
        if (address.startsWith("NULS")) {
            return "NULS";
        }
        if (address.startsWith("TNVT")) {
            return "TNVT";
        }
        if (address.startsWith("NERVE")) {
            return "NERVE";
        }
        char[] arr = address.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char val = arr[i];
            if (val < 'a') continue;
            return address.substring(0, i);
        }
        throw new RuntimeException(ERROR_MESSAGE);
    }

    public static String getRealAddress(String addressString) {
        if (addressString.startsWith("tNULS")) {
            return addressString.substring("tNULS".length() + 1);
        }
        if (addressString.startsWith("NULS")) {
            return addressString.substring("NULS".length() + 1);
        }
        if (addressString.startsWith("TNVT")) {
            return addressString.substring("TNVT".length() + 1);
        }
        if (addressString.startsWith("NERVE")) {
            return addressString.substring("NERVE".length() + 1);
        }
        char[] arr = addressString.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char val = arr[i];
            if (val < 'a') continue;
            return addressString.substring(i + 1);
        }
        throw new RuntimeException(ERROR_MESSAGE);
    }

    public static byte[] getAddress(String addressString) {
        try {
            return AddressTool.getAddressBytes(addressString);
        }
        catch (Exception e) {
            Log.error(e);
            throw new NulsRuntimeException(e);
        }
    }

    private static byte[] getAddressBytes(String addressString) {
        byte[] result;
        try {
            String address = AddressTool.getRealAddress(addressString);
            byte[] body = Base58.decode(address);
            result = new byte[body.length - 1];
            System.arraycopy(body, 0, result, 0, body.length - 1);
        }
        catch (Exception e) {
            Log.error(e);
            throw new NulsRuntimeException(e);
        }
        return result;
    }

    public static byte[] getAddressByRealAddr(String addressString) {
        byte[] result;
        try {
            byte[] body = Base58.decode(addressString);
            result = new byte[body.length - 1];
            System.arraycopy(body, 0, result, 0, body.length - 1);
        }
        catch (Exception e) {
            Log.error(e);
            throw new NulsRuntimeException(e);
        }
        return result;
    }

    public static int getChainIdByAddress(String addressString) {
        int chainId;
        try {
            byte[] addressBytes = AddressTool.getAddressBytes(addressString);
            NulsByteBuffer byteBuffer = new NulsByteBuffer(addressBytes);
            chainId = byteBuffer.readUint16();
        }
        catch (Exception e) {
            Log.error(e);
            throw new NulsRuntimeException(e);
        }
        return chainId;
    }

    public static byte[] getAddress(byte[] publicKey, int chainId) {
        String prefix = AddressTool.getPrefix(chainId);
        return AddressTool.getAddress(publicKey, chainId, prefix);
    }

    public static String getAddressString(byte[] publicKey, int chainId) {
        String prefix = AddressTool.getPrefix(chainId);
        byte[] addressByte = AddressTool.getAddress(publicKey, chainId, prefix);
        return AddressTool.getStringAddressByBytes(addressByte);
    }

    public static byte[] getAddressByPubKeyStr(String publicKeyStr, int chainId) {
        byte[] publicKey = HexUtil.decode(publicKeyStr);
        return AddressTool.getAddress(publicKey, chainId);
    }

    public static boolean isBlackHoleAddress(byte[] blackHolePublicKey, int chainId, byte[] address) {
        byte[] blackHoleAddress = BLACK_HOLE_ADDRESS_MAP.computeIfAbsent(chainId, k -> AddressTool.getAddress(blackHolePublicKey, chainId));
        return Arrays.equals(blackHoleAddress, address);
    }

    public static byte[] getAddress(byte[] publicKey, int chainId, String prefix) {
        if (publicKey == null) {
            return null;
        }
        byte[] hash160 = SerializeUtils.sha256hash160(publicKey);
        Address address = new Address(chainId, prefix, BaseConstant.DEFAULT_ADDRESS_TYPE, hash160);
        return address.getAddressBytes();
    }

    private static byte getXor(byte[] body) {
        byte xor = 0;
        for (int i = 0; i < body.length; ++i) {
            xor = (byte)(xor ^ body[i]);
        }
        return xor;
    }

    public static void checkXOR(byte[] hashs) {
        byte[] body = new byte[23];
        System.arraycopy(hashs, 0, body, 0, 23);
        byte xor = 0;
        for (int i = 0; i < body.length; ++i) {
            xor = (byte)(xor ^ body[i]);
        }
        if (xor != hashs[23]) {
            throw new NulsRuntimeException(new Exception());
        }
    }

    public static boolean validAddress(int chainId, String address) {
        byte type;
        int chainid;
        byte[] bytes;
        byte[] body;
        if (StringUtils.isBlank(address)) {
            return false;
        }
        try {
            String subfix = AddressTool.getRealAddress(address);
            body = Base58.decode(subfix);
            bytes = new byte[body.length - 1];
            System.arraycopy(body, 0, bytes, 0, body.length - 1);
            if (body.length != 24) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        NulsByteBuffer byteBuffer = new NulsByteBuffer(bytes);
        try {
            chainid = byteBuffer.readUint16();
            type = byteBuffer.readByte();
            byte[] hash160Bytes = byteBuffer.readBytes(20);
        }
        catch (NulsException e) {
            Log.error(e);
            return false;
        }
        if (chainId != chainid) {
            return false;
        }
        if (BaseConstant.DEFAULT_ADDRESS_TYPE != type && BaseConstant.CONTRACT_ADDRESS_TYPE != type && BaseConstant.P2SH_ADDRESS_TYPE != type) {
            return false;
        }
        try {
            AddressTool.checkXOR(body);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static int getChainIdByAddress(byte[] bytes) {
        if (null == bytes || bytes.length != 23) {
            return 0;
        }
        NulsByteBuffer byteBuffer = new NulsByteBuffer(bytes);
        try {
            return byteBuffer.readUint16();
        }
        catch (NulsException e) {
            Log.error(e);
            return 0;
        }
    }

    public static boolean validNormalAddress(byte[] bytes, int chainId) {
        return AddressTool.validAddress(bytes, chainId, BaseConstant.DEFAULT_ADDRESS_TYPE);
    }

    public static boolean validAddress(byte[] bytes, int chainId, byte type) {
        byte _type;
        int _chainId;
        if (null == bytes || bytes.length != 23) {
            return false;
        }
        NulsByteBuffer byteBuffer = new NulsByteBuffer(bytes);
        try {
            _chainId = byteBuffer.readUint16();
            _type = byteBuffer.readByte();
        }
        catch (NulsException e) {
            Log.error(e);
            return false;
        }
        if (chainId != _chainId) {
            return false;
        }
        return type == 0 || type == _type;
    }

    public static boolean validContractAddress(byte[] addressBytes, int chainId) {
        byte type;
        int chainid;
        if (addressBytes == null) {
            return false;
        }
        if (addressBytes.length != 23) {
            return false;
        }
        NulsByteBuffer byteBuffer = new NulsByteBuffer(addressBytes);
        try {
            chainid = byteBuffer.readUint16();
            type = byteBuffer.readByte();
        }
        catch (NulsException e) {
            Log.error(e);
            return false;
        }
        if (chainId != chainid) {
            return false;
        }
        return BaseConstant.CONTRACT_ADDRESS_TYPE == type;
    }

    public static String getStringAddressByBytes(byte[] addressBytes) {
        int chainId = AddressTool.getChainIdByAddress(addressBytes);
        String prefix = AddressTool.getPrefix(chainId);
        return AddressTool.getStringAddressByBytes(addressBytes, prefix);
    }

    public static String getStringAddressNoPrefix(byte[] addressBytes) {
        byte[] bytes = ByteUtils.concatenate(addressBytes, {AddressTool.getXor(addressBytes)});
        return Base58.encode(bytes);
    }

    public static String getStringAddressByBytes(byte[] addressBytes, String prefix) {
        if (addressBytes == null) {
            return null;
        }
        if (addressBytes.length != 23) {
            return null;
        }
        byte[] bytes = ByteUtils.concatenate(addressBytes, {AddressTool.getXor(addressBytes)});
        if (null != prefix) {
            return prefix + LENGTHPREFIX[prefix.length()] + Base58.encode(bytes);
        }
        return Base58.encode(bytes);
    }

    public static boolean checkPublicKeyHash(byte[] address, byte[] pubKeyHash) {
        if (address == null || pubKeyHash == null) {
            return false;
        }
        int pubKeyHashLength = pubKeyHash.length;
        if (address.length != 23 || pubKeyHashLength != 20) {
            return false;
        }
        for (int i = 0; i < pubKeyHashLength; ++i) {
            if (pubKeyHash[i] == address[i + 3]) continue;
            return false;
        }
        return true;
    }

    public static boolean isMultiSignAddress(byte[] addr) {
        if (addr != null && addr.length > 3) {
            return addr[2] == BaseConstant.P2SH_ADDRESS_TYPE;
        }
        return false;
    }

    public static boolean isMultiSignAddress(String address) {
        byte[] addr = AddressTool.getAddress(address);
        return AddressTool.isMultiSignAddress(addr);
    }

    public static boolean isNormalAddress(String address, int chainId) {
        byte type;
        int chainid;
        byte[] bytes;
        byte[] body;
        try {
            String subfix = AddressTool.getRealAddress(address);
            body = Base58.decode(subfix);
            bytes = new byte[body.length - 1];
            System.arraycopy(body, 0, bytes, 0, body.length - 1);
            if (body.length != 24) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        NulsByteBuffer byteBuffer = new NulsByteBuffer(bytes);
        try {
            chainid = byteBuffer.readUint16();
            type = byteBuffer.readByte();
            byte[] hash160Bytes = byteBuffer.readBytes(20);
        }
        catch (NulsException e) {
            Log.error(e);
            return false;
        }
        if (chainId != chainid) {
            return false;
        }
        if (BaseConstant.DEFAULT_ADDRESS_TYPE != type) {
            return false;
        }
        try {
            AddressTool.checkXOR(body);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean validSignAddress(List<byte[]> bytesList, byte[] bytes) {
        if (bytesList == null || bytesList.size() == 0 || bytes == null) {
            return false;
        }
        for (byte[] tempBytes : bytesList) {
            if (!Arrays.equals(bytes, tempBytes)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createMultiSigAccountOriginBytes(int chainId, int m, List<String> pubKeys) throws Exception {
        byte[] result = null;
        if (m < 1) {
            throw new RuntimeException();
        }
        HashSet<String> hashSet = new HashSet<String>(pubKeys);
        ArrayList<String> pubKeyList = new ArrayList<String>();
        pubKeyList.addAll(hashSet);
        if (pubKeyList.size() < m) {
            throw new RuntimeException();
        }
        Collections.sort(pubKeyList, new Comparator<String>(){
            private Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

            @Override
            public int compare(String k1, String k2) {
                return this.comparator.compare(Hex.decode((String)k1), Hex.decode((String)k2));
            }
        });
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(chainId);
            byteArrayOutputStream.write(m);
            for (String pubKey : pubKeyList) {
                byteArrayOutputStream.write(HexUtil.decode(pubKey));
            }
            result = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    static {
        BLOCK_HOLE_ADDRESS_SET.add("NERVEepb63T1M8JgQ26jwZpZXYL8ZMLdUAK31L");
        ADDRESS_PREFIX_MAP = new HashMap<Integer, String>();
    }
}

