/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import network.nerve.base.basic.AddressTool;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.CoinFrom;
import network.nerve.base.data.CoinTo;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.exception.NulsException;
import network.nerve.core.model.ByteArrayWrapper;
import network.nerve.core.parse.SerializeUtils;

public class CoinData
extends BaseNulsData {
    private List<CoinFrom> from;
    private List<CoinTo> to;

    public CoinData() {
        this.from = new ArrayList<CoinFrom>();
        this.to = new ArrayList<CoinTo>();
    }

    public CoinData(List<CoinFrom> from, List<CoinTo> to) {
        this.from = from;
        this.to = to;
    }

    public CoinData(byte[] bytes) throws NulsException {
        this.from = new ArrayList<CoinFrom>();
        this.to = new ArrayList<CoinTo>();
        this.parse(new NulsByteBuffer(bytes));
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        int fromCount = this.from == null ? 0 : this.from.size();
        stream.writeVarInt(fromCount);
        if (null != this.from) {
            for (CoinFrom coin : this.from) {
                stream.writeNulsData(coin);
            }
        }
        int toCount = this.to == null ? 0 : this.to.size();
        stream.writeVarInt(toCount);
        if (null != this.to) {
            for (CoinTo coin : this.to) {
                stream.writeNulsData(coin);
            }
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int toCount;
        int fromCount = (int)byteBuffer.readVarInt();
        if (0 < fromCount) {
            ArrayList<CoinFrom> from = new ArrayList<CoinFrom>();
            for (int i = 0; i < fromCount; ++i) {
                from.add(byteBuffer.readNulsData(new CoinFrom()));
            }
            this.from = from;
        }
        if (0 < (toCount = (int)byteBuffer.readVarInt())) {
            ArrayList<CoinTo> to = new ArrayList<CoinTo>();
            for (int i = 0; i < toCount; ++i) {
                to.add(byteBuffer.readNulsData(new CoinTo()));
            }
            this.to = to;
        }
    }

    @Override
    public int size() {
        int size = SerializeUtils.sizeOfVarInt(this.from == null ? 0 : this.from.size());
        if (null != this.from) {
            for (CoinFrom coinFrom : this.from) {
                size += SerializeUtils.sizeOfNulsData(coinFrom);
            }
        }
        size += SerializeUtils.sizeOfVarInt(this.to == null ? 0 : this.to.size());
        if (null != this.to) {
            for (CoinTo coinTo : this.to) {
                size += SerializeUtils.sizeOfNulsData(coinTo);
            }
        }
        return size;
    }

    public List<CoinFrom> getFrom() {
        return this.from;
    }

    public void setFrom(List<CoinFrom> from) {
        this.from = from;
    }

    public List<CoinTo> getTo() {
        return this.to;
    }

    public void setTo(List<CoinTo> to) {
        this.to = to;
    }

    public void addTo(CoinTo coinTo) {
        if (null == this.to) {
            this.to = new ArrayList<CoinTo>();
        }
        this.to.add(coinTo);
    }

    public void addFrom(CoinFrom coinFrom) {
        if (null == this.from) {
            this.from = new ArrayList<CoinFrom>();
        }
        this.from.add(coinFrom);
    }

    @JsonIgnore
    public Set<byte[]> getAddresses() {
        ByteArrayWrapper baw;
        byte[] address;
        HashSet<ByteArrayWrapper> addressSetWrapper = new HashSet<ByteArrayWrapper>();
        if (this.to != null && this.to.size() != 0) {
            for (CoinTo coinTo : this.to) {
                address = coinTo.getAddress();
                baw = new ByteArrayWrapper(address);
                addressSetWrapper.add(baw);
            }
        }
        if (this.from != null && this.from.size() != 0) {
            for (CoinFrom coinFrom : this.from) {
                address = coinFrom.getAddress();
                baw = new ByteArrayWrapper(address);
                addressSetWrapper.add(baw);
            }
        }
        HashSet<byte[]> addressSet = new HashSet<byte[]>();
        for (ByteArrayWrapper byteArrayWrapper : addressSetWrapper) {
            addressSet.add(byteArrayWrapper.getBytes());
        }
        return addressSet;
    }

    public Set<String> getFromAddressList() {
        HashSet<String> fromAddressList = new HashSet<String>();
        if (this.from != null && !this.from.isEmpty()) {
            for (CoinFrom coinFrom : this.from) {
                fromAddressList.add(AddressTool.getStringAddressByBytes(coinFrom.getAddress()));
            }
        }
        return fromAddressList;
    }

    public int getFromAddressCount() {
        HashSet<String> addressSet = new HashSet<String>();
        for (CoinFrom coinFrom : this.from) {
            addressSet.add(AddressTool.getStringAddressByBytes(coinFrom.getAddress()));
        }
        return addressSet.size();
    }

    public BigInteger getFeeByAsset(int assetChainId, int assetId) {
        BigInteger fromAmount = BigInteger.ZERO;
        BigInteger toAmount = BigInteger.ZERO;
        for (CoinFrom coinFrom : this.from) {
            if (coinFrom.getAssetsChainId() != assetChainId || coinFrom.getAssetsId() != assetId) continue;
            fromAmount = fromAmount.add(coinFrom.getAmount());
        }
        for (CoinTo coinTo : this.to) {
            if (coinTo.getAssetsChainId() != assetChainId || coinTo.getAssetsId() != assetId) continue;
            toAmount = toAmount.add(coinTo.getAmount());
        }
        return fromAmount.subtract(toAmount);
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        if (this.from == null) {
            builder.append("\tcoinFrom: null").append(lineSeparator);
        } else if (this.from.size() == 0) {
            builder.append("\tcoinFrom: size 0").append(lineSeparator);
        } else {
            builder.append("\tcoinFrom: ").append(lineSeparator);
            for (i = 0; i < this.from.size(); ++i) {
                CoinFrom coinFrom = this.from.get(i);
                builder.append(String.format("\t\tfroms-%s:", i)).append(lineSeparator);
                builder.append(String.format("\t\t\taddress: %s", AddressTool.getStringAddressByBytes(coinFrom.getAddress()))).append(lineSeparator);
                builder.append(String.format("\t\t\tamount: %s", coinFrom.getAmount())).append(lineSeparator);
                builder.append(String.format("\t\t\tassetChainId: %s", coinFrom.getAssetsChainId())).append(lineSeparator);
                builder.append(String.format("\t\t\tassetId: %s", coinFrom.getAssetsId())).append(lineSeparator);
                builder.append(String.format("\t\t\tnonce: %s", HexUtil.encode(coinFrom.getNonce()))).append(lineSeparator);
                builder.append(String.format("\t\t\tlocked: %s", coinFrom.getLocked())).append("\t(0\u666e\u901a\u4ea4\u6613\uff0c-1\u89e3\u9501\u91d1\u989d\u4ea4\u6613\uff08\u9000\u51fa\u5171\u8bc6\uff0c\u9000\u51fa\u59d4\u6258))").append(lineSeparator);
                builder.append(lineSeparator);
            }
        }
        if (this.to == null) {
            builder.append("\tcoinTo: null").append(lineSeparator);
        } else if (this.to.size() == 0) {
            builder.append("\tcoinTo: size 0").append(lineSeparator);
        } else {
            builder.append("\tcoinTo: ").append(lineSeparator);
            for (i = 0; i < this.to.size(); ++i) {
                CoinTo coinTo = this.to.get(i);
                builder.append(String.format("\t\ttos-%s:", i)).append(lineSeparator);
                builder.append(String.format("\t\t\taddress: %s", AddressTool.getStringAddressByBytes(coinTo.getAddress()))).append(lineSeparator);
                builder.append(String.format("\t\t\tamount: %s", coinTo.getAmount())).append(lineSeparator);
                builder.append(String.format("\t\t\tassetChainId: %s", coinTo.getAssetsChainId())).append(lineSeparator);
                builder.append(String.format("\t\t\tassetId: %s", coinTo.getAssetsId())).append(lineSeparator);
                builder.append(String.format("\t\t\tlocked: %s", coinTo.getLockTime())).append("\t(\u89e3\u9501\u9ad8\u5ea6\u6216\u89e3\u9501\u65f6\u95f4\uff0c-1\u4e3a\u6c38\u4e45\u9501\u5b9a)").append(lineSeparator);
                builder.append(lineSeparator);
            }
        }
        return builder.toString();
    }
}

