/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import java.io.IOException;
import java.math.BigInteger;
import network.nerve.base.basic.AddressTool;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.Coin;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;

public class CoinTo
extends Coin {
    private long lockTime;

    public CoinTo() {
    }

    public CoinTo(byte[] address, int assetsChainId, int assetsId, BigInteger amount) {
        this.address = address;
        this.assetsChainId = assetsChainId;
        this.assetsId = assetsId;
        this.amount = amount;
    }

    public CoinTo(byte[] address, int assetsChainId, int assetsId, BigInteger amount, long lockTime) {
        this(address, assetsChainId, assetsId, amount);
        this.lockTime = lockTime;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBytesWithLength(this.address);
        stream.writeUint16(this.assetsChainId);
        stream.writeUint16(this.assetsId);
        stream.writeBigInteger(this.amount);
        stream.writeInt64(this.lockTime);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.address = byteBuffer.readByLengthByte();
        this.assetsChainId = byteBuffer.readUint16();
        this.assetsId = byteBuffer.readUint16();
        this.amount = byteBuffer.readBigInteger();
        this.lockTime = byteBuffer.readInt64();
    }

    @Override
    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfBytes(this.address);
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfBigInteger();
        return size += SerializeUtils.sizeOfInt64();
    }

    public String toString() {
        return "CoinTo{address=" + AddressTool.getStringAddressByBytes(this.address) + ", assetsChainId=" + this.assetsChainId + ", assetsId=" + this.assetsId + ", amount=" + this.amount + ", lockTime=" + this.lockTime + '}';
    }

    @Override
    public byte[] getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(byte[] address) {
        this.address = address;
    }

    @Override
    public int getAssetsChainId() {
        return this.assetsChainId;
    }

    @Override
    public void setAssetsChainId(int assetsChainId) {
        this.assetsChainId = assetsChainId;
    }

    @Override
    public int getAssetsId() {
        return this.assetsId;
    }

    @Override
    public void setAssetsId(int assetsId) {
        this.assetsId = assetsId;
    }

    @Override
    public BigInteger getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public long getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(long lockTime) {
        this.lockTime = lockTime;
    }
}

