/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.Address;
import network.nerve.base.data.BaseNulsData;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;

public class MultiSigAccount
extends BaseNulsData {
    private int chainId;
    private Address address;
    private byte m;
    private List<byte[]> pubKeyList;
    private String alias;

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint32(this.chainId);
        stream.write(this.address.getAddressBytes());
        stream.write(this.m);
        stream.writeUint32(this.pubKeyList.size());
        for (int i = 0; i < this.pubKeyList.size(); ++i) {
            stream.writeBytesWithLength(this.pubKeyList.get(i));
        }
        stream.writeString(this.alias);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readInt32();
        byte[] bytes = byteBuffer.readBytes(23);
        this.address = Address.fromHashs(bytes);
        this.m = byteBuffer.readByte();
        this.pubKeyList = new ArrayList<byte[]>();
        long count = byteBuffer.readUint32();
        int i = 0;
        while ((long)i < count) {
            this.pubKeyList.add(byteBuffer.readByLengthByte());
            ++i;
        }
        this.alias = byteBuffer.readString();
    }

    @Override
    public int size() {
        int size = SerializeUtils.sizeOfUint32();
        size += 23;
        ++size;
        size += SerializeUtils.sizeOfUint32();
        for (int i = 0; i < this.pubKeyList.size(); ++i) {
            size += SerializeUtils.sizeOfBytes(this.pubKeyList.get(i));
        }
        return size += SerializeUtils.sizeOfString(this.alias);
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public List<byte[]> getPubKeyList() {
        return this.pubKeyList;
    }

    public void setPubKeyList(List<byte[]> pubKeyList) {
        this.pubKeyList = pubKeyList;
    }

    public byte getM() {
        return this.m;
    }

    public void setM(byte m) {
        this.m = m;
    }

    public void addPubkeys(List<String> pubkeys) {
        this.pubKeyList = new ArrayList<byte[]>();
        for (String pubkeyStr : pubkeys) {
            this.pubKeyList.add(HexUtil.decode(pubkeyStr));
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSigAccount that = (MultiSigAccount)o;
        return this.chainId == that.chainId && this.m == that.m && Objects.equal((Object)this.address, (Object)that.address) && Objects.equal(this.pubKeyList, that.pubKeyList) && Objects.equal((Object)this.alias, (Object)that.alias);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.chainId, this.address, this.m, this.pubKeyList, this.alias});
    }
}

