/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import network.nerve.core.core.annotation.Component;
import network.nerve.core.core.config.IniModuleConfigParser;
import network.nerve.core.core.config.JsonModuleConfigParser;
import network.nerve.core.core.config.ModuleConfigParser;
import network.nerve.core.core.config.NcfModuleConfigParser;
import network.nerve.core.core.config.PropertiesModuleConfigParser;
import network.nerve.core.core.config.persist.PersistManager;
import network.nerve.core.log.Log;
import network.nerve.core.model.StringUtils;

@Component
public class ConfigurationLoader {
    private static final String JVM_OPTION_ACTIVE_MODULE = "active.config";
    public static final String GLOBAL_DOMAIN = "global";
    Map<String, Map<String, ConfigItem>> configData = new HashMap<String, Map<String, ConfigItem>>();
    Map<String, Map<String, String>> persistConfigData = new HashMap<String, Map<String, String>>();
    Map<String, ModuleConfigParser> parserMap = new HashMap<String, ModuleConfigParser>();

    public ConfigurationLoader() {
        this.configData.put(GLOBAL_DOMAIN, new HashMap());
        JsonModuleConfigParser json = new JsonModuleConfigParser();
        this.parserMap.put(json.fileSuffix(), json);
        IniModuleConfigParser ini = new IniModuleConfigParser();
        this.parserMap.put(ini.fileSuffix(), ini);
        NcfModuleConfigParser ncf = new NcfModuleConfigParser();
        this.parserMap.put(ncf.fileSuffix(), ncf);
        PropertiesModuleConfigParser properties = new PropertiesModuleConfigParser();
        this.parserMap.put(properties.fileSuffix(), properties);
    }

    public void load() {
        this.loadResourceModule();
        this.loadJarPathModule();
        this.loadJvmActiveModuleFile();
        this.loadJvmOptionConfigItem();
        this.loadForPersist();
        if (this.configData.isEmpty()) {
            Log.info("config item list is empty");
            return;
        }
    }

    private void loadJvmOptionConfigItem() {
        this.configData.values().forEach(configItemList -> configItemList.entrySet().stream().forEach(entry -> {
            if (StringUtils.isNotBlank(System.getProperty((String)entry.getKey()))) {
                configItemList.put(entry.getKey(), new ConfigItem("JAVA_OPTS:-D" + (String)entry.getKey(), System.getProperty((String)entry.getKey())));
            }
        }));
    }

    private void loadForPersist() {
        this.persistConfigData = PersistManager.loadPersist();
    }

    private void loadJvmActiveModuleFile() {
        String fileName = System.getProperty(JVM_OPTION_ACTIVE_MODULE);
        if (StringUtils.isNotBlank(fileName)) {
            this.parserMap.forEach((key, value) -> {
                if (fileName.endsWith((String)key)) {
                    this.loadForFile(fileName, (ModuleConfigParser)value);
                }
            });
        }
    }

    private void loadJarPathModule() {
        this.parserMap.forEach((key, value) -> this.loadForFile(value.getFileName(), (ModuleConfigParser)value));
    }

    private void loadForFile(String fileName, ModuleConfigParser parser) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            try {
                Log.info("found config file : {}", file.getAbsolutePath());
                this.mergeConfigItem(parser.parse(file.getAbsolutePath(), new FileInputStream(file)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        StringBuilder newFileName = new StringBuilder();
        for (int i = 0; i < fileName.length(); ++i) {
            if (i == 0) {
                newFileName.append(String.valueOf(fileName.charAt(i)).toUpperCase());
                continue;
            }
            newFileName.append(fileName.charAt(i));
        }
        file = new File(newFileName.toString());
        if (file.exists() && file.isFile()) {
            Log.info("found config file : {}", newFileName.toString());
            try {
                this.mergeConfigItem(parser.parse(file.getAbsolutePath(), new FileInputStream(file)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void loadResourceModule() {
        this.parserMap.forEach((key, value) -> {
            URL url = this.getClass().getClassLoader().getResource(value.getFileName());
            if (url == null) {
                return;
            }
            Log.info("found config file : {}", value.getFileName());
            try {
                this.mergeConfigItem(value.parse(url.getPath(), url.openStream()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public Map<String, Map<String, ConfigItem>> getConfigData() {
        return this.configData;
    }

    public String getValue(String domain, String key) {
        ConfigItem configItem = this.getConfigItem(domain, key);
        if (configItem == null) {
            return null;
        }
        return configItem.value;
    }

    public String getValue(String key) {
        return this.getValue(GLOBAL_DOMAIN, key);
    }

    public ConfigItem getConfigItemForGolbal(String key) {
        return this.configData.get(GLOBAL_DOMAIN).get(key);
    }

    public ConfigItem getConfigItem(String key) {
        List dataList = this.configData.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(GLOBAL_DOMAIN)).map(e -> (Map)e.getValue()).collect(Collectors.toList());
        for (Map items : dataList) {
            if (!items.containsKey(key)) continue;
            return (ConfigItem)items.get(key);
        }
        return this.getConfigItemForGolbal(key);
    }

    public ConfigItem getConfigItem(String domain, String key) {
        if (!this.configData.containsKey(domain)) {
            ConfigItem res = this.getConfigItemForGolbal(key);
            return res;
        }
        ConfigItem item = this.configData.get(domain).get(key);
        if (item == null) {
            ConfigItem res = this.getConfigItemForGolbal(key);
            return res;
        }
        return item;
    }

    public ConfigItem getConfigItemForPersist(String persistDomain, String key) {
        Map<String, String> persistConfig = this.persistConfigData.get(persistDomain);
        if (persistConfig == null) {
            return this.getConfigItem(persistDomain, key);
        }
        String persistConfigValue = persistConfig.get(key);
        if (persistConfigValue != null) {
            return new ConfigItem("PERSIST", persistConfigValue);
        }
        return this.getConfigItem(persistDomain, key);
    }

    private void mergeConfigItem(Map<String, Map<String, ConfigItem>> configItems) {
        configItems.entrySet().stream().forEach(entry -> {
            if (!this.configData.containsKey(entry.getKey())) {
                this.configData.put((String)entry.getKey(), (Map<String, ConfigItem>)entry.getValue());
            } else {
                this.configData.get(entry.getKey()).putAll((Map)entry.getValue());
            }
        });
    }

    public static class ConfigItem {
        String value;
        String configFile;

        public ConfigItem(String configFile, String value) {
            this.configFile = configFile;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getConfigFile() {
            return this.configFile;
        }
    }
}

