/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.log.logback;

import ch.qos.logback.access.PatternLayoutEncoder;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import network.nerve.core.log.logback.LogFilter;
import network.nerve.core.model.StringUtils;
import org.slf4j.LoggerFactory;

public class LogAppender {
    public static String PROJECT_PATH = StringUtils.isNotBlank(System.getProperty("log.path")) ? System.getProperty("log.path") : System.getProperty("user.dir") + File.separator + "logs";

    public static RollingFileAppender getAppender(String fileName, Level level) {
        String rootPath = PROJECT_PATH;
        if (!rootPath.endsWith(File.separator)) {
            rootPath = rootPath + File.separator;
        }
        if (fileName.startsWith(File.separator)) {
            fileName = fileName.substring(1);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)context);
        LogFilter levelController = new LogFilter();
        ThresholdFilter levelFilter = levelController.getThresholdFilter(level);
        levelFilter.start();
        appender.addFilter((Filter)levelFilter);
        appender.setFile(OptionHelper.substVars((String)(rootPath + fileName + ".log"), (PropertyContainer)context));
        appender.setAppend(true);
        appender.setPrudent(false);
        SizeAndTimeBasedRollingPolicy policy = new SizeAndTimeBasedRollingPolicy();
        String fp = OptionHelper.substVars((String)(rootPath + fileName + ".%d{yyyy-MM-dd}.%i.zip"), (PropertyContainer)context);
        policy.setMaxFileSize(FileSize.valueOf((String)"100MB"));
        policy.setFileNamePattern(fp);
        policy.setMaxHistory(7);
        policy.setContext((Context)context);
        policy.setTotalSizeCap(FileSize.valueOf((String)"1GB"));
        policy.setParent((FileAppender)appender);
        policy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern("%d %p [%t] - %msg%n");
        encoder.start();
        appender.setRollingPolicy((RollingPolicy)policy);
        appender.setEncoder((Encoder)encoder);
        appender.start();
        return appender;
    }

    public static Appender<ILoggingEvent> createConsoleAppender(Level level) {
        ConsoleAppender appender = new ConsoleAppender();
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        appender.setContext((Context)context);
        LogFilter levelController = new LogFilter();
        ThresholdFilter levelFilter = levelController.getThresholdFilter(level);
        levelFilter.start();
        appender.addFilter((Filter)levelFilter);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern("%d %p [%t] - %msg%n");
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        appender.start();
        return appender;
    }
}

