/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.model;

import java.util.Objects;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper> {
    private final byte[] data;
    private final int offset;
    private final int length;
    private int hash;

    public ByteArrayWrapper(byte[] data) {
        Objects.requireNonNull(data, "array is null");
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)o;
        if (this.length != byteArrayWrapper.length) {
            return false;
        }
        if (this.offset == byteArrayWrapper.offset && this.data == byteArrayWrapper.data) {
            return true;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.data[this.offset + i] == byteArrayWrapper.data[byteArrayWrapper.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int result = this.length;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            result = 31 * result + this.data[i];
        }
        if (result == 0) {
            result = 1;
        }
        this.hash = result;
        return this.hash;
    }

    @Override
    public int compareTo(ByteArrayWrapper that) {
        if (this == that) {
            return 0;
        }
        if (this.data == that.data && this.length == that.length && this.offset == that.offset) {
            return 0;
        }
        int minLength = Math.min(this.length, that.length);
        for (int i = 0; i < minLength; ++i) {
            int thisByte = 0xFF & this.data[this.offset + i];
            int thatByte = 0xFF & that.data[that.offset + i];
            if (thisByte == thatByte) continue;
            return thisByte - thatByte;
        }
        return this.length - that.length;
    }
}

