/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.modulebootstrap;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import network.nerve.core.core.ioc.SpringLiteContext;
import network.nerve.core.log.Log;
import network.nerve.core.parse.MapUtils;
import network.nerve.core.rpc.invoke.BaseInvoke;
import network.nerve.core.rpc.model.message.Response;
import network.nerve.core.rpc.modulebootstrap.Module;
import network.nerve.core.rpc.modulebootstrap.NotifySender;
import network.nerve.core.rpc.modulebootstrap.RpcModule;
import network.nerve.core.rpc.netty.channel.manager.ConnectManager;
import network.nerve.core.rpc.netty.processor.ResponseMessageProcessor;

public class RegisterInvoke
extends BaseInvoke {
    Set<Module> dependenices;
    Module module;

    public RegisterInvoke(Module module, Set<Module> dependenices) {
        this.dependenices = dependenices;
        this.module = module;
    }

    @Override
    public void callBack(Response response) {
        Map responseData = (Map)response.getResponseData();
        if (response.isSuccess()) {
            RpcModule rpcModule = SpringLiteContext.getBean(RpcModule.class);
            if (rpcModule.getDependencies().isEmpty()) {
                Log.info("RMB:module rpc is ready");
                return;
            }
            Map methodMap = (Map)responseData.get("RegisterAPI");
            Map dependMap = (Map)methodMap.get("Dependencies");
            StringBuilder logInfo = new StringBuilder("\n\u6709\u6a21\u5757\u4fe1\u606f\u6539\u53d8\uff0c\u91cd\u65b0\u540c\u6b65\uff1a\n");
            Iterator iterator = dependMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                logInfo.append("\u6ce8\u5165\uff1a[key=").append((String)entry.getKey()).append(",value=").append(entry.getValue()).append("]\n");
                ConnectManager.ROLE_MAP.put((String)entry.getKey(), (Map)entry.getValue());
            }
            Log.debug(logInfo.toString());
            ConnectManager.updateStatus();
            if (!ConnectManager.isReady()) {
                return;
            }
            Log.info("RMB:module rpc is ready");
            dependMap.entrySet().forEach(obj -> {
                Map.Entry entry = (Map.Entry)obj;
                if (this.dependenices.stream().anyMatch(d -> d.getName().equals(entry.getKey()))) {
                    if (rpcModule.isDependencieReady((String)entry.getKey())) {
                        return;
                    }
                    NotifySender notifySender = SpringLiteContext.getBean(NotifySender.class);
                    notifySender.send("registerModuleDependent_" + (String)entry.getKey(), 10, () -> {
                        Response cmdResp = null;
                        try {
                            cmdResp = ResponseMessageProcessor.requestAndResponse((String)entry.getKey(), "registerModuleDependencies", MapUtils.beanToLinkedMap(this.module));
                            Log.debug("registerModuleDependent : {},result:{}", entry.getKey(), cmdResp);
                            return cmdResp.isSuccess();
                        }
                        catch (Exception e) {
                            Log.error("Calling remote interface failed. module:{} - interface:{} - message:{}", this.module, "registerModuleDependencies", e.getMessage());
                            return false;
                        }
                    });
                }
            });
        }
    }
}

