/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.thread.commom;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import network.nerve.core.thread.ThreadUtils;

public class NulsThreadFactory
implements ThreadFactory {
    private final String poolName;
    private AtomicInteger threadNo = new AtomicInteger(1);

    public NulsThreadFactory(String poolName) {
        this.poolName = poolName;
    }

    @Override
    public final Thread newThread(Runnable r) {
        String threadName;
        if (this.threadNo.get() == 1) {
            this.threadNo.incrementAndGet();
            threadName = this.poolName;
        } else {
            threadName = this.poolName + "-" + this.threadNo.getAndIncrement();
        }
        Thread newThread = new Thread(r, threadName);
        if (newThread.getPriority() != 5) {
            newThread.setPriority(5);
        }
        ThreadUtils.putThread(this.poolName, threadName, newThread);
        return newThread;
    }

    public String getPoolName() {
        return this.poolName;
    }
}

