/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import network.nerve.core.basic.Result;
import network.nerve.core.constant.ErrorCode;
import network.nerve.core.exception.NulsException;
import network.nerve.kit.error.AccountErrorCode;
import network.nerve.kit.model.dto.CreateAgentForm;
import network.nerve.kit.model.dto.DepositForm;
import network.nerve.kit.model.dto.RestFulResult;
import network.nerve.kit.model.dto.StopAgentForm;
import network.nerve.kit.model.dto.WithdrawForm;
import network.nerve.kit.util.CommonValidator;
import network.nerve.kit.util.RestFulUtil;
import network.nerve.kit.util.ValidateUtil;

public class ConsensusService {
    private static ConsensusService instance = new ConsensusService();

    private ConsensusService() {
    }

    public static ConsensusService getInstance() {
        return instance;
    }

    public Result createAgent(CreateAgentForm form) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            CommonValidator.validateCreateAgentForm(form);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("agentAddress", form.getAgentAddress());
            map.put("packingAddress", form.getPackingAddress());
            map.put("rewardAddress", form.getRewardAddress());
            map.put("commissionRate", form.getCommissionRate());
            map.put("deposit", form.getDeposit());
            map.put("password", form.getPassword());
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/consensus/agent", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result stopAgent(StopAgentForm form) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            CommonValidator.validateStopAgentForm(form);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("address", form.getAgentAddress());
            map.put("password", form.getPassword());
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/consensus/agent/stop", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result depositToAgent(DepositForm form) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            CommonValidator.validateDepositForm(form);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("address", form.getAddress());
            map.put("agentHash", form.getAgentHash());
            map.put("deposit", form.getDeposit());
            map.put("password", form.getPassword());
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/consensus/deposit", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result withdraw(WithdrawForm form) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            CommonValidator.validateWithDrawForm(form);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("address", form.getAddress());
            map.put("txHash", form.getTxHash());
            map.put("password", form.getPassword());
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/consensus/withdraw", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result getDepositList(String agentHash) {
        Result result;
        if (!ValidateUtil.validHash(agentHash)) {
            return Result.getFailed(AccountErrorCode.PARAMETER_ERROR);
        }
        RestFulResult<List<Object>> restFulResult = RestFulUtil.getList("api/consensus/list/deposit/" + agentHash, null);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }
}

