/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.util;

import com.google.common.primitives.UnsignedBytes;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import network.nerve.base.data.Address;
import network.nerve.base.data.MultiSigAccount;
import network.nerve.core.constant.BaseConstant;
import network.nerve.core.crypto.ECKey;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.crypto.Sha256Hash;
import network.nerve.core.exception.NulsException;
import network.nerve.core.exception.NulsRuntimeException;
import network.nerve.core.log.Log;
import network.nerve.core.model.StringUtils;
import network.nerve.core.parse.SerializeUtils;
import network.nerve.core.rpc.util.NulsDateUtils;
import network.nerve.kit.constant.AccountConstant;
import network.nerve.kit.error.AccountErrorCode;
import network.nerve.kit.model.Account;
import network.nerve.kit.util.ValidateUtil;
import org.bouncycastle.util.encoders.Hex;

public class AccountTool {
    public static final int CREATE_MAX_SIZE = 100;
    public static final int CREATE_MULTI_SIGACCOUNT_MIN_SIZE = 2;

    public static Address newAddress(int chainId, String prikey) {
        ECKey key;
        try {
            key = ECKey.fromPrivate(new BigInteger(1, HexUtil.decode(prikey)));
        }
        catch (Exception e) {
            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
        }
        return AccountTool.newAddress(chainId, key.getPubKey());
    }

    public static Address newAddress(int chainId, ECKey key) {
        return AccountTool.newAddress(chainId, key.getPubKey());
    }

    public static Address newAddress(int chainId, byte[] publicKey) {
        return new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160(publicKey));
    }

    public static Account createAccount(int chainId, String prikey, String prefix) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank(prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate(new BigInteger(1, HexUtil.decode(prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, prefix, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160(key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount1(int chainId, String prikey, String prefix) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank(prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate(new BigInteger(HexUtil.decode(prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, prefix, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160(key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount(int chainId, String prikey) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank(prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate(new BigInteger(1, HexUtil.decode(prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160(key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount1(int chainId, String prikey) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank(prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate(new BigInteger(HexUtil.decode(prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160(key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount(int chainId) throws NulsException {
        return AccountTool.createAccount(chainId, null);
    }

    public static Account createAccount1(int chainId) throws NulsException {
        return AccountTool.createAccount1(chainId, null);
    }

    public static Address createContractAddress(int chainId) {
        ECKey key = new ECKey();
        return new Address(chainId, BaseConstant.CONTRACT_ADDRESS_TYPE, SerializeUtils.sha256hash160(key.getPubKey()));
    }

    public static BigInteger genPrivKey(byte[] encryptedPriKey, byte[] pw) {
        byte[] privSeedSha256 = Sha256Hash.hash(encryptedPriKey);
        byte[] pwSha256 = Sha256Hash.hash(pw);
        byte[] pwPriBytes = new byte[privSeedSha256.length + pwSha256.length];
        for (int i = 0; i < pwPriBytes.length; i += 2) {
            int index = i / 2;
            pwPriBytes[index] = privSeedSha256[index];
            pwPriBytes[index + 1] = pwSha256[index];
        }
        return new BigInteger(1, Sha256Hash.hash(pwPriBytes));
    }

    public static byte[] createMultiSigAccountOriginBytes(int chainId, int n, List<String> pubKeys) throws NulsException {
        byte[] result = null;
        if (n < 2 || (pubKeys == null ? 0 : pubKeys.size()) < n) {
            throw new NulsRuntimeException(AccountErrorCode.FAILED);
        }
        HashSet<String> hashSet = new HashSet<String>(pubKeys);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(hashSet);
        if (pubKeys.size() < n) {
            throw new NulsRuntimeException(AccountErrorCode.FAILED);
        }
        Collections.sort(list, AccountConstant.PUBKEY_COMPARATOR);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(chainId);
            byteArrayOutputStream.write(n);
            for (String pubKey : pubKeys) {
                byteArrayOutputStream.write(HexUtil.decode(pubKey));
            }
            result = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            Log.error("", e);
            throw new NulsRuntimeException(AccountErrorCode.FAILED);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static MultiSigAccount createMultiSigAccount(int chainId, List<String> pubKeys, int minSigns) throws NulsException {
        HashSet<String> pubkeySet = new HashSet<String>(pubKeys);
        if (pubkeySet.size() < pubKeys.size()) {
            throw new NulsException(AccountErrorCode.PUBKEY_REPEAT);
        }
        pubKeys = new ArrayList<String>(pubKeys);
        Collections.sort(pubKeys, new Comparator<String>(){
            private Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

            @Override
            public int compare(String k1, String k2) {
                return this.comparator.compare(Hex.decode((String)k1), Hex.decode((String)k2));
            }
        });
        Address address = new Address(chainId, BaseConstant.P2SH_ADDRESS_TYPE, SerializeUtils.sha256hash160(AccountTool.createMultiSigAccountOriginBytes(chainId, minSigns, pubKeys)));
        MultiSigAccount multiSigAccount = new MultiSigAccount();
        multiSigAccount.setChainId(chainId);
        multiSigAccount.setAddress(address);
        multiSigAccount.setM((byte)minSigns);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (String pubKey : pubKeys) {
            list.add(HexUtil.decode(pubKey));
        }
        multiSigAccount.setPubKeyList(list);
        return multiSigAccount;
    }

    public static String getPrefix(String address) {
        for (int i = 1; i < address.length(); ++i) {
            char c = address.charAt(i);
            if (!ValidateUtil.regexMatch(c + "", "^[a-z]{1}$")) continue;
            return address.substring(0, i);
        }
        return null;
    }
}

