/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import network.nerve.SDKContext;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.data.Transaction;
import network.nerve.core.basic.Result;
import network.nerve.core.constant.CommonCodeConstanst;
import network.nerve.core.constant.ErrorCode;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.exception.NulsException;
import network.nerve.core.rpc.model.Key;
import network.nerve.core.rpc.model.Parameter;
import network.nerve.core.rpc.model.Parameters;
import network.nerve.core.rpc.model.ResponseData;
import network.nerve.core.rpc.model.TypeDescriptor;
import network.nerve.kit.model.annotation.ApiOperation;
import network.nerve.kit.model.dto.AccountBalanceDto;
import network.nerve.kit.model.dto.AccountDto;
import network.nerve.kit.model.dto.AccountKeyStoreDto;
import network.nerve.kit.model.dto.AliasDto;
import network.nerve.kit.model.dto.BlockDto;
import network.nerve.kit.model.dto.BlockHeaderDto;
import network.nerve.kit.model.dto.CrossTransferForm;
import network.nerve.kit.model.dto.CrossTransferTxFeeDto;
import network.nerve.kit.model.dto.MultiSignAliasDto;
import network.nerve.kit.model.dto.MultiSignTransferDto;
import network.nerve.kit.model.dto.MultiSignTransferTxFeeDto;
import network.nerve.kit.model.dto.RpcResult;
import network.nerve.kit.model.dto.RpcResultError;
import network.nerve.kit.model.dto.SignDto;
import network.nerve.kit.model.dto.TransactionDto;
import network.nerve.kit.model.dto.TransferDto;
import network.nerve.kit.model.dto.TransferForm;
import network.nerve.kit.model.dto.TransferTxFeeDto;
import network.nerve.kit.model.dto.WithdrawalTxDto;
import network.nerve.kit.service.AccountService;
import network.nerve.kit.service.BlockService;
import network.nerve.kit.service.ConsensusService;
import network.nerve.kit.service.TransactionService;
import network.nerve.kit.util.JsonRpcUtil;
import network.nerve.kit.util.ListUtil;

public class NerveSDKTool {
    private static AccountService accountService = AccountService.getInstance();
    private static TransactionService transactionService = TransactionService.getInstance();
    private static BlockService blockService = BlockService.getInstance();
    private static ConsensusService consensusService = ConsensusService.getInstance();

    @ApiOperation(description="\u83b7\u53d6\u672c\u94fe\u76f8\u5173\u4fe1\u606f,\u5176\u4e2d\u5171\u8bc6\u8d44\u4ea7\u4e3a\u672c\u94fe\u521b\u5efa\u5171\u8bc6\u8282\u70b9\u4ea4\u6613\u548c\u521b\u5efa\u59d4\u6258\u5171\u8bc6\u4ea4\u6613\u65f6\uff0c\u9700\u8981\u7528\u5230\u7684\u8d44\u4ea7", order=1)
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u672c\u94fe\u4fe1\u606f", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="chainId", description="\u672c\u94fe\u7684ID"), @Key(name="assetId", description="\u672c\u94fe\u9ed8\u8ba4\u4e3b\u8d44\u4ea7\u7684ID"), @Key(name="inflationAmount", description="\u672c\u94fe\u9ed8\u8ba4\u4e3b\u8d44\u4ea7\u7684\u521d\u59cb\u6570\u91cf"), @Key(name="agentChainId", description="\u672c\u94fe\u5171\u8bc6\u8d44\u4ea7\u7684\u94feID"), @Key(name="agentAssetId", description="\u672c\u94fe\u5171\u8bc6\u8d44\u4ea7\u7684ID")}))
    public static Result<Map> getInfo() {
        return blockService.getInfo();
    }

    @ApiOperation(description="\u6279\u91cf\u521b\u5efa\u8d26\u6237", order=101, detailDesc="\u521b\u5efa\u7684\u8d26\u6237\u5b58\u5728\u4e8e\u672c\u5730\u94b1\u5305\u5185")
    @Parameters(value={@Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="\u521b\u5efa\u6570\u91cf"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u8d26\u6237\u5730\u5740\u96c6\u5408", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public static Result<List<String>> createAccount(int count, String password) {
        return accountService.createAccount(count, password);
    }

    @ApiOperation(description="\u4fee\u6539\u8d26\u6237\u5bc6\u7801", order=102)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="oldPassword", parameterDes="\u539f\u5bc6\u7801"), @Parameter(parameterName="newPassword", parameterDes="\u65b0\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="\u662f\u5426\u4fee\u6539\u6210\u529f")}))
    public static Result resetPassword(String address, String oldPassword, String newPassword) {
        return accountService.resetPassword(address, oldPassword, newPassword);
    }

    @ApiOperation(description="\u5bfc\u51fa\u8d26\u6237\u79c1\u94a5", order=103, detailDesc="\u53ea\u80fd\u5bfc\u51fa\u672c\u5730\u94b1\u5305\u5df2\u5b58\u5728\u8d26\u6237\u7684\u79c1\u94a5")
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u79c1\u94a5")}))
    public static Result getPriKey(String address, String password) {
        return accountService.getPriKey(address, password);
    }

    @ApiOperation(description="\u6839\u636e\u79c1\u94a5\u5bfc\u5165\u8d26\u6237", order=104, detailDesc="\u5bfc\u5165\u79c1\u94a5\u65f6\uff0c\u9700\u8981\u8f93\u5165\u5bc6\u7801\u7ed9\u660e\u6587\u79c1\u94a5\u52a0\u5bc6")
    @Parameters(value={@Parameter(parameterName="priKey", parameterDes="\u8d26\u6237\u660e\u6587\u79c1\u94a5"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u8d26\u6237\u5730\u5740", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8d26\u6237\u5730\u5740")}))
    public static Result importPriKey(String priKey, String password) {
        return accountService.importPriKey(priKey, password);
    }

    @ApiOperation(description="\u6839\u636ekeystore\u5bfc\u5165\u8d26\u6237", order=105)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="pubKey", parameterDes="\u516c\u94a5"), @Parameter(parameterName="encryptedPriKey", parameterDes="\u52a0\u5bc6\u540e\u7684\u79c1\u94a5"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8d26\u6237\u5730\u5740")}))
    public static Result importKeystore(AccountKeyStoreDto keyStore, String password) {
        return accountService.importKeystore(keyStore, password);
    }

    @ApiOperation(description="\u5bfc\u51fakeystore\u5230\u6307\u5b9a\u6587\u4ef6\u76ee\u5f55", order=106)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801"), @Parameter(parameterName="filePath", parameterDes="\u6587\u4ef6\u76ee\u5f55")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="path", description="\u5bfc\u51fa\u7684\u6587\u4ef6\u8def\u5f84")}))
    public static Result exportKeyStore(String address, String password, String filePath) {
        return accountService.exportKeyStore(address, password, filePath);
    }

    @ApiOperation(description="\u67e5\u8be2\u8d26\u6237\u4f59\u989d", order=107, detailDesc="\u6839\u636e\u8d44\u4ea7\u94feID\u548c\u8d44\u4ea7ID\uff0c\u67e5\u8be2\u672c\u94fe\u8d26\u6237\u5bf9\u5e94\u8d44\u4ea7\u7684\u4f59\u989d\u4e0enonce\u503c")
    @Parameters(value={@Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8d44\u4ea7\u7684\u94feID"), @Parameter(parameterName="assetsId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8d44\u4ea7ID")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=AccountBalanceDto.class))
    public static Result getAccountBalance(String address, int chainId, int assetsId) {
        return accountService.getAccountBalance(address, chainId, assetsId);
    }

    @ApiOperation(description="\u8bbe\u7f6e\u8d26\u6237\u522b\u540d", order=108, detailDesc="\u522b\u540d\u683c\u5f0f\u4e3a1-20\u4f4d\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u7684\u7ec4\u5408\uff0c\u8bbe\u7f6e\u522b\u540d\u4f1a\u9500\u6bc11\u4e2aNULS")
    @Parameters(value={@Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="alias", requestType=@TypeDescriptor(value=String.class), parameterDes="\u522b\u540d"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8bbe\u7f6e\u522b\u540d\u4ea4\u6613\u7684hash")}))
    public static Result setAlias(String address, String alias, String password) {
        return accountService.setAlias(address, alias, password);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u5730\u5740\u683c\u5f0f\u662f\u5426\u6b63\u786e", order=109, detailDesc="\u9a8c\u8bc1\u672c\u94fe\u5730\u5740\u683c\u5f0f\u662f\u5426\u6b63\u786e")
    @Parameters(value={@Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5730\u5740")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class))
    public static Result validateAddress(String address) {
        return accountService.validateAddress(SDKContext.main_chain_id, address);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u5730\u5740\u683c\u5f0f\u662f\u5426\u6b63\u786e", order=110, detailDesc="\u6839\u636echainId\u9a8c\u8bc1\u5730\u5740\u683c\u5f0f\u662f\u5426\u6b63\u786e")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u94feID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5730\u5740")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class))
    public static Result validateAddress(int chainId, String address) {
        return accountService.validateAddress(chainId, address);
    }

    @ApiOperation(description="\u79bb\u7ebf - \u6279\u91cf\u521b\u5efa\u8d26\u6237", order=150, detailDesc="\u521b\u5efa\u7684\u8d26\u6237\u4e0d\u4f1a\u4fdd\u5b58\u5230\u94b1\u5305\u4e2d,\u63a5\u53e3\u76f4\u63a5\u8fd4\u56de\u8d26\u6237\u7684keystore\u4fe1\u606f")
    @Parameters(value={@Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="\u521b\u5efa\u6570\u91cf"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2a\u8d26\u6237keystore\u96c6\u5408", responseType=@TypeDescriptor(value=List.class, collectionElement=AccountDto.class))
    public static Result<List<AccountDto>> createOffLineAccount(int count, String password) {
        return accountService.createOffLineAccount(count, password);
    }

    @ApiOperation(description="\u79bb\u7ebf - \u6279\u91cf\u521b\u5efa\u5730\u5740\u5e26\u56fa\u5b9a\u524d\u7f00\u7684\u8d26\u6237", order=151, detailDesc="\u521b\u5efa\u7684\u8d26\u6237\u4e0d\u4f1a\u4fdd\u5b58\u5230\u94b1\u5305\u4e2d,\u63a5\u53e3\u76f4\u63a5\u8fd4\u56de\u8d26\u6237\u7684keystore\u4fe1\u606f")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u5730\u5740\u5bf9\u5e94\u7684\u94feId"), @Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="\u521b\u5efa\u6570\u91cf"), @Parameter(parameterName="prefix", requestType=@TypeDescriptor(value=String.class), canNull=true, parameterDes="\u5730\u5740\u524d\u7f00"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2a\u8d26\u6237keystore\u96c6\u5408", responseType=@TypeDescriptor(value=List.class, collectionElement=AccountDto.class))
    public static Result<List<AccountDto>> createOffLineAccount(int chainId, int count, String prefix, String password) {
        return accountService.createOffLineAccount(chainId, count, prefix, password);
    }

    @ApiOperation(description="\u79bb\u7ebf\u4fee\u6539\u8d26\u6237\u5bc6\u7801", order=152)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="encryptedPriKey", parameterDes="\u52a0\u5bc6\u540e\u7684\u79c1\u94a5"), @Parameter(parameterName="oldPassword", parameterDes="\u539f\u5bc6\u7801"), @Parameter(parameterName="newPassword", parameterDes="\u65b0\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u91cd\u7f6e\u5bc6\u7801\u540e\u7684\u52a0\u5bc6\u79c1\u94a5")}))
    public static Result resetPasswordOffline(String address, String encryptedPriKey, String password, String newPassword) {
        return accountService.resetPasswordOffline(address, encryptedPriKey, password, newPassword);
    }

    @ApiOperation(description="\u79bb\u7ebf\u83b7\u53d6\u8d26\u6237\u660e\u6587\u79c1\u94a5", order=153)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="encryptedPriKey", parameterDes="\u52a0\u5bc6\u540e\u7684\u79c1\u94a5"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u660e\u6587\u79c1\u94a5")}))
    public static Result getPriKeyOffline(String address, String encryptedPriKey, String password) {
        return accountService.getPriKeyOffline(address, encryptedPriKey, password);
    }

    @ApiOperation(description="\u591a\u8d26\u6237\u6458\u8981\u7b7e\u540d", order=154, detailDesc="\u7528\u4e8e\u7b7e\u540d\u79bb\u7ebf\u7ec4\u88c5\u7684\u591a\u8d26\u6237\u8f6c\u8d26\u4ea4\u6613\uff0c\u8c03\u7528\u63a5\u53e3\u65f6\uff0c\u53c2\u6570\u53ef\u4ee5\u4f20\u5730\u5740\u548c\u79c1\u94a5\uff0c\u6216\u8005\u4f20\u5730\u5740\u548c\u52a0\u5bc6\u79c1\u94a5\u548c\u52a0\u5bc6\u5bc6\u7801")
    @Parameters(value={@Parameter(parameterName="signDtoList", parameterDes="\u6458\u8981\u7b7e\u540d\u8868\u5355", requestType=@TypeDescriptor(value=SignDto.class)), @Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u7b7e\u540d\u540e\u7684\u4ea4\u661316\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result sign(List<SignDto> signDtoList, String txHex) {
        return accountService.sign(signDtoList, txHex);
    }

    public static Result sign(int chainId, String prefix, List<SignDto> signDtoList, String txHex) {
        return accountService.sign(chainId, prefix, signDtoList, txHex);
    }

    @ApiOperation(description="\u591a\u7b7e\u8d26\u6237\u6458\u8981\u7b7e\u540d", order=155, detailDesc="\u7528\u4e8e\u7b7e\u540d\u79bb\u7ebf\u7ec4\u88c5\u7684\u591a\u7b7e\u8d26\u6237\u8f6c\u8d26\u4ea4\u6613\uff0c\u6bcf\u6b21\u8c03\u7528\u63a5\u53e3\u65f6\uff0c\u53ea\u80fd\u4f20\u5165\u4e00\u4e2a\u8d26\u6237\u7684\u79c1\u94a5\u8fdb\u884c\u7b7e\u540d\uff0c\u7b7e\u540d\u6210\u529f\u540e\u8fd4\u56de\u7684\u4ea4\u6613\u5b57\u7b26\u4e32\u518d\u4ea4\u7ed9\u7b2c\u4e8c\u4e2a\u8d26\u6237\u7b7e\u540d\uff0c\u4f9d\u6b21\u7c7b\u63a8")
    @Parameters(value={@Parameter(parameterName="signDto", parameterDes="\u6458\u8981\u7b7e\u540d\u8868\u5355", requestType=@TypeDescriptor(value=SignDto.class)), @Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u7b7e\u540d\u540e\u7684\u4ea4\u661316\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result multiSign(SignDto signDto, String txHex) {
        return accountService.multiSign(signDto, txHex);
    }

    @ApiOperation(description="\u660e\u6587\u79c1\u94a5\u6458\u8981\u7b7e\u540d", order=156)
    @Parameters(value={@Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32"), @Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="privateKey", parameterDes="\u8d26\u6237\u660e\u6587\u79c1\u94a5")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u7b7e\u540d\u540e\u7684\u4ea4\u661316\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result sign(String txHex, String address, String privateKey) {
        return transactionService.signTx(txHex, address, privateKey);
    }

    @ApiOperation(description="\u5bc6\u6587\u79c1\u94a5\u6458\u8981\u7b7e\u540d", order=157)
    @Parameters(value={@Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32"), @Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="encryptedPrivateKey", parameterDes="\u8d26\u6237\u5bc6\u6587\u79c1\u94a5"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u7b7e\u540d\u540e\u7684\u4ea4\u661316\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result sign(String txHex, String address, String encryptedPrivateKey, String password) {
        return transactionService.signTx(txHex, address, encryptedPrivateKey, password);
    }

    public static Result sign(String txHex, int chainId, String prefix, String address, String encryptedPrivateKey, String password) {
        return accountService.sign(txHex, chainId, prefix, address, encryptedPrivateKey, password);
    }

    public Result multiSign(int chainId, String prefix, String address, String encryptedPrivateKey, String password, String txHex) {
        return accountService.multiSign(chainId, prefix, address, encryptedPrivateKey, password, txHex);
    }

    @ApiOperation(description="\u521b\u5efa\u591a\u7b7e\u8d26\u6237", order=158, detailDesc="\u6839\u636e\u591a\u4e2a\u8d26\u6237\u7684\u516c\u94a5\u521b\u5efa\u591a\u7b7e\u8d26\u6237\uff0cminSigns\u4e3a\u591a\u7b7e\u8d26\u6237\u521b\u5efa\u4ea4\u6613\u65f6\u9700\u8981\u7684\u6700\u5c0f\u7b7e\u540d\u6570")
    @Parameters(value={@Parameter(parameterName="pubKeys", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="\u8d26\u6237\u516c\u94a5\u96c6\u5408"), @Parameter(parameterName="minSigns", requestType=@TypeDescriptor(value=int.class), parameterDes="\u6700\u5c0f\u7b7e\u540d\u6570")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8d26\u6237\u7684\u5730\u5740")}))
    public static Result createMultiSignAccount(List<String> pubKeys, int minSigns) {
        return accountService.createMultiSignAccount(pubKeys, minSigns);
    }

    @ApiOperation(description="\u6839\u636e\u79c1\u94a5\u83b7\u53d6\u5730\u5740", order=159, detailDesc="\u6839\u636e\u4f20\u5165\u7684\u79c1\u94a5\uff0c\u751f\u6210\u5bf9\u5e94\u7684\u5730\u5740\uff0c\u79c1\u94a5\u4e0d\u4f1a\u5b58\u50a8\u5728\u94b1\u5305\u91cc")
    @Parameters(value={@Parameter(parameterName="priKey", parameterDes="\u539f\u59cb\u79c1\u94a5")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8d26\u6237\u7684\u5730\u5740")}))
    public static Result getAddressByPriKey(String priKey) {
        return accountService.getAddressByPriKey(priKey);
    }

    @ApiOperation(description="\u6839\u636e\u533a\u5757\u9ad8\u5ea6\u67e5\u8be2\u533a\u5757\u5934", order=201)
    @Parameters(value={@Parameter(parameterName="height", requestType=@TypeDescriptor(value=Long.class), parameterDes="\u533a\u5757\u9ad8\u5ea6")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBlockHeader(long height) {
        return blockService.getBlockHeader(height);
    }

    @ApiOperation(description="\u6839\u636e\u533a\u5757hash\u67e5\u8be2\u533a\u5757\u5934", order=202)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="\u533a\u5757hash")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBlockHeader(String hash) {
        return blockService.getBlockHeader(hash);
    }

    @ApiOperation(description="\u6839\u636e\u533a\u5757\u9ad8\u5ea6\u67e5\u8be2\u533a\u5757\uff0c\u5305\u542b\u533a\u5757\u6253\u5305\u7684\u6240\u6709\u4ea4\u6613\u4fe1\u606f\uff0c\u6b64\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u91cf\u8f83\u591a\uff0c\u8c28\u614e\u8c03\u7528", order=203)
    @Parameters(value={@Parameter(parameterName="height", requestType=@TypeDescriptor(value=Long.class), parameterDes="\u533a\u5757\u9ad8\u5ea6")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBlock(long height) {
        return blockService.getBlock(height);
    }

    @ApiOperation(description="\u6839\u636e\u533a\u5757hash\u67e5\u8be2\u533a\u5757\uff0c\u5305\u542b\u533a\u5757\u6253\u5305\u7684\u6240\u6709\u4ea4\u6613\u4fe1\u606f\uff0c\u6b64\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u91cf\u8f83\u591a\uff0c\u8c28\u614e\u8c03\u7528", order=204)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="\u533a\u5757hash")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBlock(String hash) {
        return blockService.getBlock(hash);
    }

    @ApiOperation(description="\u67e5\u8be2\u6700\u65b0\u533a\u5757\u5934\u4fe1\u606f", order=205)
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBestBlockHeader() {
        return blockService.getBestBlockHeader();
    }

    @ApiOperation(description="\u67e5\u8be2\u6700\u65b0\u533a\u5757", order=206)
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockDto.class))
    public static Result getBestBlock() {
        return blockService.getBestBlock();
    }

    @ApiOperation(description="\u6839\u636ehash\u67e5\u8be2\u4ea4\u6613\u8be6\u60c5", order=301)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="\u4ea4\u6613hash")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=TransactionDto.class))
    public static Result getTx(String txHash) {
        return transactionService.getTx(txHash);
    }

    public static Result getTransaction(String txHash) {
        return transactionService.getTransaction(txHash);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u4ea4\u6613", order=302, detailDesc="\u9a8c\u8bc1\u79bb\u7ebf\u7ec4\u88c5\u7684\u4ea4\u6613,\u9a8c\u8bc1\u6210\u529f\u8fd4\u56de\u4ea4\u6613hash\u503c,\u5931\u8d25\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4fe1\u606f")
    @Parameters(value={@Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result validateTx(String txHex) {
        return transactionService.validateTx(txHex);
    }

    @ApiOperation(description="\u5e7f\u64ad\u4ea4\u6613", order=303, detailDesc="\u5e7f\u64ad\u79bb\u7ebf\u7ec4\u88c5\u7684\u4ea4\u6613,\u6210\u529f\u8fd4\u56detrue,\u5931\u8d25\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4fe1\u606f")
    @Parameters(value={@Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="\u662f\u5426\u6210\u529f"), @Key(name="hash", description="\u4ea4\u6613hash")}))
    public static Result broadcast(String txHex) {
        return transactionService.broadcastTx(txHex);
    }

    @ApiOperation(description="\u5355\u7b14\u8f6c\u8d26", order=304, detailDesc="\u53d1\u8d77\u5355\u8d26\u6237\u5355\u8d44\u4ea7\u7684\u8f6c\u8d26\u4ea4\u6613(\u5728\u7ebf)")
    @Parameters(value={@Parameter(parameterName="transferForm", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=TransferForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result transfer(TransferForm transferForm) {
        return transactionService.transfer(transferForm);
    }

    @ApiOperation(description="\u5355\u7b14\u8de8\u94fe\u8f6c\u8d26", order=305, detailDesc="\u53d1\u8d77\u5355\u8d26\u6237\u5355\u8d44\u4ea7\u7684\u8de8\u94fe\u8f6c\u8d26\u4ea4\u6613(\u5728\u7ebf)")
    @Parameters(value={@Parameter(parameterName="transferForm", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=CrossTransferForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result crossTransfer(CrossTransferForm transferForm) {
        return transactionService.crossTransfer(transferForm);
    }

    @ApiOperation(description="\u901a\u7528\u79bb\u7ebf\u7ec4\u88c5\u8f6c\u8d26\u4ea4\u6613", order=310, detailDesc="\u6839\u636einputs\u548coutputs\u79bb\u7ebf\u7ec4\u88c5\u8f6c\u8d26\u4ea4\u6613\uff0c\u7528\u4e8e\u5355\u8d26\u6237\u6216\u591a\u8d26\u6237\u7684\u8f6c\u8d26\u4ea4\u6613\u3002\u4ea4\u6613\u624b\u7eed\u8d39\u4e3ainputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u91d1\u989d\u603b\u548c\uff0c\u51cf\u53bboutputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u603b\u548c")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=TransferDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTransferTxOffline(TransferDto transferDto) {
        return transactionService.createTransferTx(transferDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u94fe\u5185\u975eNVT\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=311, detailDesc="\u7ec4\u88c5\u5728NULS\u94fe\u5185\uff0c\u8f6c\u8d26\u975eNVT\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8f6c\u8d26\u3002\u8be5\u65b9\u6cd5\u4f1a\u4e3b\u52a8\u7528fromAddress\u7ec4\u88c5(NVT\u8d44\u4ea7)\u6253\u5305\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NERVE\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NERVE\u5730\u5740)"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7\u94feid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7id"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTxSimpleTransferOfNonNvt(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount) {
        return transactionService.createTxSimpleTransferOfNonNvt(fromAddress, toAddress, assetChainId, assetId, amount);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u94fe\u5185\u975eNVT\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=312, detailDesc="\u7ec4\u88c5\u5728NULS\u94fe\u5185\uff0c\u8f6c\u8d26\u975eNVT\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8f6c\u8d26\u3002\u8be5\u65b9\u6cd5\u4f1a\u4e3b\u52a8\u7528fromAddress\u7ec4\u88c5(NVT\u8d44\u4ea7)\u6253\u5305\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NERVE\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NERVE\u5730\u5740)"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7\u94feid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7id"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTxSimpleTransferOfNonNvt(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount, long time, String remark) {
        return transactionService.createTxSimpleTransferOfNonNvt(fromAddress, toAddress, assetChainId, assetId, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u94fe\u5185NVT\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=313, detailDesc="\u7ec4\u88c5\u5728NULS\u94fe\u5185\uff0c\u8f6c\u8d26NVT\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8f6c\u8d26\u3002\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NERVE\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NERVE\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTxSimpleTransferOfNvt(String fromAddress, String toAddress, BigInteger amount) {
        return transactionService.createTxSimpleTransferOfNvt(fromAddress, toAddress, amount);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u94fe\u5185NVT\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=314, detailDesc="\u7ec4\u88c5\u5728NULS\u94fe\u5185\uff0c\u8f6c\u8d26NVT\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8f6c\u8d26\u3002\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NERVE\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NERVE\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTxSimpleTransferOfNvt(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        return transactionService.createTxSimpleTransferOfNvt(fromAddress, toAddress, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26\u4ea4\u6613", order=320, detailDesc="\u6839\u636einputs\u548coutputs\u79bb\u7ebf\u7ec4\u88c5\u8f6c\u8d26\u4ea4\u6613\uff0c\u7528\u4e8e\u5355\u8d26\u6237\u6216\u591a\u8d26\u6237\u7684\u8f6c\u8d26\u4ea4\u6613\u3002\u4ea4\u6613\u624b\u7eed\u8d39\u4e3ainputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u91d1\u989d\u603b\u548c\uff0c\u51cf\u53bboutputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u603b\u548c")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=TransferDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTransferTxOffline(TransferDto transferDto) {
        return transactionService.createCrossTransferTx(transferDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94fe\u975e[NULS\u548cNVT]\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=321, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26\u975e[NULS\u548cNVT]\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8de8\u94fe\u8f6c\u8d26(\u4e0d\u80fd\u7528\u4e8e\u8f6cNULS\u548cNVT)\uff0c\u7528\u4e8e\u5c06\u8d44\u4ea7\u8f6c\u5165NULS\u4e3b\u7f51\uff0c\u8be5\u65b9\u6cd5\u4f1a\u4e3b\u52a8\u7528fromAddress\u7ec4\u88c5\uff08NULS\u548cNVT\u8d44\u4ea7\uff09\u6253\u5305\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(\u5f53\u524d\u94fe\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7\u94feid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7id"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNonNvtNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount, long time, String remark) {
        return transactionService.createCrossTxSimpleTransferOfNonNvtNuls(fromAddress, toAddress, assetChainId, assetId, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94fe\u975e[NULS\u548cNVT]\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=322, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26\u975e[NULS\u548cNVT]\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8de8\u94fe\u8f6c\u8d26(\u4e0d\u80fd\u7528\u4e8e\u8f6cNULS\u548cNVT)\uff0c\u7528\u4e8e\u5c06\u8d44\u4ea7\u8f6c\u5165NULS\u4e3b\u7f51\uff0c\u8be5\u65b9\u6cd5\u4f1a\u4e3b\u52a8\u7528fromAddress\u7ec4\u88c5\uff08NULS\u548cNVT\u8d44\u4ea7\uff09\u6253\u5305\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(\u5f53\u524d\u94fe\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7\u94feid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7id"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNonNvtNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount) {
        return transactionService.createCrossTxSimpleTransferOfNonNvtNuls(fromAddress, toAddress, assetChainId, assetId, amount);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94feNULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=323, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26NULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u8de8\u94fe\u8f6c\u8d26\uff0c\u7528\u4e8e\u5c06NULS\u8d44\u4ea7\u8f6c\u5165NULS\u4e3b\u7f51\uff08\u53ea\u80fd\u7528\u4e8e\u8f6cNULS\uff09\u3002\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(\u5f53\u524d\u94fe\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        return transactionService.createCrossTxSimpleTransferOfNuls(fromAddress, toAddress, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94feNULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=324, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26NULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u8de8\u94fe\u8f6c\u8d26\uff0c\u7528\u4e8e\u5c06NULS\u8d44\u4ea7\u8f6c\u5165NULS\u4e3b\u7f51\uff08\u53ea\u80fd\u7528\u4e8e\u8f6cNULS\uff09\u3002\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(\u5f53\u524d\u94fe\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount) {
        return transactionService.createCrossTxSimpleTransferOfNuls(fromAddress, toAddress, amount);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94feNVT\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=323, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26NVT\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u8de8\u94fe\u8f6c\u8d26\uff0c\u7528\u4e8e\u5c06NVT\u8d44\u4ea7\u8f6c\u5165NULS\u4e3b\u7f51\uff08\u53ea\u80fd\u7528\u4e8e\u8f6cNVT\uff09\u3002\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(\u5f53\u524d\u94fe\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740\uff08NULS\u5730\u5740\uff09"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNvt(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        return transactionService.createCrossTxSimpleTransferOfNvt(fromAddress, toAddress, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94feNVT\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=324, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26NVT\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u8de8\u94fe\u8f6c\u8d26\uff0c\u7528\u4e8e\u5c06NVT\u8d44\u4ea7\u8f6c\u5165NULS\u4e3b\u7f51\uff08\u53ea\u80fd\u7528\u4e8e\u8f6cNVT\uff09\u3002\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(\u5f53\u524d\u94fe\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNvt(String fromAddress, String toAddress, BigInteger amount) {
        return transactionService.createCrossTxSimpleTransferOfNvt(fromAddress, toAddress, amount);
    }

    @ApiOperation(description="\u5f02\u6784\u94fe\u63d0\u73b0\u4ea4\u6613", order=330, detailDesc="\u7ec4\u88c5\u5f02\u6784\u94fe\u63d0\u73b0\u4ea4\u6613")
    @Parameters(value={@Parameter(parameterName="withdrawalTxDto", parameterDes="\u63d0\u73b0\u4ea4\u6613\u53c2\u6570", requestType=@TypeDescriptor(value=WithdrawalTxDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createWithdrawalTx(WithdrawalTxDto withdrawalTxDto) {
        return NerveSDKTool.createWithdrawalTx(withdrawalTxDto, null, null);
    }

    @ApiOperation(description="\u8ffd\u52a0\u5f02\u6784\u63d0\u73b0\u624b\u7eed\u8d39", order=331, detailDesc="\u652f\u4ed8NVT\u6765\u4e3a\u63d0\u73b0\u4ea4\u6613\u8ffd\u52a0\u624b\u7eed\u8d39(\u52a0\u901f)\uff0c\u4e0d\u80fd\u4e3a\u5df2\u5b8c\u6210\u7684\u63d0\u73b0\u4ea4\u6613\u8ffd\u52a0\u624b\u7eed\u8d39\uff0c\u63d0\u73b0\u4ea4\u6613\u4e0e\u8ffd\u52a0\u624b\u7eed\u8d39\u4ea4\u6613\u5fc5\u987b\u7531\u76f8\u540c\u7684\u5730\u5740\u53d1\u8d77\uff08\u76f8\u540c\u79c1\u94a5\u7b7e\u540d\uff09")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(\u5f53\u524d\u94fe\u5730\u5740)"), @Parameter(parameterName="txHash", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8981\u8ffd\u52a0\u624b\u7eed\u8d39\u7684\u63d0\u73b0\u4ea4\u6613hash"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8ffd\u52a0\u624b\u7eed\u8d39\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result withdrawalAdditionalFeeTx(String fromAddress, String txHash, BigInteger amount, long time, String remark) {
        return transactionService.withdrawalAdditionalFeeTx(fromAddress, txHash, amount, time, remark, null);
    }

    @ApiOperation(description="\u5f02\u6784\u94fe\u63d0\u73b0\u4ea4\u6613\uff08\u5b8c\u5168\u79bb\u7ebf\u72b6\u6001\uff09", order=332, detailDesc="\u7ec4\u88c5\u5f02\u6784\u94fe\u63d0\u73b0\u4ea4\u6613\uff08\u5b8c\u5168\u79bb\u7ebf\u72b6\u6001\uff09")
    @Parameters(value={@Parameter(parameterName="withdrawalTxDto", parameterDes="\u63d0\u73b0\u4ea4\u6613\u53c2\u6570", requestType=@TypeDescriptor(value=WithdrawalTxDto.class)), @Parameter(parameterName="withdrawalAssetNonce", parameterDes="\u63d0\u73b0\u8d44\u4ea7\u7684nonce"), @Parameter(parameterName="nvtFeeAssetNonce", parameterDes="nvt\u624b\u7eed\u8d39\u8d44\u4ea7\u7684nonce")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createWithdrawalTx(WithdrawalTxDto withdrawalTxDto, String withdrawalAssetNonce, String nvtFeeAssetNonce) {
        return transactionService.createWithdrawalTx(withdrawalTxDto, withdrawalAssetNonce, nvtFeeAssetNonce);
    }

    @ApiOperation(description="\u8ffd\u52a0\u5f02\u6784\u63d0\u73b0\u624b\u7eed\u8d39\uff08\u5b8c\u5168\u79bb\u7ebf\u72b6\u6001\uff09", order=333, detailDesc="\uff08\u5b8c\u5168\u79bb\u7ebf\u72b6\u6001\uff09\u652f\u4ed8NVT\u6765\u4e3a\u63d0\u73b0\u4ea4\u6613\u8ffd\u52a0\u624b\u7eed\u8d39(\u52a0\u901f)\uff0c\u4e0d\u80fd\u4e3a\u5df2\u5b8c\u6210\u7684\u63d0\u73b0\u4ea4\u6613\u8ffd\u52a0\u624b\u7eed\u8d39\u63d0\u73b0\u4ea4\u6613\u4e0e\u8ffd\u52a0\u624b\u7eed\u8d39\u4ea4\u6613\u5fc5\u987b\u7531\u76f8\u540c\u7684\u5730\u5740\u53d1\u8d77\uff08\u76f8\u540c\u79c1\u94a5\u7b7e\u540d\uff09")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(\u5f53\u524d\u94fe\u5730\u5740)"), @Parameter(parameterName="txHash", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8981\u8ffd\u52a0\u624b\u7eed\u8d39\u7684\u63d0\u73b0\u4ea4\u6613hash"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8ffd\u52a0\u624b\u7eed\u8d39\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8"), @Parameter(parameterName="nonce", parameterDes="nvt\u624b\u7eed\u8d39\u8d44\u4ea7\u7684nonce")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result withdrawalAdditionalFeeTx(String fromAddress, String txHash, BigInteger amount, long time, String remark, String nonce) {
        return transactionService.withdrawalAdditionalFeeTx(fromAddress, txHash, amount, time, remark, nonce);
    }

    @ApiOperation(description="\u8ba1\u7b97\u79bb\u7ebf\u521b\u5efa\u8f6c\u8d26\u4ea4\u6613\u6240\u9700\u624b\u7eed\u8d39", order=340)
    @Parameters(value={@Parameter(parameterName="TransferTxFeeDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u624b\u7eed\u8d39", requestType=@TypeDescriptor(value=TransferTxFeeDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u624b\u7eed\u8d39\u91d1\u989d", responseType=@TypeDescriptor(value=BigInteger.class))
    public static BigInteger calcTransferTxFee(TransferTxFeeDto dto) {
        return transactionService.calcTransferTxFee(dto);
    }

    @ApiOperation(description="\u8ba1\u7b97\u79bb\u7ebf\u521b\u5efa\u8de8\u94fe\u8f6c\u8d26\u4ea4\u6613\u6240\u9700\u624b\u7eed\u8d39", order=341, detailDesc="\u5411NULS\u7f51\u8de8\u94fe\u9700\u8981\u540c\u65f6\u6536\u53d6\u5f53\u524d\u7f51\u7edc\u4e3b\u8d44\u4ea7\u548cNULS\u6765\u5206\u522b\u652f\u4ed8\u4e24\u4e2a\u7f51\u7edc\u7684\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="CrossTransferTxFeeDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u624b\u7eed\u8d39", requestType=@TypeDescriptor(value=CrossTransferTxFeeDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u624b\u7eed\u8d39\u91d1\u989d", responseType=@TypeDescriptor(value=Map.class))
    @Deprecated
    public static Map<String, BigInteger> calcCrossTransferTxFee(CrossTransferTxFeeDto dto) {
        return transactionService.calcCrossTransferTxFee(dto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u591a\u7b7e\u8d26\u6237\u8f6c\u8d26\u4ea4\u6613", order=352, detailDesc="\u6839\u636einputs\u548coutputs\u79bb\u7ebf\u7ec4\u88c5\u8f6c\u8d26\u4ea4\u6613\uff0c\u7528\u4e8e\u5355\u4e2a\u591a\u7b7e\u8d26\u6237\u8f6c\u8d26\u3002\u4ea4\u6613\u624b\u7eed\u8d39\u4e3ainputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u91d1\u989d\u603b\u548c\uff0c\u51cf\u53bboutputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u603b\u548c")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=MultiSignTransferDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createMultiSignTransferTxOffline(MultiSignTransferDto transferDto) {
        return transactionService.createMultiSignTransferTx(transferDto);
    }

    @ApiOperation(description="\u8ba1\u7b97\u79bb\u7ebf\u521b\u5efa\u591a\u7b7e\u8d26\u6237\u8f6c\u8d26\u4ea4\u6613\u6240\u9700\u624b\u7eed\u8d39", order=333)
    @Parameters(value={@Parameter(parameterName="MultiSignTransferTxFeeDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u624b\u7eed\u8d39", requestType=@TypeDescriptor(value=MultiSignTransferTxFeeDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u624b\u7eed\u8d39\u91d1\u989d", responseType=@TypeDescriptor(value=BigInteger.class))
    public static BigInteger calcMultiSignTransferTxFee(MultiSignTransferTxFeeDto dto) {
        return transactionService.calcMultiSignTransferTxFee(dto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u521b\u5efa\u8bbe\u7f6e\u522b\u540d\u4ea4\u6613", order=354)
    @Parameters(value={@Parameter(parameterName="AliasDto", parameterDes="\u521b\u5efa\u522b\u540d\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=AliasDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createAliasTxOffline(AliasDto dto) {
        return transactionService.createAliasTx(dto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u521b\u5efa\u591a\u7b7e\u8d26\u6237\u8bbe\u7f6e\u522b\u540d\u4ea4\u6613", order=355)
    @Parameters(value={@Parameter(parameterName="MultiSignAliasDto", parameterDes="\u591a\u7b7e\u8d26\u6237\u521b\u5efa\u522b\u540d\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=MultiSignAliasDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createMultiSignAliasTxOffline(MultiSignAliasDto dto) {
        return transactionService.createMultiSignAliasTx(dto);
    }

    public static Result deserializeTxHex(String txHex) {
        Transaction tx = new Transaction();
        try {
            tx.parse(new NulsByteBuffer(HexUtil.decode(txHex)));
            return Result.getSuccess(tx);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    @ApiOperation(description="\u6839\u636e\u8d44\u4ea7\u4fe1\u606f\u83b7\u53d6\u8d44\u4ea7\u7684USD\u4ef7\u683c", order=370)
    @Parameters(value={@Parameter(parameterName="assetChainId", parameterDes="\u8d44\u4ea7\u94feID", requestType=@TypeDescriptor(value=int.class)), @Parameter(parameterName="assetId", parameterDes="\u8d44\u4ea7ID", requestType=@TypeDescriptor(value=int.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u4ef7\u683c", responseType=@TypeDescriptor(value=BigDecimal.class))
    public static BigDecimal getUsdPrice(int assetChainId, int assetId) {
        Result rs = NerveSDKTool.getSymbolInfo(assetChainId, assetId);
        Map map = (Map)rs.getData();
        String usdPrice = map.get("usdPrice").toString();
        return new BigDecimal(usdPrice);
    }

    @ApiOperation(description="\u6839\u636e\u8d44\u4ea7\u4fe1\u606f\u83b7\u53d6\u8d44\u4ea7\u4fe1\u606f", order=371)
    @Parameters(value={@Parameter(parameterName="assetChainId", parameterDes="\u8d44\u4ea7\u94feID", requestType=@TypeDescriptor(value=int.class)), @Parameter(parameterName="assetId", parameterDes="\u8d44\u4ea7ID", requestType=@TypeDescriptor(value=int.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u4ef7\u683c", responseType=@TypeDescriptor(value=BigDecimal.class))
    public static Result getSymbolInfo(int assetChainId, int assetId) {
        if (assetChainId == 0 || assetId == 0) {
            return Result.getFailed(CommonCodeConstanst.NULL_PARAMETER).setMsg("assetChainId or assetId is empty");
        }
        RpcResult rpcResult = JsonRpcUtil.request("https://public.nerve.network/", "getSymbolInfo", ListUtil.of(assetChainId, assetId));
        RpcResultError rpcResultError = rpcResult.getError();
        if (rpcResultError != null) {
            return Result.getFailed(ErrorCode.init(rpcResultError.getCode())).setMsg(rpcResultError.getMessage());
        }
        return Result.getSuccess(CommonCodeConstanst.SUCCESS).setData(rpcResult.getResult());
    }

    public static void main(String[] args) {
        BigDecimal usdPrice = NerveSDKTool.getUsdPrice(9, 2);
        System.out.println(usdPrice);
    }
}

