/*
 * Decompiled with CFR 0.152.
 */
package network.nerve;

import network.nerve.SDKContext;
import network.nerve.core.model.StringUtils;
import network.nerve.core.parse.I18nUtils;

public class NerveSDKBootStrap {
    private static final String LANGUAGE = "en";
    private static final String LANGUAGE_PATH = "languages";

    public static void init(int chainId, int nulsChainId, String addressPrefix, String addressPrefixNuls, String httpUrl) {
        NerveSDKBootStrap.initChainId(chainId);
        if (httpUrl != null && !httpUrl.endsWith("/")) {
            httpUrl = httpUrl + "/";
        }
        if (StringUtils.isNotBlank(httpUrl)) {
            SDKContext.wallet_url = httpUrl;
        }
        SDKContext.nuls_chain_id = nulsChainId;
        SDKContext.addressPrefix = addressPrefix;
        SDKContext.addressPrefixNuls = addressPrefixNuls;
    }

    public static void initTest(String httpUrl) {
        NerveSDKBootStrap.initChainId(5);
        if (httpUrl != null && !httpUrl.endsWith("/")) {
            httpUrl = httpUrl + "/";
        }
        if (StringUtils.isNotBlank(httpUrl)) {
            SDKContext.wallet_url = httpUrl;
        }
        SDKContext.nuls_chain_id = 2;
        SDKContext.addressPrefixNuls = "tNULS";
        SDKContext.addressPrefix = "TNVT";
    }

    private static void initChainId(int chainId) {
        if (chainId < 1 || chainId > 65535) {
            throw new RuntimeException("[defaultChainId] is invalid");
        }
        SDKContext.main_chain_id = chainId;
        I18nUtils.loadLanguage(NerveSDKBootStrap.class, LANGUAGE_PATH, LANGUAGE);
    }
}

