/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.core.basic.NulsData;
import network.nerve.core.constant.ToolsConstant;
import network.nerve.core.crypto.UnsafeByteArrayOutputStream;
import network.nerve.core.exception.NulsException;

public abstract class BaseNulsData
implements NulsData,
Serializable,
Cloneable {
    @Override
    public final byte[] serialize() throws IOException {
        int size = this.size();
        try (UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(size);){
            NulsOutputStreamBuffer buffer = new NulsOutputStreamBuffer(bos);
            if (size == 0) {
                bos.write(ToolsConstant.PLACE_HOLDER);
            } else {
                this.serializeToStream(buffer);
            }
            byte[] bytes = ((ByteArrayOutputStream)bos).toByteArray();
            if (bytes.length != size) {
                throw new RuntimeException();
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    protected abstract void serializeToStream(NulsOutputStreamBuffer var1) throws IOException;

    @Override
    public final void parse(byte[] bytes, int cursor) throws NulsException {
        if (bytes == null || bytes.length == 0 || bytes.length == 4 && Arrays.equals(ToolsConstant.PLACE_HOLDER, bytes)) {
            return;
        }
        NulsByteBuffer byteBuffer = new NulsByteBuffer(bytes);
        byteBuffer.setCursor(cursor);
        this.parse(byteBuffer);
    }

    public abstract void parse(NulsByteBuffer var1) throws NulsException;
}

