/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.signture;

import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.NulsHash;
import network.nerve.base.data.NulsSignData;
import network.nerve.core.basic.Result;
import network.nerve.core.crypto.ECKey;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.parse.SerializeUtils;

public class P2PHKSignature
extends BaseNulsData {
    public static final int SERIALIZE_LENGTH = 110;
    private NulsSignData signData;
    private byte[] publicKey;
    public static final Comparator<P2PHKSignature> PUBKEY_COMPARATOR = new Comparator<P2PHKSignature>(){
        private Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

        @Override
        public int compare(P2PHKSignature k1, P2PHKSignature k2) {
            return this.comparator.compare(k1.getPublicKey(), k2.getPublicKey());
        }
    };

    public P2PHKSignature() {
    }

    public P2PHKSignature(byte[] signBytes, byte[] publicKey) {
        this.signData = new NulsSignData();
        try {
            this.signData.parse(signBytes, 0);
        }
        catch (NulsException e) {
            Log.error(e);
        }
        this.publicKey = publicKey;
    }

    public P2PHKSignature(NulsSignData signData, byte[] publicKey) {
        this.signData = signData;
        this.publicKey = publicKey;
    }

    public NulsSignData getSignData() {
        return this.signData;
    }

    public void setSignData(NulsSignData signData) {
        this.signData = signData;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public Result verifySign(NulsHash digestData) {
        boolean b = ECKey.verify(digestData.getBytes(), this.signData.getSignBytes(), this.getPublicKey());
        if (b) {
            return new Result(true);
        }
        return new Result(false);
    }

    public byte[] getSignerHash160() {
        return SerializeUtils.sha256hash160(this.getPublicKey());
    }

    public static P2PHKSignature createFromBytes(byte[] bytes) throws NulsException {
        P2PHKSignature sig = new P2PHKSignature();
        sig.parse(bytes, 0);
        return sig;
    }

    public byte[] getBytes() {
        try {
            return this.serialize();
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.publicKey.length);
        stream.write(this.publicKey);
        stream.writeNulsData(this.signData);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        byte length = byteBuffer.readByte();
        this.publicKey = byteBuffer.readBytes(length);
        this.signData = new NulsSignData();
        this.signData.parse(byteBuffer);
    }

    @Override
    public int size() {
        int size = 1 + this.publicKey.length;
        return size += SerializeUtils.sizeOfNulsData(this.signData);
    }

    public Result verifySignature(NulsHash digestData) {
        boolean b = ECKey.verify(digestData.getBytes(), this.signData.getSignBytes(), this.publicKey);
        if (b) {
            return new Result(true);
        }
        return new Result(false);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode(this.signData.getSignBytes());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof P2PHKSignature)) {
            return false;
        }
        return Arrays.equals(this.signData.getSignBytes(), ((P2PHKSignature)obj).signData.getSignBytes());
    }
}

