/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.core.inteceptor.base;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.MethodProxy;
import network.nerve.core.core.inteceptor.base.BeanMethodInterceptor;
import network.nerve.core.core.inteceptor.base.BeanMethodInterceptorChain;
import network.nerve.core.log.Log;

public class MultipleBeanMethodInterceptorChain
extends BeanMethodInterceptorChain {
    protected List<Annotation> annotationList = new ArrayList<Annotation>();
    protected Integer index = -1;
    protected MethodProxy methodProxy;

    public MultipleBeanMethodInterceptorChain(List<Annotation> annotations, List<BeanMethodInterceptorChain> chainList) {
        if (null == annotations || annotations.isEmpty()) {
            return;
        }
        for (int i = 0; i < annotations.size(); ++i) {
            this.fillInterceptorList(annotations.get(i), chainList.get(i));
        }
    }

    private void fillInterceptorList(Annotation annotation, BeanMethodInterceptorChain beanMethodInterceptorChain) {
        for (BeanMethodInterceptor interceptor : beanMethodInterceptorChain.interceptorList) {
            this.annotationList.add(annotation);
            this.interceptorList.add(interceptor);
        }
    }

    @Override
    public Object startInterceptor(Annotation annotation, Object object, Method method, Object[] params, MethodProxy methodProxy) throws Throwable {
        this.methodProxy = methodProxy;
        this.index = -1;
        Object result = null;
        try {
            result = this.execute(null, object, method, params);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), e);
            throw e;
        }
        finally {
            this.index = -1;
            this.methodProxy = null;
        }
        return result;
    }

    @Override
    public Object execute(Annotation annotation, Object object, Method method, Object[] params) throws Throwable {
        this.index = this.index + 1;
        if (this.index.intValue() == this.interceptorList.size()) {
            return this.methodProxy.invokeSuper(object, params);
        }
        annotation = this.annotationList.get(this.index);
        BeanMethodInterceptor interceptor = (BeanMethodInterceptor)this.interceptorList.get(this.index);
        return interceptor.intercept(annotation, object, method, params, this);
    }
}

