/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.crypto;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import network.nerve.core.crypto.EncryptedData;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.crypto.Sha256Hash;
import network.nerve.core.exception.CryptoException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESEncrypt {
    public static byte[] encrypt(byte[] plainBytes, String password) {
        EncryptedData ed = AESEncrypt.encrypt(plainBytes, new KeyParameter(Sha256Hash.hash(password.getBytes())));
        return ed.getEncryptedBytes();
    }

    public static EncryptedData encrypt(byte[] plainBytes, KeyParameter aesKey) {
        return AESEncrypt.encrypt(plainBytes, null, aesKey);
    }

    public static EncryptedData encrypt(byte[] plainBytes, byte[] iv, KeyParameter aesKey) throws RuntimeException {
        HexUtil.checkNotNull(plainBytes);
        HexUtil.checkNotNull(aesKey);
        try {
            if (iv == null) {
                iv = EncryptedData.DEFAULT_IV;
            }
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)aesKey, iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
            cipher.init(true, (CipherParameters)keyWithIv);
            byte[] encryptedBytes = new byte[cipher.getOutputSize(plainBytes.length)];
            int length1 = cipher.processBytes(plainBytes, 0, plainBytes.length, encryptedBytes, 0);
            int length2 = cipher.doFinal(encryptedBytes, length1);
            return new EncryptedData(iv, Arrays.copyOf(encryptedBytes, length1 + length2));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decrypt(byte[] dataToDecrypt, String password) throws CryptoException {
        byte[] defaultiv = new byte[16];
        EncryptedData data = new EncryptedData(defaultiv, dataToDecrypt);
        return AESEncrypt.decrypt(data, new KeyParameter(Sha256Hash.hash(password.getBytes())));
    }

    public static byte[] decrypt(byte[] dataToDecrypt, String password, String charset) throws CryptoException, UnsupportedEncodingException {
        byte[] defaultiv = new byte[16];
        EncryptedData data = new EncryptedData(defaultiv, dataToDecrypt);
        return AESEncrypt.decrypt(data, new KeyParameter(Sha256Hash.hash(password.getBytes(charset))));
    }

    public static byte[] decrypt(EncryptedData dataToDecrypt, KeyParameter aesKey) throws CryptoException {
        HexUtil.checkNotNull(dataToDecrypt);
        HexUtil.checkNotNull(aesKey);
        try {
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey.getKey()), dataToDecrypt.getInitialisationVector());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
            cipher.init(false, (CipherParameters)keyWithIv);
            byte[] cipherBytes = dataToDecrypt.getEncryptedBytes();
            byte[] decryptedBytes = new byte[cipher.getOutputSize(cipherBytes.length)];
            int length1 = cipher.processBytes(cipherBytes, 0, cipherBytes.length, decryptedBytes, 0);
            int length2 = cipher.doFinal(decryptedBytes, length1);
            return Arrays.copyOf(decryptedBytes, length1 + length2);
        }
        catch (Exception e) {
            throw new CryptoException();
        }
    }
}

