/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.crypto;

import java.math.BigInteger;
import network.nerve.core.crypto.AESEncrypt;
import network.nerve.core.crypto.ECKey;
import network.nerve.core.crypto.EncryptedData;
import network.nerve.core.crypto.HMacWithSha256;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.crypto.Sha512Hash;
import network.nerve.core.exception.CryptoException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.junit.Assert;

public class ECIESUtil {
    public static byte[] encrypt(byte[] userPubKey, byte[] msg) {
        ECKey ephemECKey = new ECKey();
        ECPrivateKeyParameters ephemPrivateKey = new ECPrivateKeyParameters(new BigInteger(1, ephemECKey.getPrivKeyBytes()), ECKey.CURVE);
        byte[] ephemPublicKeyBytes = ephemECKey.getPubKeyPoint().getEncoded(false);
        byte[] sharedSecret = ECIESUtil.deriveSharedSecret(ephemPrivateKey, userPubKey);
        byte[] rsData = Sha512Hash.sha512(sharedSecret);
        byte[] encryptionKey = new byte[32];
        byte[] macKey = new byte[32];
        System.arraycopy(rsData, 0, encryptionKey, 0, 32);
        System.arraycopy(rsData, 32, macKey, 0, 32);
        EncryptedData encrypt = AESEncrypt.encrypt(msg, new KeyParameter(encryptionKey));
        byte[] encryptedBytes = encrypt.getEncryptedBytes();
        byte[] dataToMacBytes = Arrays.concatenate((byte[])EncryptedData.DEFAULT_IV, (byte[])ephemPublicKeyBytes, (byte[])encryptedBytes);
        byte[] macOutput = HMacWithSha256.hmac(dataToMacBytes, macKey);
        return Arrays.concatenate((byte[])ephemPublicKeyBytes, (byte[])EncryptedData.DEFAULT_IV, (byte[])encryptedBytes, (byte[])macOutput);
    }

    public static byte[] decrypt(byte[] userPriKey, String encryptedData) throws CryptoException {
        byte[] decode = HexUtil.decode(encryptedData);
        int encryptSize = decode.length - 65 - 16 - 32;
        byte[] encryptedBytes = new byte[encryptSize];
        byte[] ephemPublicKeyBytes = new byte[65];
        byte[] iv = new byte[16];
        byte[] mac = new byte[32];
        System.arraycopy(decode, 0, ephemPublicKeyBytes, 0, 65);
        System.arraycopy(decode, 65, iv, 0, 16);
        System.arraycopy(decode, 81, encryptedBytes, 0, encryptSize);
        System.arraycopy(decode, decode.length - 32, mac, 0, 32);
        return ECIESUtil.decrypt(userPriKey, ephemPublicKeyBytes, iv, encryptedBytes, mac);
    }

    private static byte[] decrypt(byte[] userPriKey, byte[] ephemPublicKeyBytes, byte[] iv, byte[] encryptedBytes, byte[] mac) throws CryptoException {
        ECPublicKeyParameters ephemPublicKey = new ECPublicKeyParameters(ECKey.CURVE.getCurve().decodePoint(ephemPublicKeyBytes), ECKey.CURVE);
        byte[] sharedSecret = ECIESUtil.deriveSharedSecret(userPriKey, ephemPublicKey);
        byte[] rsData = Sha512Hash.sha512(sharedSecret);
        byte[] encryptionKey = new byte[32];
        byte[] macKey = new byte[32];
        System.arraycopy(rsData, 0, encryptionKey, 0, 32);
        System.arraycopy(rsData, 32, macKey, 0, 32);
        byte[] dataToMacBytes = Arrays.concatenate((byte[])iv, (byte[])ephemPublicKeyBytes, (byte[])encryptedBytes);
        byte[] macOutput = HMacWithSha256.hmac(dataToMacBytes, macKey);
        Assert.assertTrue((String)"mac invalid", (boolean)Arrays.areEqual((byte[])macOutput, (byte[])mac));
        EncryptedData aesData = new EncryptedData(encryptedBytes);
        byte[] decrypt = AESEncrypt.decrypt(aesData, new KeyParameter(encryptionKey));
        return decrypt;
    }

    private static byte[] deriveSharedSecret(ECPrivateKeyParameters priKeyParaA, byte[] pubKeyB) {
        ECDHBasicAgreement agreement = new ECDHBasicAgreement();
        agreement.init((CipherParameters)priKeyParaA);
        ECPublicKeyParameters pubKeyParaB = new ECPublicKeyParameters(ECKey.CURVE.getCurve().decodePoint(pubKeyB), ECKey.CURVE);
        BigInteger result = agreement.calculateAgreement((CipherParameters)pubKeyParaB);
        byte[] sharedSecret = BigIntegers.asUnsignedByteArray((int)agreement.getFieldSize(), (BigInteger)result);
        return sharedSecret;
    }

    private static byte[] deriveSharedSecret(byte[] priKeyA, ECPublicKeyParameters pubKeyParaB) {
        ECPrivateKeyParameters priKeyParaA = new ECPrivateKeyParameters(new BigInteger(1, priKeyA), ECKey.CURVE);
        ECDHBasicAgreement agreement = new ECDHBasicAgreement();
        agreement.init((CipherParameters)priKeyParaA);
        BigInteger result = agreement.calculateAgreement((CipherParameters)pubKeyParaB);
        byte[] sharedSecret = BigIntegers.asUnsignedByteArray((int)agreement.getFieldSize(), (BigInteger)result);
        return sharedSecret;
    }
}

