/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import network.nerve.core.model.StringUtils;

public class ObjectUtils {
    public static void isEquals(Object val1, Object val2, String msg) {
        if (val1 == val2 || val1 != null && val1.equals(val2)) {
            return;
        }
        throw new RuntimeException(msg);
    }

    public static void canNotEmpty(Object val) {
        ObjectUtils.canNotEmpty(val, "null parameter");
    }

    public static void canNotEmpty(Object val, String msg) {
        boolean b = false;
        if (null == val) {
            b = true;
        } else if (val instanceof String) {
            b = StringUtils.isBlank(val + "");
        } else if (val instanceof List) {
            b = ((List)val).isEmpty();
        } else if (val instanceof Map) {
            b = ((Map)val).isEmpty();
        } else if (val instanceof String[]) {
            b = ((String[])val).length == 0;
        } else if (val instanceof byte[]) {
            boolean bl = b = ((byte[])val).length == 0;
        }
        if (b) {
            throw new RuntimeException(msg);
        }
    }

    public static <T> byte[] objectToBytes(T obj) {
        byte[] bytes = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream sOut = new ObjectOutputStream(out);
            sOut.writeObject(obj);
            sOut.flush();
            bytes = out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static <T> T bytesToObject(byte[] bytes) {
        Object t = null;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream sIn = new ObjectInputStream(in);
            t = sIn.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }
}

