/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.service;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import network.nerve.SDKContext;
import network.nerve.base.basic.AddressTool;
import network.nerve.base.basic.TransactionFeeCalculator;
import network.nerve.base.data.CoinData;
import network.nerve.base.data.CoinFrom;
import network.nerve.base.data.CoinTo;
import network.nerve.base.data.NulsHash;
import network.nerve.base.data.Transaction;
import network.nerve.base.signture.MultiSignTxSignature;
import network.nerve.core.basic.Result;
import network.nerve.core.constant.ErrorCode;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.exception.NulsException;
import network.nerve.core.model.BigIntegerUtils;
import network.nerve.core.model.StringUtils;
import network.nerve.core.rpc.util.NulsDateUtils;
import network.nerve.kit.constant.AccountConstant;
import network.nerve.kit.constant.Constant;
import network.nerve.kit.error.AccountErrorCode;
import network.nerve.kit.model.NerveTokenAmount;
import network.nerve.kit.model.dto.AliasDto;
import network.nerve.kit.model.dto.CoinFromDto;
import network.nerve.kit.model.dto.CoinToDto;
import network.nerve.kit.model.dto.ConsensusDto;
import network.nerve.kit.model.dto.CrossTransferForm;
import network.nerve.kit.model.dto.CrossTransferTxFeeDto;
import network.nerve.kit.model.dto.DepositDto;
import network.nerve.kit.model.dto.MultiSignAliasDto;
import network.nerve.kit.model.dto.MultiSignConsensusDto;
import network.nerve.kit.model.dto.MultiSignDepositDto;
import network.nerve.kit.model.dto.MultiSignStopConsensusDto;
import network.nerve.kit.model.dto.MultiSignTransferDto;
import network.nerve.kit.model.dto.MultiSignTransferTxFeeDto;
import network.nerve.kit.model.dto.MultiSignWithDrawDto;
import network.nerve.kit.model.dto.RestFulResult;
import network.nerve.kit.model.dto.RpcResult;
import network.nerve.kit.model.dto.RpcResultError;
import network.nerve.kit.model.dto.SignDto;
import network.nerve.kit.model.dto.StopConsensusDto;
import network.nerve.kit.model.dto.StopDepositDto;
import network.nerve.kit.model.dto.TransactionDto;
import network.nerve.kit.model.dto.TransferDto;
import network.nerve.kit.model.dto.TransferForm;
import network.nerve.kit.model.dto.TransferTxFeeDto;
import network.nerve.kit.model.dto.WithDrawDto;
import network.nerve.kit.model.dto.WithdrawalTxDto;
import network.nerve.kit.txdata.Agent;
import network.nerve.kit.txdata.Alias;
import network.nerve.kit.txdata.CancelDeposit;
import network.nerve.kit.txdata.Deposit;
import network.nerve.kit.txdata.StableSwapTradeData;
import network.nerve.kit.txdata.StopAgent;
import network.nerve.kit.txdata.WithdrawalAdditionalFeeTxData;
import network.nerve.kit.txdata.WithdrawalTxData;
import network.nerve.kit.util.AccountTool;
import network.nerve.kit.util.CommonValidator;
import network.nerve.kit.util.JsonRpcUtil;
import network.nerve.kit.util.ListUtil;
import network.nerve.kit.util.NerveSDKTool;
import network.nerve.kit.util.RestFulUtil;
import network.nerve.kit.util.TxUtils;
import network.nerve.kit.util.ValidateUtil;

public class TransactionService {
    private static TransactionService instance = new TransactionService();

    private TransactionService() {
    }

    public static TransactionService getInstance() {
        return instance;
    }

    public Result getTx(String txHash) {
        Result<TransactionDto> result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/tx/" + txHash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            TransactionDto tx = TransactionDto.mapToPojo(map);
            result.setData(tx);
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getTransaction(String txHash) {
        Result<TransactionDto> result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/tx/" + txHash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            TransactionDto tx = TransactionDto.mapToPojo(map);
            restFulResult = RestFulUtil.get("api/block/header/height/" + tx.getBlockHeight());
            if (restFulResult.isSuccess()) {
                map = restFulResult.getData();
                tx.setBlockHash((String)map.get("hash"));
            }
            result.setData(tx);
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result transfer(TransferForm transferForm) {
        Result result;
        ValidateUtil.validateChainId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", transferForm.getAddress());
        params.put("toAddress", transferForm.getToAddress());
        params.put("password", transferForm.getPassword());
        params.put("amount", transferForm.getAmount());
        params.put("remark", transferForm.getRemark());
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/accountledger/transfer", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result crossTransfer(CrossTransferForm form) {
        Result result;
        ValidateUtil.validateChainId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", form.getAddress());
        params.put("toAddress", form.getToAddress());
        params.put("password", form.getPassword());
        params.put("assetChainId", form.getAssetChainId());
        params.put("assetId", form.getAssetId());
        params.put("amount", form.getAmount());
        params.put("remark", form.getRemark());
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/accountledger/crossTransfer", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
            result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public BigInteger calcTransferTxFee(TransferTxFeeDto dto) {
        if (dto.getPrice() == null) {
            dto.setPrice(TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES);
        }
        return TxUtils.calcTransferTxFee(dto.getAddressCount(), dto.getFromLength(), dto.getToLength(), dto.getRemark(), dto.getPrice());
    }

    public Map<String, BigInteger> calcCrossTransferTxFee(CrossTransferTxFeeDto dto) {
        return TxUtils.calcCrossTxFee(dto.getAddressCount(), dto.getFromLength(), dto.getToLength(), dto.getRemark());
    }

    public Result createTxSimpleTransferOfNonNvt(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount) {
        return this.createTxSimpleTransferOfNonNvt(fromAddress, toAddress, assetChainId, assetId, amount, 0L, null);
    }

    public Result createTxSimpleTransferOfNonNvt(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount, long time, String remark) {
        Result accountBalanceR = NerveSDKTool.getAccountBalance(fromAddress, assetChainId, assetId);
        if (!accountBalanceR.isSuccess()) {
            return Result.getFailed(accountBalanceR.getErrorCode()).setMsg(accountBalanceR.getMsg());
        }
        Map balance = (Map)accountBalanceR.getData();
        String nonce = balance.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(amount);
        from.setAssetChainId(assetChainId);
        from.setAssetId(assetId);
        from.setNonce(nonce);
        inputs.add(from);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(assetChainId);
        to.setAssetId(assetId);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createTransferTx(transferDto);
    }

    public Result createTxSimpleTransferOfNvt(String fromAddress, String toAddress, BigInteger amount) {
        return this.createTxSimpleTransferOfNvt(fromAddress, toAddress, amount, 0L, null);
    }

    public Result createTxSimpleTransferOfNvt(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        Result accountBalanceR = NerveSDKTool.getAccountBalance(fromAddress, SDKContext.main_chain_id, SDKContext.main_asset_id);
        if (!accountBalanceR.isSuccess()) {
            return Result.getFailed(accountBalanceR.getErrorCode()).setMsg(accountBalanceR.getMsg());
        }
        Map balance = (Map)accountBalanceR.getData();
        String nonce = balance.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(amount);
        from.setAssetChainId(SDKContext.main_chain_id);
        from.setAssetId(SDKContext.main_asset_id);
        from.setNonce(nonce);
        inputs.add(from);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(SDKContext.main_chain_id);
        to.setAssetId(SDKContext.main_asset_id);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createTransferTx(transferDto);
    }

    public Result createTransferTx(TransferDto transferDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkTransferDto(transferDto);
            for (CoinFromDto fromDto : transferDto.getInputs()) {
                if (fromDto.getAssetChainId() == 0) {
                    fromDto.setAssetChainId(SDKContext.main_chain_id);
                }
                if (fromDto.getAssetId() != 0) continue;
                fromDto.setAssetId(SDKContext.main_asset_id);
            }
            for (CoinToDto toDto : transferDto.getOutputs()) {
                if (toDto.getAssetChainId() == 0) {
                    toDto.setAssetChainId(SDKContext.main_chain_id);
                }
                if (toDto.getAssetId() != 0) continue;
                toDto.setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(2);
            if (transferDto.getTime() != 0L) {
                tx.setTime(transferDto.getTime());
            } else {
                tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            }
            tx.setRemark(StringUtils.bytes(transferDto.getRemark()));
            CoinData coinData = this.assemblyCoinData(transferDto.getInputs(), transferDto.getOutputs(), tx.getSize());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(List<CoinFromDto> inputs, List<CoinToDto> outputs, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        for (CoinFromDto coinFromDto : inputs) {
            byte[] address = AddressTool.getAddress(coinFromDto.getAddress());
            byte[] nonce = HexUtil.decode(coinFromDto.getNonce());
            CoinFrom coinFrom = new CoinFrom(address, coinFromDto.getAssetChainId(), coinFromDto.getAssetId(), coinFromDto.getAmount(), nonce, 0);
            coinFroms.add(coinFrom);
        }
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        for (CoinToDto to : outputs) {
            byte[] addressByte = AddressTool.getAddress(to.getAddress());
            CoinTo coinTo = new CoinTo(addressByte, to.getAssetChainId(), to.getAssetId(), to.getAmount(), to.getLockTime());
            coinTos.add(coinTo);
        }
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getSignatureSize(coinFroms));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createCrossTxSimpleTransferOfNonNvtNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount) {
        return this.createCrossTxSimpleTransferOfNonNvtNuls(fromAddress, toAddress, assetChainId, assetId, amount, 0L, null);
    }

    public Result createCrossTxSimpleTransferOfNonNvtNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount, long time, String remark) {
        Result accountBalanceR = NerveSDKTool.getAccountBalance(fromAddress, assetChainId, assetId);
        if (!accountBalanceR.isSuccess()) {
            return Result.getFailed(accountBalanceR.getErrorCode()).setMsg(accountBalanceR.getMsg());
        }
        Map balance = (Map)accountBalanceR.getData();
        String nonce = balance.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(amount);
        from.setAssetChainId(assetChainId);
        from.setAssetId(assetId);
        from.setNonce(nonce);
        inputs.add(from);
        CrossTransferTxFeeDto crossFeeDto = new CrossTransferTxFeeDto();
        crossFeeDto.setAddressCount(1);
        crossFeeDto.setFromLength(2);
        crossFeeDto.setToLength(1);
        crossFeeDto.setRemark(remark);
        Map<String, BigInteger> feeMap = this.calcCrossTransferTxFee(crossFeeDto);
        BigInteger feeNvtNeed = feeMap.get("LOCAL");
        BigInteger feeNulsNeed = feeMap.get("NULS");
        Result accountNvtBalanceFeeR = NerveSDKTool.getAccountBalance(fromAddress, SDKContext.main_chain_id, SDKContext.main_asset_id);
        if (!accountNvtBalanceFeeR.isSuccess()) {
            return Result.getFailed(accountNvtBalanceFeeR.getErrorCode()).setMsg(accountNvtBalanceFeeR.getMsg());
        }
        Map balanceNvtFee = (Map)accountNvtBalanceFeeR.getData();
        String nonceNvtFee = balanceNvtFee.get("nonce").toString();
        Result accountNulsBalanceFeeR = NerveSDKTool.getAccountBalance(fromAddress, SDKContext.nuls_chain_id, SDKContext.nuls_asset_id);
        if (!accountNulsBalanceFeeR.isSuccess()) {
            return Result.getFailed(accountNulsBalanceFeeR.getErrorCode()).setMsg(accountNulsBalanceFeeR.getMsg());
        }
        Map balanceNulsFee = (Map)accountNulsBalanceFeeR.getData();
        String nonceNulsFee = balanceNulsFee.get("nonce").toString();
        CoinFromDto fromNvtFee = new CoinFromDto();
        fromNvtFee.setAddress(fromAddress);
        fromNvtFee.setAmount(feeNvtNeed);
        fromNvtFee.setAssetChainId(SDKContext.main_chain_id);
        fromNvtFee.setAssetId(SDKContext.main_asset_id);
        fromNvtFee.setNonce(nonceNvtFee);
        inputs.add(fromNvtFee);
        CoinFromDto fromNulsFee = new CoinFromDto();
        fromNulsFee.setAddress(fromAddress);
        fromNulsFee.setAmount(feeNulsNeed);
        fromNulsFee.setAssetChainId(SDKContext.nuls_chain_id);
        fromNulsFee.setAssetId(SDKContext.nuls_asset_id);
        fromNulsFee.setNonce(nonceNulsFee);
        inputs.add(fromNulsFee);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(assetChainId);
        to.setAssetId(assetId);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createCrossTransferTx(transferDto);
    }

    public Result createCrossTxSimpleTransferOfNvt(String fromAddress, String toAddress, BigInteger amount) {
        return this.createCrossTxSimpleTransferOfNvt(fromAddress, toAddress, amount, 0L, null);
    }

    public Result createCrossTxSimpleTransferOfNvt(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        Result accountBalanceR = NerveSDKTool.getAccountBalance(fromAddress, SDKContext.main_chain_id, SDKContext.main_asset_id);
        if (!accountBalanceR.isSuccess()) {
            return Result.getFailed(accountBalanceR.getErrorCode()).setMsg(accountBalanceR.getMsg());
        }
        Map balance = (Map)accountBalanceR.getData();
        CrossTransferTxFeeDto crossFeeDto = new CrossTransferTxFeeDto();
        crossFeeDto.setAddressCount(1);
        crossFeeDto.setFromLength(2);
        crossFeeDto.setToLength(1);
        crossFeeDto.setRemark(remark);
        Map<String, BigInteger> feeMap = this.calcCrossTransferTxFee(crossFeeDto);
        BigInteger feeNvtNeed = feeMap.get("LOCAL");
        BigInteger feeNulsNeed = feeMap.get("NULS");
        BigInteger amountTotal = amount.add(feeNvtNeed);
        String nonce = balance.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(amountTotal);
        from.setAssetChainId(SDKContext.main_chain_id);
        from.setAssetId(SDKContext.main_asset_id);
        from.setNonce(nonce);
        inputs.add(from);
        Result accountNulsBalanceFeeR = NerveSDKTool.getAccountBalance(fromAddress, SDKContext.nuls_chain_id, SDKContext.nuls_asset_id);
        if (!accountNulsBalanceFeeR.isSuccess()) {
            return Result.getFailed(accountNulsBalanceFeeR.getErrorCode()).setMsg(accountNulsBalanceFeeR.getMsg());
        }
        Map balanceNulsFee = (Map)accountNulsBalanceFeeR.getData();
        String nonceNulsFee = balanceNulsFee.get("nonce").toString();
        CoinFromDto fromNulsFee = new CoinFromDto();
        fromNulsFee.setAddress(fromAddress);
        fromNulsFee.setAmount(feeNulsNeed);
        fromNulsFee.setAssetChainId(SDKContext.nuls_chain_id);
        fromNulsFee.setAssetId(SDKContext.nuls_asset_id);
        fromNulsFee.setNonce(nonceNulsFee);
        inputs.add(fromNulsFee);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(SDKContext.main_chain_id);
        to.setAssetId(SDKContext.main_asset_id);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createCrossTransferTx(transferDto);
    }

    public Result createCrossTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount) {
        return this.createCrossTxSimpleTransferOfNuls(fromAddress, toAddress, amount, 0L, null);
    }

    public Result createCrossTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        Result accountNvtBalanceR = NerveSDKTool.getAccountBalance(fromAddress, SDKContext.main_chain_id, SDKContext.main_asset_id);
        if (!accountNvtBalanceR.isSuccess()) {
            return Result.getFailed(accountNvtBalanceR.getErrorCode()).setMsg(accountNvtBalanceR.getMsg());
        }
        Map balanceNvtFee = (Map)accountNvtBalanceR.getData();
        CrossTransferTxFeeDto crossFeeDto = new CrossTransferTxFeeDto();
        crossFeeDto.setAddressCount(1);
        crossFeeDto.setFromLength(2);
        crossFeeDto.setToLength(1);
        crossFeeDto.setRemark(remark);
        Map<String, BigInteger> feeMap = this.calcCrossTransferTxFee(crossFeeDto);
        BigInteger feeNvtNeed = feeMap.get("LOCAL");
        BigInteger feeNulsNeed = feeMap.get("NULS");
        String nonceNvtFee = balanceNvtFee.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(feeNvtNeed);
        from.setAssetChainId(SDKContext.main_chain_id);
        from.setAssetId(SDKContext.main_asset_id);
        from.setNonce(nonceNvtFee);
        inputs.add(from);
        Result accountNulsBalanceFeeR = NerveSDKTool.getAccountBalance(fromAddress, SDKContext.nuls_chain_id, SDKContext.nuls_asset_id);
        if (!accountNulsBalanceFeeR.isSuccess()) {
            return Result.getFailed(accountNulsBalanceFeeR.getErrorCode()).setMsg(accountNulsBalanceFeeR.getMsg());
        }
        Map balanceNulsFee = (Map)accountNulsBalanceFeeR.getData();
        BigInteger senderNulsBalanceFee = new BigInteger(balanceNulsFee.get("available").toString());
        BigInteger amountTotal = amount.add(feeNulsNeed);
        String nonceNulsFee = balanceNulsFee.get("nonce").toString();
        CoinFromDto fromNulsFee = new CoinFromDto();
        fromNulsFee.setAddress(fromAddress);
        fromNulsFee.setAmount(amountTotal);
        fromNulsFee.setAssetChainId(SDKContext.nuls_chain_id);
        fromNulsFee.setAssetId(SDKContext.nuls_asset_id);
        fromNulsFee.setNonce(nonceNulsFee);
        inputs.add(fromNulsFee);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(SDKContext.nuls_chain_id);
        to.setAssetId(SDKContext.nuls_asset_id);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createCrossTransferTx(transferDto);
    }

    public Result createCrossTransferTx(TransferDto transferDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkCrossTransferDto(transferDto);
            Transaction tx = new Transaction(10);
            if (transferDto.getTime() != 0L) {
                tx.setTime(transferDto.getTime());
            } else {
                tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            }
            tx.setRemark(StringUtils.bytes(transferDto.getRemark()));
            CoinData coinData = this.createCrossTxCoinData(transferDto.getInputs(), transferDto.getOutputs());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public CoinData createCrossTxCoinData(List<CoinFromDto> inputs, List<CoinToDto> outputs) {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        for (CoinFromDto coinFromDto : inputs) {
            byte[] address = AddressTool.getAddress(coinFromDto.getAddress());
            byte[] nonce = HexUtil.decode(coinFromDto.getNonce());
            CoinFrom coinFrom = new CoinFrom(address, coinFromDto.getAssetChainId(), coinFromDto.getAssetId(), coinFromDto.getAmount(), nonce, 0);
            coinFroms.add(coinFrom);
        }
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        for (CoinToDto to : outputs) {
            byte[] addressByte = AddressTool.getAddress(to.getAddress());
            CoinTo coinTo = new CoinTo(addressByte, to.getAssetChainId(), to.getAssetId(), to.getAmount(), to.getLockTime());
            coinTos.add(coinTo);
        }
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createWithdrawalTx(WithdrawalTxDto withdrawalTxDto, String withdrawalAssetNonce, String nvtFeeAssetNonce) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkWithdrawalTxDto(withdrawalTxDto);
            WithdrawalTxData txData = new WithdrawalTxData(withdrawalTxDto.getHeterogeneousAddress().toLowerCase());
            txData.setHeterogeneousChainId(withdrawalTxDto.getHeterogeneousChainId());
            byte[] txDataBytes = null;
            try {
                txDataBytes = txData.serialize();
            }
            catch (IOException e) {
                throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
            }
            Transaction tx = new Transaction(43);
            tx.setTxData(txDataBytes);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setRemark(StringUtils.isBlank(withdrawalTxDto.getRemark()) ? null : StringUtils.bytes(withdrawalTxDto.getRemark()));
            byte[] coinData = this.assembleWithdrawalCoinData(withdrawalTxDto, withdrawalAssetNonce, nvtFeeAssetNonce);
            tx.setCoinData(coinData);
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result withdrawalAdditionalFeeTx(String fromAddress, String txHash, BigInteger amount, long time, String remark, String nonce) {
        try {
            if (!AddressTool.validAddress(SDKContext.main_chain_id, fromAddress)) {
                throw new NulsException(AccountErrorCode.IS_NOT_CURRENT_CHAIN_ADDRESS);
            }
            if (StringUtils.isBlank(txHash)) {
                throw new NulsException(AccountErrorCode.NULL_PARAMETER);
            }
            if (null == amount || BigIntegerUtils.isLessThan(amount, BigInteger.ZERO)) {
                throw new NulsException(AccountErrorCode.DATA_ERROR);
            }
            WithdrawalAdditionalFeeTxData txData = new WithdrawalAdditionalFeeTxData(txHash);
            byte[] txDataBytes = null;
            try {
                txDataBytes = txData.serialize();
            }
            catch (IOException e) {
                throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
            }
            Transaction tx = new Transaction(56);
            tx.setTxData(txDataBytes);
            tx.setTime(time);
            tx.setRemark(StringUtils.isBlank(remark) ? null : StringUtils.bytes(remark));
            byte[] coinData = nonce == null ? this.assembleFeeCoinData(fromAddress, amount) : this.assembleFeeCoinData(fromAddress, amount, nonce);
            tx.setCoinData(coinData);
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result stableSwapTradeTx(String from, String to, NerveTokenAmount[] tokenAmountIns, String[] nonces, int tokenOutIndex, String pairAddress, String feeTo, String remark) {
        try {
            byte[] pairAddressBytes = AddressTool.getAddress(pairAddress);
            byte[] fromBytes = AddressTool.getAddress(from);
            StableSwapTradeData data = new StableSwapTradeData();
            data.setTo(AddressTool.getAddress(to));
            data.setTokenOutIndex((byte)tokenOutIndex);
            data.setFeeTo(feeTo != null ? AddressTool.getAddress(feeTo) : null);
            Transaction tx = new Transaction(72);
            tx.setTxData(TxUtils.nulsData2HexBytes(data));
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setRemark(StringUtils.isBlank(remark) ? null : StringUtils.bytes(remark));
            CoinData coinData = new CoinData();
            List<CoinFrom> froms = coinData.getFrom();
            List<CoinTo> tos = coinData.getTo();
            int length = tokenAmountIns.length;
            nonces = this.checkNonces(from, tokenAmountIns, nonces);
            for (int i = 0; i < length; ++i) {
                NerveTokenAmount token = tokenAmountIns[i];
                BigInteger amount = token.getAmount();
                String nonce = nonces[i];
                froms.add(new CoinFrom(fromBytes, token.getChainId(), token.getAssetId(), amount, HexUtil.decode(nonce), 0));
                tos.add(new CoinTo(pairAddressBytes, token.getChainId(), token.getAssetId(), amount));
            }
            tx.setCoinData(TxUtils.nulsData2HexBytes(coinData));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(TxUtils.nulsData2HexBytes(tx)));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    private String[] checkNonces(String address, NerveTokenAmount[] tokens, String[] nonces) throws NulsException {
        if (nonces != null) {
            return nonces;
        }
        int length = tokens.length;
        nonces = new String[length];
        for (int i = 0; i < length; ++i) {
            NerveTokenAmount token = tokens[i];
            Result accountBalance = NerveSDKTool.getAccountBalance(address, token.getChainId(), token.getAssetId());
            if (!accountBalance.isSuccess()) {
                throw new NulsException(AccountErrorCode.NOT_FOUND_NONCE);
            }
            Map balance = (Map)accountBalance.getData();
            nonces[i] = balance.get("nonce").toString();
        }
        return nonces;
    }

    private byte[] assembleWithdrawalCoinData(WithdrawalTxDto withdrawalTxDto, String withdrawalAssetNonce, String nvtFeeAssetNonce) throws NulsException {
        int withdrawalAssetId = withdrawalTxDto.getAssetId();
        int withdrawalAssetChainId = withdrawalTxDto.getAssetChainId();
        int chainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        BigInteger amount = withdrawalTxDto.getAmount();
        String address = withdrawalTxDto.getFromAddress();
        CoinFrom withdrawalCoinFrom = withdrawalAssetNonce == null ? this.getWithdrawalCoinFrom(address, amount, withdrawalAssetChainId, withdrawalAssetId, withdrawalTxDto.getDistributionFee()) : this.getWithdrawalCoinFrom(address, amount, withdrawalAssetChainId, withdrawalAssetId, withdrawalTxDto.getDistributionFee(), withdrawalAssetNonce);
        ArrayList<CoinFrom> listFrom = new ArrayList<CoinFrom>();
        listFrom.add(withdrawalCoinFrom);
        if (withdrawalAssetChainId != chainId || assetId != withdrawalAssetId) {
            CoinFrom withdrawalFeeCoinFrom = nvtFeeAssetNonce == null ? this.getWithdrawalFeeCoinFrom(address, withdrawalTxDto.getDistributionFee()) : this.getWithdrawalFeeCoinFrom(address, withdrawalTxDto.getDistributionFee(), nvtFeeAssetNonce);
            listFrom.add(withdrawalFeeCoinFrom);
        }
        ArrayList<CoinTo> listTo = new ArrayList<CoinTo>();
        CoinTo withdrawalCoinTo = new CoinTo(AddressTool.getAddress(Constant.WITHDRAWAL_BLACKHOLE_PUBKEY, chainId), withdrawalAssetChainId, withdrawalAssetId, amount);
        listTo.add(withdrawalCoinTo);
        CoinTo withdrawalFeeCoinTo = new CoinTo(AddressTool.getAddress(Constant.FEE_PUBKEY, chainId), chainId, assetId, withdrawalTxDto.getDistributionFee());
        listTo.add(withdrawalFeeCoinTo);
        CoinData coinData = new CoinData(listFrom, listTo);
        try {
            return coinData.serialize();
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
    }

    private CoinFrom getWithdrawalCoinFrom(String address, BigInteger amount, int withdrawalAssetChainId, int withdrawalAssetId, BigInteger withdrawalHeterogeneousFeeNvt) throws NulsException {
        Result accountBalance = NerveSDKTool.getAccountBalance(address, withdrawalAssetChainId, withdrawalAssetId);
        if (!accountBalance.isSuccess()) {
            throw new NulsException(AccountErrorCode.NOT_FOUND_NONCE);
        }
        Map balance = (Map)accountBalance.getData();
        if (withdrawalAssetChainId == SDKContext.main_chain_id && SDKContext.main_asset_id == withdrawalAssetId) {
            BigInteger totalFee = TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES.add(withdrawalHeterogeneousFeeNvt);
            amount = totalFee.add(amount);
        }
        String nonce = balance.get("nonce").toString();
        return new CoinFrom(AddressTool.getAddress(address), withdrawalAssetChainId, withdrawalAssetId, amount, HexUtil.decode(nonce), 0);
    }

    private CoinFrom getWithdrawalCoinFrom(String address, BigInteger amount, int withdrawalAssetChainId, int withdrawalAssetId, BigInteger withdrawalHeterogeneousFeeNvt, String withdrawalAssetNonce) throws NulsException {
        if (withdrawalAssetChainId == SDKContext.main_chain_id && SDKContext.main_asset_id == withdrawalAssetId) {
            BigInteger totalFee = TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES.add(withdrawalHeterogeneousFeeNvt);
            amount = totalFee.add(amount);
        }
        return new CoinFrom(AddressTool.getAddress(address), withdrawalAssetChainId, withdrawalAssetId, amount, HexUtil.decode(withdrawalAssetNonce), 0);
    }

    private CoinFrom getWithdrawalFeeCoinFrom(String address, BigInteger withdrawalHeterogeneousFeeNvt) throws NulsException {
        int chainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        Result accountBalance = NerveSDKTool.getAccountBalance(address, chainId, assetId);
        if (!accountBalance.isSuccess()) {
            throw new NulsException(AccountErrorCode.NOT_FOUND_NONCE);
        }
        Map balanceMap = (Map)accountBalance.getData();
        BigInteger balance = new BigInteger(balanceMap.get("available").toString());
        BigInteger totalFee = TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES.add(withdrawalHeterogeneousFeeNvt);
        String nonce = balanceMap.get("nonce").toString();
        return new CoinFrom(AddressTool.getAddress(address), chainId, assetId, totalFee, HexUtil.decode(nonce), 0);
    }

    private CoinFrom getWithdrawalFeeCoinFrom(String address, BigInteger withdrawalHeterogeneousFeeNvt, String nvtFeeAssetNonce) throws NulsException {
        int chainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        BigInteger totalFee = TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES.add(withdrawalHeterogeneousFeeNvt);
        return new CoinFrom(AddressTool.getAddress(address), chainId, assetId, totalFee, HexUtil.decode(nvtFeeAssetNonce), 0);
    }

    private byte[] assembleFeeCoinData(String address, BigInteger extraFee) throws NulsException {
        int assetChainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        Result accountBalance = NerveSDKTool.getAccountBalance(address, assetChainId, assetId);
        if (!accountBalance.isSuccess()) {
            throw new NulsException(AccountErrorCode.NOT_FOUND_NONCE);
        }
        Map balanceMap = (Map)accountBalance.getData();
        BigInteger amount = TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES.add(extraFee);
        String nonce = balanceMap.get("nonce").toString();
        CoinFrom coinFrom = new CoinFrom(AddressTool.getAddress(address), assetChainId, assetId, amount, HexUtil.decode(nonce), 0);
        CoinData coinData = new CoinData();
        ArrayList<CoinFrom> froms = new ArrayList<CoinFrom>();
        froms.add(coinFrom);
        ArrayList<CoinTo> tos = new ArrayList<CoinTo>();
        CoinTo extraFeeCoinTo = new CoinTo(AddressTool.getAddress(Constant.FEE_PUBKEY, assetChainId), assetChainId, assetId, extraFee);
        tos.add(extraFeeCoinTo);
        coinData.setFrom(froms);
        coinData.setTo(tos);
        try {
            return coinData.serialize();
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
    }

    private byte[] assembleFeeCoinData(String address, BigInteger extraFee, String nonce) throws NulsException {
        int assetChainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        BigInteger amount = TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES.add(extraFee);
        CoinFrom coinFrom = new CoinFrom(AddressTool.getAddress(address), assetChainId, assetId, amount, HexUtil.decode(nonce), 0);
        CoinData coinData = new CoinData();
        ArrayList<CoinFrom> froms = new ArrayList<CoinFrom>();
        froms.add(coinFrom);
        ArrayList<CoinTo> tos = new ArrayList<CoinTo>();
        CoinTo extraFeeCoinTo = new CoinTo(AddressTool.getAddress(Constant.FEE_PUBKEY, assetChainId), assetChainId, assetId, extraFee);
        tos.add(extraFeeCoinTo);
        coinData.setFrom(froms);
        coinData.setTo(tos);
        try {
            return coinData.serialize();
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
    }

    public Result createMultiSignTransferTx(MultiSignTransferDto transferDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkMultiSignTransferDto(transferDto);
            for (CoinFromDto fromDto : transferDto.getInputs()) {
                if (fromDto.getAssetChainId() == 0) {
                    fromDto.setAssetChainId(SDKContext.main_chain_id);
                }
                if (fromDto.getAssetId() != 0) continue;
                fromDto.setAssetId(SDKContext.main_asset_id);
            }
            for (CoinToDto toDto : transferDto.getOutputs()) {
                if (toDto.getAssetChainId() == 0) {
                    toDto.setAssetChainId(SDKContext.main_chain_id);
                }
                if (toDto.getAssetId() != 0) continue;
                toDto.setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(2);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setRemark(StringUtils.bytes(transferDto.getRemark()));
            CoinData coinData = this.assemblyCoinData(transferDto, tx.getSize());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)transferDto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : transferDto.getPubKeys()) {
                list.add(HexUtil.decode(pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(MultiSignTransferDto transferDto, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        for (CoinFromDto coinFromDto : transferDto.getInputs()) {
            byte[] address = AddressTool.getAddress(coinFromDto.getAddress());
            byte[] nonce = HexUtil.decode(coinFromDto.getNonce());
            CoinFrom coinFrom = new CoinFrom(address, coinFromDto.getAssetChainId(), coinFromDto.getAssetId(), coinFromDto.getAmount(), nonce, 0);
            coinFroms.add(coinFrom);
        }
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        for (CoinToDto to : transferDto.getOutputs()) {
            byte[] addressByte = AddressTool.getAddress(to.getAddress());
            CoinTo coinTo = new CoinTo(addressByte, to.getAssetChainId(), to.getAssetId(), to.getAmount(), to.getLockTime());
            coinTos.add(coinTo);
        }
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getMultiSignSignatureSize(transferDto.getPubKeys().size()));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public BigInteger calcMultiSignTransferTxFee(MultiSignTransferTxFeeDto dto) {
        if (dto.getPrice() == null) {
            dto.setPrice(TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES);
        }
        return TxUtils.calcTransferTxFee(dto.getPubKeyCount(), dto.getFromLength(), dto.getToLength(), dto.getRemark(), dto.getPrice());
    }

    private int getSignatureSize(List<CoinFrom> coinFroms) {
        int size = 0;
        HashSet<String> commonAddress = new HashSet<String>();
        for (CoinFrom coinFrom : coinFroms) {
            String address = AddressTool.getStringAddressByBytes(coinFrom.getAddress());
            commonAddress.add(address);
        }
        return size += commonAddress.size() * 110;
    }

    private int getMultiSignSignatureSize(int signNumber) {
        int size = signNumber * 110;
        return size;
    }

    public Result createAliasTx(AliasDto aliasDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkAliasDto(aliasDto);
            Transaction tx = new Transaction(3);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setRemark(StringUtils.bytes(aliasDto.getRemark()));
            Alias alias = new Alias(AddressTool.getAddress(aliasDto.getAddress()), aliasDto.getAlias());
            tx.setTxData(alias.serialize());
            CoinData coinData = this.assemblyCoinData(aliasDto);
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(AliasDto dto) {
        byte[] address = AddressTool.getAddress(dto.getAddress());
        byte[] nonce = HexUtil.decode(dto.getNonce());
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        CoinFrom coinFrom = new CoinFrom();
        coinFrom.setAddress(address);
        coinFrom.setNonce(nonce);
        coinFrom.setAmount(AccountConstant.ALIAS_FEE.add(TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES));
        coinFrom.setAssetsChainId(SDKContext.main_chain_id);
        coinFrom.setAssetsId(SDKContext.main_asset_id);
        coinFroms.add(coinFrom);
        String prefix = AccountTool.getPrefix(dto.getAddress());
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo();
        coinTo.setAddress(AddressTool.getAddress(AccountConstant.DESTORY_PUBKEY, SDKContext.main_chain_id, prefix));
        coinTo.setAmount(AccountConstant.ALIAS_FEE);
        coinTo.setAssetsChainId(SDKContext.main_chain_id);
        coinTo.setAssetsId(SDKContext.main_asset_id);
        coinTos.add(coinTo);
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createConsensusTx(ConsensusDto consensusDto) {
        ValidateUtil.validateChainId();
        try {
            if (StringUtils.isBlank(consensusDto.getRewardAddress())) {
                consensusDto.setRewardAddress(consensusDto.getAgentAddress());
            }
            CommonValidator.validateConsensusDto(consensusDto);
            if (consensusDto.getInput().getAssetChainId() == 0) {
                consensusDto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (consensusDto.getInput().getAssetId() == 0) {
                consensusDto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(4);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Agent agent = new Agent();
            agent.setAgentAddress(AddressTool.getAddress(consensusDto.getAgentAddress()));
            agent.setPackingAddress(AddressTool.getAddress(consensusDto.getPackingAddress()));
            agent.setRewardAddress(AddressTool.getAddress(consensusDto.getRewardAddress()));
            agent.setDeposit(consensusDto.getDeposit());
            agent.setCommissionRate((byte)consensusDto.getCommissionRate());
            tx.setTxData(agent.serialize());
            CoinData coinData = this.assemblyCoinData(consensusDto.getInput(), agent.getDeposit(), tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result createDepositTx(DepositDto dto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.validateDepositDto(dto);
            if (dto.getInput().getAssetChainId() == 0) {
                dto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (dto.getInput().getAssetId() == 0) {
                dto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(5);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Deposit deposit = new Deposit();
            deposit.setAddress(AddressTool.getAddress(dto.getAddress()));
            deposit.setAgentHash(NulsHash.fromHex(dto.getAgentHash()));
            deposit.setDeposit(dto.getDeposit());
            tx.setTxData(deposit.serialize());
            CoinData coinData = this.assemblyCoinData(dto.getInput(), dto.getDeposit(), tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(CoinFromDto from, BigInteger amount, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        byte[] address = AddressTool.getAddress(from.getAddress());
        byte[] nonce = HexUtil.decode(from.getNonce());
        CoinFrom coinFrom = new CoinFrom(address, from.getAssetChainId(), from.getAssetId(), from.getAmount(), nonce, 0);
        coinFroms.add(coinFrom);
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo(address, from.getAssetChainId(), from.getAssetId(), amount, -1L);
        coinTos.add(coinTo);
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getSignatureSize(coinFroms));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createWithdrawDepositTx(WithDrawDto dto) {
        ValidateUtil.validateChainId();
        try {
            if (dto.getPrice() == null) {
                dto.setPrice(TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES);
            }
            CommonValidator.validateWithDrawDto(dto);
            if (dto.getInput().getAssetChainId() == 0) {
                dto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (dto.getInput().getAssetId() == 0) {
                dto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(6);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            CancelDeposit cancelDeposit = new CancelDeposit();
            cancelDeposit.setAddress(AddressTool.getAddress(dto.getAddress()));
            cancelDeposit.setJoinTxHash(NulsHash.fromHex(dto.getDepositHash()));
            tx.setTxData(cancelDeposit.serialize());
            CoinData coinData = this.assemblyCoinData(dto, tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(WithDrawDto dto, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        CoinFromDto from = dto.getInput();
        byte[] address = AddressTool.getAddress(from.getAddress());
        CoinFrom coinFrom = new CoinFrom(address, from.getAssetChainId(), from.getAssetId(), from.getAmount(), -1);
        NulsHash nulsHash = NulsHash.fromHex(dto.getDepositHash());
        coinFrom.setNonce(TxUtils.getNonce(nulsHash.getBytes()));
        coinFroms.add(coinFrom);
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo(address, from.getAssetChainId(), from.getAssetId(), from.getAmount().subtract(dto.getPrice()), 0L);
        coinTos.add(coinTo);
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getSignatureSize(coinFroms));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createStopConsensusTx(StopConsensusDto dto) {
        ValidateUtil.validateChainId();
        try {
            if (dto.getPrice() == null) {
                dto.setPrice(TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES);
            }
            CommonValidator.validateStopConsensusDto(dto);
            for (StopDepositDto depositDto : dto.getDepositList()) {
                if (depositDto.getInput().getAssetChainId() == 0) {
                    depositDto.getInput().setAssetChainId(SDKContext.main_chain_id);
                }
                if (depositDto.getInput().getAssetId() != 0) continue;
                depositDto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(9);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            StopAgent stopAgent = new StopAgent();
            NulsHash nulsHash = NulsHash.fromHex(dto.getAgentHash());
            stopAgent.setCreateTxHash(nulsHash);
            tx.setTxData(stopAgent.serialize());
            CoinData coinData = this.assemblyCoinData(dto, tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(StopConsensusDto dto, int txSize) throws NulsException {
        byte[] address;
        int chainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        ArrayList<CoinFrom> coinFromList = new ArrayList<CoinFrom>();
        byte[] addressBytes = AddressTool.getAddress(dto.getAgentAddress());
        CoinFrom coinFrom = new CoinFrom(addressBytes, chainId, assetId, dto.getDeposit(), -1);
        NulsHash nulsHash = NulsHash.fromHex(dto.getAgentHash());
        coinFrom.setNonce(TxUtils.getNonce(nulsHash.getBytes()));
        coinFromList.add(coinFrom);
        HashMap<String, CoinFromDto> dtoMap = new HashMap<String, CoinFromDto>();
        for (StopDepositDto stopDepositDto : dto.getDepositList()) {
            CoinFromDto input = stopDepositDto.getInput();
            address = AddressTool.getAddress(input.getAddress());
            CoinFrom coinFrom1 = new CoinFrom(address, input.getAssetChainId(), input.getAssetId(), input.getAmount(), -1);
            NulsHash nulsHash1 = NulsHash.fromHex(stopDepositDto.getDepositHash());
            coinFrom1.setNonce(TxUtils.getNonce(nulsHash1.getBytes()));
            coinFromList.add(coinFrom1);
            String key = input.getAddress() + input.getAssetChainId() + input.getAssetId();
            CoinFromDto fromDto = (CoinFromDto)dtoMap.get(key);
            if (fromDto == null) {
                dtoMap.put(key, input);
                continue;
            }
            fromDto.setAmount(fromDto.getAmount().add(input.getAmount()));
        }
        ArrayList<CoinTo> coinToList = new ArrayList<CoinTo>();
        for (CoinFromDto input : dtoMap.values()) {
            address = AddressTool.getAddress(input.getAddress());
            CoinTo coinTo = new CoinTo(address, input.getAssetChainId(), input.getAssetId(), input.getAmount(), 0L);
            coinToList.add(coinTo);
        }
        BigInteger bigInteger = TxUtils.calcStopConsensusTxFee(coinFromList.size(), coinToList.size() + 1, dto.getPrice());
        CoinTo coinTo = new CoinTo(addressBytes, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), coinFrom.getAmount().subtract(bigInteger), NulsDateUtils.getCurrentTimeSeconds() + (long)SDKContext.stop_agent_lock_time);
        coinToList.add(0, coinTo);
        TxUtils.calcTxFee(coinFromList, coinToList, txSize += 110);
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFromList);
        coinData.setTo(coinToList);
        return coinData;
    }

    public Result signTx(String txHex, String address, String encryptedPrivateKey, String password) {
        ArrayList<SignDto> signDtoList = new ArrayList<SignDto>();
        SignDto signDto = new SignDto();
        signDto.setAddress(address);
        signDto.setEncryptedPrivateKey(encryptedPrivateKey);
        signDto.setPassword(password);
        signDtoList.add(signDto);
        return NerveSDKTool.sign(signDtoList, txHex);
    }

    public Result signTx(String txHex, String address, String privateKey) {
        ArrayList<SignDto> signDtoList = new ArrayList<SignDto>();
        SignDto signDto = new SignDto();
        signDto.setAddress(address);
        signDto.setPriKey(privateKey);
        signDtoList.add(signDto);
        return NerveSDKTool.sign(signDtoList, txHex);
    }

    public Result broadcastTx(String txHex) {
        RpcResult balanceResult = JsonRpcUtil.request("broadcastTx", ListUtil.of(SDKContext.main_chain_id, txHex));
        RpcResultError rpcResultError = balanceResult.getError();
        if (rpcResultError != null) {
            return Result.getFailed(ErrorCode.init(rpcResultError.getCode())).setMsg(rpcResultError.getMessage());
        }
        Map result = (Map)balanceResult.getResult();
        return Result.getSuccess(result);
    }

    public Result validateTx(String txHex) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (StringUtils.isBlank(txHex)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "form is empty");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("txHex", txHex);
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.post("api/accountledger/transaction/validate", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init(restFulResult.getError().getCode());
                result = Result.getFailed(errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result createMultiSignConsensusTx(MultiSignConsensusDto consensusDto) {
        ValidateUtil.validateChainId();
        try {
            if (StringUtils.isBlank(consensusDto.getRewardAddress())) {
                consensusDto.setRewardAddress(consensusDto.getAgentAddress());
            }
            CommonValidator.validateMultiSignConsensusDto(consensusDto);
            if (consensusDto.getInput().getAssetChainId() == 0) {
                consensusDto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (consensusDto.getInput().getAssetId() == 0) {
                consensusDto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(4);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Agent agent = new Agent();
            agent.setAgentAddress(AddressTool.getAddress(consensusDto.getAgentAddress()));
            agent.setPackingAddress(AddressTool.getAddress(consensusDto.getPackingAddress()));
            agent.setRewardAddress(AddressTool.getAddress(consensusDto.getRewardAddress()));
            agent.setDeposit(consensusDto.getDeposit());
            agent.setCommissionRate((byte)consensusDto.getCommissionRate());
            tx.setTxData(agent.serialize());
            CoinData coinData = this.assemblyCoinData(consensusDto.getInput(), agent.getDeposit(), consensusDto.getPubKeys().size(), tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)consensusDto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : consensusDto.getPubKeys()) {
                list.add(HexUtil.decode(pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(CoinFromDto from, BigInteger amount, int pubKeyCount, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        byte[] address = AddressTool.getAddress(from.getAddress());
        byte[] nonce = HexUtil.decode(from.getNonce());
        CoinFrom coinFrom = new CoinFrom(address, from.getAssetChainId(), from.getAssetId(), from.getAmount(), nonce, 0);
        coinFroms.add(coinFrom);
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo(address, from.getAssetChainId(), from.getAssetId(), amount, -1L);
        coinTos.add(coinTo);
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getMultiSignSignatureSize(pubKeyCount));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createMultiSignDepositTx(MultiSignDepositDto dto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.validateMultiSignDepositDto(dto);
            if (dto.getInput().getAssetChainId() == 0) {
                dto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (dto.getInput().getAssetId() == 0) {
                dto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(5);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Deposit deposit = new Deposit();
            deposit.setAddress(AddressTool.getAddress(dto.getAddress()));
            deposit.setAgentHash(NulsHash.fromHex(dto.getAgentHash()));
            deposit.setDeposit(dto.getDeposit());
            tx.setTxData(deposit.serialize());
            CoinData coinData = this.assemblyCoinData(dto.getInput(), dto.getDeposit(), dto.getPubKeys().size(), tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)dto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : dto.getPubKeys()) {
                list.add(HexUtil.decode(pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result createMultiSignWithdrawDepositTx(MultiSignWithDrawDto dto) {
        ValidateUtil.validateChainId();
        try {
            if (dto.getPrice() == null) {
                dto.setPrice(TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES);
            }
            CommonValidator.validateMultiSignWithDrawDto(dto);
            if (dto.getInput().getAssetChainId() == 0) {
                dto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (dto.getInput().getAssetId() == 0) {
                dto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(6);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            CancelDeposit cancelDeposit = new CancelDeposit();
            cancelDeposit.setAddress(AddressTool.getAddress(dto.getAddress()));
            cancelDeposit.setJoinTxHash(NulsHash.fromHex(dto.getDepositHash()));
            tx.setTxData(cancelDeposit.serialize());
            CoinData coinData = this.assemblyCoinData(dto, tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)dto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : dto.getPubKeys()) {
                list.add(HexUtil.decode(pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result createMultiSignStopConsensusTx(MultiSignStopConsensusDto dto) {
        ValidateUtil.validateChainId();
        try {
            if (dto.getPrice() == null) {
                dto.setPrice(TransactionFeeCalculator.NORMAL_PRICE_PRE_1024_BYTES);
            }
            CommonValidator.validateMultiSignStopConsensusDto(dto);
            for (StopDepositDto depositDto : dto.getDepositList()) {
                if (depositDto.getInput().getAssetChainId() == 0) {
                    depositDto.getInput().setAssetChainId(SDKContext.main_chain_id);
                }
                if (depositDto.getInput().getAssetId() != 0) continue;
                depositDto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(9);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            StopAgent stopAgent = new StopAgent();
            NulsHash nulsHash = NulsHash.fromHex(dto.getAgentHash());
            stopAgent.setCreateTxHash(nulsHash);
            tx.setTxData(stopAgent.serialize());
            CoinData coinData = this.assemblyCoinData(dto, tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)dto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : dto.getPubKeys()) {
                list.add(HexUtil.decode(pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result createMultiSignAliasTx(MultiSignAliasDto aliasDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.validateMultiSignAliasDto(aliasDto);
            Transaction tx = new Transaction(3);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setRemark(StringUtils.bytes(aliasDto.getRemark()));
            Alias alias = new Alias(AddressTool.getAddress(aliasDto.getAddress()), aliasDto.getAlias());
            tx.setTxData(alias.serialize());
            CoinData coinData = this.assemblyCoinData(aliasDto);
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash(tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)aliasDto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : aliasDto.getPubKeys()) {
                list.add(HexUtil.decode(pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode(tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed(e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed(AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }
}

