/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base;

import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.core.constant.CommonCodeConstanst;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.log.Log;
import network.nerve.core.model.StringUtils;

public class RPCUtil {
    public static String encode(byte[] src) {
        return src == null ? null : HexUtil.encode(src);
    }

    public static byte[] decode(String src) {
        return src == null ? null : HexUtil.decode(src);
    }

    public static <T> T getInstance(byte[] bytes, Class<? extends BaseNulsData> clazz) {
        if (null == bytes || bytes.length == 0) {
            Log.error("error code-" + CommonCodeConstanst.DESERIALIZE_ERROR);
            return null;
        }
        try {
            BaseNulsData baseNulsData = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            baseNulsData.parse(new NulsByteBuffer(bytes));
            return (T)baseNulsData;
        }
        catch (Exception e) {
            Log.error("error code-" + CommonCodeConstanst.DESERIALIZE_ERROR);
            return null;
        }
    }

    public static <T> T getInstanceRpcStr(String data, Class<? extends BaseNulsData> clazz) {
        if (StringUtils.isBlank(data)) {
            Log.error("error code-" + CommonCodeConstanst.DESERIALIZE_ERROR);
            return null;
        }
        return RPCUtil.getInstance(RPCUtil.decode(data), clazz);
    }
}

