/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import java.io.IOException;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.NulsHash;
import network.nerve.core.constant.ErrorCode;
import network.nerve.core.constant.ToolsConstant;
import network.nerve.core.exception.NulsException;
import network.nerve.core.exception.NulsRuntimeException;

public abstract class BaseBusinessMessage
extends BaseNulsData {
    private transient NulsHash msgHash;

    @Override
    public int size() {
        return 4;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(ToolsConstant.PLACE_HOLDER);
    }

    @Override
    public void parse(NulsByteBuffer buffer) throws NulsException {
        buffer.readBytes(4);
    }

    public NulsHash getMsgHash() {
        if (this.msgHash == null) {
            try {
                this.msgHash = NulsHash.calcHash(this.serialize());
            }
            catch (IOException e) {
                throw new NulsRuntimeException(ErrorCode.init("10003"));
            }
        }
        return this.msgHash;
    }
}

