/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import java.io.IOException;
import java.math.BigInteger;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.NulsHash;
import network.nerve.core.crypto.ECKey;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.parse.SerializeUtils;

public class NulsSignData
extends BaseNulsData {
    protected byte[] signBytes;

    @Override
    public int size() {
        return SerializeUtils.sizeOfBytes(this.signBytes);
    }

    @Override
    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBytesWithLength(this.signBytes);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.signBytes = byteBuffer.readByLengthByte();
    }

    public byte[] getSignBytes() {
        return this.signBytes;
    }

    public void setSignBytes(byte[] signBytes) {
        this.signBytes = signBytes;
    }

    public NulsSignData sign(NulsHash nulsHash, BigInteger privkey) throws NulsException {
        ECKey ecKey = ECKey.fromPrivate(privkey);
        byte[] signBytes = ecKey.sign(nulsHash.getBytes());
        NulsSignData signData = new NulsSignData();
        signData.parse(signBytes, 0);
        return signData;
    }

    public String toString() {
        try {
            return HexUtil.encode(this.serialize());
        }
        catch (IOException e) {
            Log.error(e);
            return super.toString();
        }
    }
}

