/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.core.inteceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import network.nerve.core.core.inteceptor.base.BeanMethodInterceptorManager;
import network.nerve.core.exception.BeanStatusException;

public class ModularServiceMethodInterceptor
implements MethodInterceptor {
    private ThreadLocal<Integer> threadLocal = new ThreadLocal();

    public Object intercept(Object obj, Method method, Object[] params, MethodProxy methodProxy) throws Throwable {
        this.threadLocal.set(0);
        BeanStatusException throwable = null;
        while (this.threadLocal.get() < 100) {
            try {
                return this.doIntercept(obj, method, params, methodProxy);
            }
            catch (BeanStatusException e) {
                this.threadLocal.set(this.threadLocal.get() + 1);
                throwable = e;
                Thread.sleep(200L);
            }
        }
        throw throwable;
    }

    private Object doIntercept(Object obj, Method method, Object[] params, MethodProxy methodProxy) throws Throwable {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        if (!method.getDeclaringClass().equals(Object.class)) {
            String className = obj.getClass().getCanonicalName();
            className = className.substring(0, className.indexOf("$$"));
            Class<?> clazz = Class.forName(className);
            this.fillAnnotationList(annotationList, clazz, method);
        }
        if (annotationList.isEmpty()) {
            return methodProxy.invokeSuper(obj, params);
        }
        return BeanMethodInterceptorManager.doInterceptor(annotationList.toArray(new Annotation[0]), obj, method, params, methodProxy);
    }

    private void fillAnnotationList(List<Annotation> annotationList, Class clazz, Method method) {
        HashSet<Class<? extends Annotation>> classSet = new HashSet<Class<? extends Annotation>>();
        for (Annotation ann : method.getDeclaredAnnotations()) {
            annotationList.add(ann);
            classSet.add(ann.annotationType());
        }
        for (Annotation ann : clazz.getDeclaredAnnotations()) {
            if (!classSet.add(ann.annotationType())) continue;
            annotationList.add(0, ann);
        }
        for (Annotation ann : clazz.getAnnotations()) {
            if (!classSet.add(ann.annotationType())) continue;
            annotationList.add(0, ann);
        }
    }
}

