/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.cmd;

import network.nerve.core.constant.CommonCodeConstanst;
import network.nerve.core.constant.ErrorCode;
import network.nerve.core.rpc.model.ConfigItem;
import network.nerve.core.rpc.model.message.MessageUtil;
import network.nerve.core.rpc.model.message.Response;
import network.nerve.core.rpc.netty.channel.manager.ConnectManager;

public abstract class BaseCmd {
    protected void setConfigItem(String key, Object value, boolean readOnly) {
        ConfigItem configItem = new ConfigItem(key, value, readOnly);
        ConnectManager.CONFIG_ITEM_MAP.put(key, configItem);
    }

    protected Response success() {
        return this.success(null);
    }

    protected Response success(Object responseData) {
        Response response = MessageUtil.newSuccessResponse("", "success");
        response.setResponseData(responseData);
        return response;
    }

    protected Response failed(ErrorCode errorCode) {
        return MessageUtil.newFailResponse("", errorCode);
    }

    protected Response failed(String errMsg) {
        return this.failed(CommonCodeConstanst.FAILED, errMsg);
    }

    protected Response failed(ErrorCode errorCode, String errMsg) {
        Response response = MessageUtil.newFailResponse("", errMsg);
        response.setResponseErrorCode(errorCode.getCode());
        return response;
    }
}

