/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.modulebootstrap;

import java.util.Map;
import network.nerve.core.core.annotation.Autowired;
import network.nerve.core.core.annotation.Component;
import network.nerve.core.log.Log;
import network.nerve.core.parse.JSONUtils;
import network.nerve.core.rpc.cmd.BaseCmd;
import network.nerve.core.rpc.model.CmdAnnotation;
import network.nerve.core.rpc.model.message.Response;
import network.nerve.core.rpc.modulebootstrap.Module;
import network.nerve.core.rpc.modulebootstrap.RpcModule;

@Component
public class ModuleStatusCmd
extends BaseCmd {
    @Autowired
    RpcModule rpcModule;

    @CmdAnnotation(scope="private", cmd="listenerDependenciesReady", version=1.0, minEvent=1, description="notify module is ready")
    public Response listenerDependenciesReady(Map<String, Object> map) {
        Log.info("listenerDependenciesReady : {}", map);
        Module module = JSONUtils.map2pojo(map, Module.class);
        this.rpcModule.listenerDependenciesReady(module);
        return this.success("ModuleReadyListener success " + this.rpcModule.moduleInfo());
    }

    @CmdAnnotation(scope="private", cmd="registerModuleDependencies", version=1.0, minEvent=1, description="Register module followerList")
    public Response followModule(Map<String, Object> param) {
        Log.info("registerModuleDependencies : {}", param);
        Module module = JSONUtils.map2pojo(param, Module.class);
        this.rpcModule.addFollower(module);
        return this.success("ModuleDependenciesRegisterListener success " + this.rpcModule.moduleInfo());
    }

    @CmdAnnotation(scope="private", cmd="connectReady", version=1.0, minEvent=1, description="check module rpc is ready")
    public Response connectReady(Map<String, Object> param) {
        return this.success(this.rpcModule.isReady());
    }
}

