/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.model;

import java.io.IOException;
import java.util.Objects;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.core.exception.NulsException;

public class NerveToken
extends BaseNulsData {
    private int chainId;
    private int assetId;

    public NerveToken() {
    }

    public NerveToken(int chainId, int assetId) {
        this.chainId = chainId;
        this.assetId = assetId;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.writeUint16(this.assetId);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readUint16();
        this.assetId = byteBuffer.readUint16();
    }

    @Override
    public int size() {
        return 4;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NerveToken that = (NerveToken)o;
        return this.chainId == that.chainId && this.assetId == that.assetId;
    }

    public int hashCode() {
        return Objects.hash(this.chainId, this.assetId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"chainId\":").append(this.chainId);
        sb.append(",\"assetId\":").append(this.assetId);
        sb.append('}');
        return sb.toString();
    }

    public NerveToken clone() {
        return new NerveToken(this.chainId, this.assetId);
    }

    public String str() {
        return this.chainId + "-" + this.assetId;
    }
}

