/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.signture;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import network.nerve.base.basic.AddressTool;
import network.nerve.base.data.NulsHash;
import network.nerve.base.data.NulsSignData;
import network.nerve.base.data.Transaction;
import network.nerve.base.signture.MultiSignTxSignature;
import network.nerve.base.signture.P2PHKSignature;
import network.nerve.base.signture.TransactionSignature;
import network.nerve.core.core.annotation.Component;
import network.nerve.core.crypto.ECKey;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;

@Component
public class SignatureUtil {
    private static final int MAIN_CHAIN_ID = 1;

    public static boolean validateTransactionSignture(int chainId, Transaction tx) throws NulsException {
        try {
            if (tx.getTransactionSignature() == null || tx.getTransactionSignature().length == 0) {
                throw new NulsException(new Exception());
            }
            if (!tx.isMultiSignTx()) {
                TransactionSignature transactionSignature = new TransactionSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                if (transactionSignature.getP2PHKSignatures() == null || transactionSignature.getP2PHKSignatures().size() == 0) {
                    throw new NulsException(new Exception("Transaction unsigned \uff01"));
                }
                for (P2PHKSignature signature : transactionSignature.getP2PHKSignatures()) {
                    if (ECKey.verify(tx.getHash().getBytes(), signature.getSignData().getSignBytes(), signature.getPublicKey())) continue;
                    throw new NulsException(new Exception("Transaction signature error !"));
                }
            } else {
                MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                if (transactionSignature.getP2PHKSignatures() == null || transactionSignature.getP2PHKSignatures().size() == 0) {
                    throw new NulsException(new Exception("Transaction unsigned \uff01"));
                }
                List<P2PHKSignature> validSignatures = transactionSignature.getValidSignature();
                int validCount = 0;
                for (P2PHKSignature signature : validSignatures) {
                    if (!ECKey.verify(tx.getHash().getBytes(), signature.getSignData().getSignBytes(), signature.getPublicKey())) continue;
                    ++validCount;
                }
                if (validCount < transactionSignature.getM()) {
                    throw new NulsException(new Exception("Transaction signature error !"));
                }
            }
        }
        catch (NulsException e) {
            Log.error("TransactionSignature parse error!");
            throw e;
        }
        return true;
    }

    public static boolean ctxSignatureValid(int chainId, Transaction tx) throws NulsException {
        if (tx.getTransactionSignature() == null || tx.getTransactionSignature().length == 0) {
            throw new NulsException(new Exception());
        }
        TransactionSignature transactionSignature = new TransactionSignature();
        transactionSignature.parse(tx.getTransactionSignature(), 0);
        if (transactionSignature.getP2PHKSignatures() == null || transactionSignature.getP2PHKSignatures().size() == 0) {
            throw new NulsException(new Exception("Transaction unsigned \uff01"));
        }
        Set<String> fromAddressSet = tx.getCoinDataInstance().getFromAddressList();
        int signCount = tx.getCoinDataInstance().getFromAddressCount();
        int passCount = 0;
        for (P2PHKSignature signature : transactionSignature.getP2PHKSignatures()) {
            if (!ECKey.verify(tx.getHash().getBytes(), signature.getSignData().getSignBytes(), signature.getPublicKey())) {
                throw new NulsException(new Exception("Transaction signature error !"));
            }
            String signAddress = AddressTool.getStringAddressByBytes(AddressTool.getAddress(signature.getPublicKey(), chainId));
            if (!fromAddressSet.contains(signAddress)) continue;
            fromAddressSet.remove(signAddress);
            if (++passCount < signCount || !fromAddressSet.isEmpty()) continue;
            break;
        }
        if (passCount < signCount || !fromAddressSet.isEmpty()) {
            throw new NulsException(new Exception("Transaction signature error !"));
        }
        return true;
    }

    public static boolean validateCtxSignture(Transaction tx) throws NulsException {
        if (tx.getTransactionSignature() == null || tx.getTransactionSignature().length == 0) {
            return tx.getType() == 25 || tx.getType() == 24;
        }
        TransactionSignature transactionSignature = new TransactionSignature();
        transactionSignature.parse(tx.getTransactionSignature(), 0);
        for (P2PHKSignature signature : transactionSignature.getP2PHKSignatures()) {
            if (ECKey.verify(tx.getHash().getBytes(), signature.getSignData().getSignBytes(), signature.getPublicKey())) continue;
            throw new NulsException(new Exception("Transaction signature error !"));
        }
        return true;
    }

    public static boolean validateSignture(byte[] digestBytes, P2PHKSignature p2PHKSignature) throws NulsException {
        if (null == p2PHKSignature) {
            throw new NulsException(new Exception("P2PHKSignature is null!"));
        }
        return ECKey.verify(digestBytes, p2PHKSignature.getSignData().getSignBytes(), p2PHKSignature.getPublicKey());
    }

    public static boolean containsAddress(Transaction tx, byte[] address, int chainId) throws NulsException {
        Set<String> addressSet = SignatureUtil.getAddressFromTX(tx, chainId);
        if (addressSet == null || addressSet.size() == 0) {
            return false;
        }
        return addressSet.contains(AddressTool.getStringAddressByBytes(address));
    }

    public static Set<String> getAddressFromTX(Transaction tx, int chainId) throws NulsException {
        HashSet<String> addressSet = new HashSet<String>();
        if (tx.getTransactionSignature() == null || tx.getTransactionSignature().length == 0) {
            return null;
        }
        try {
            List<P2PHKSignature> p2PHKSignatures;
            TransactionSignature transactionSignature;
            if (tx.isMultiSignTx()) {
                transactionSignature = new MultiSignTxSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            } else {
                transactionSignature = new TransactionSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            }
            if (p2PHKSignatures == null || p2PHKSignatures.size() == 0) {
                return null;
            }
            for (P2PHKSignature signature : p2PHKSignatures) {
                if (signature.getPublicKey() == null || signature.getPublicKey().length == 0) continue;
                addressSet.add(AddressTool.getStringAddressByBytes(AddressTool.getAddress(signature.getPublicKey(), chainId)));
            }
        }
        catch (NulsException e) {
            Log.error("TransactionSignature parse error!");
            throw e;
        }
        return addressSet;
    }

    public static void createTransactionSignture(Transaction tx, List<ECKey> signEckeys) throws IOException {
        if (signEckeys == null || signEckeys.size() == 0) {
            Log.error("TransactionSignature signEckeys is null!");
            throw new NullPointerException();
        }
        TransactionSignature transactionSignature = new TransactionSignature();
        List<P2PHKSignature> p2PHKSignatures = null;
        try {
            p2PHKSignatures = SignatureUtil.createSignaturesByEckey(tx, signEckeys);
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
        }
        catch (IOException e) {
            Log.error("TransactionSignature serialize error!");
            throw e;
        }
    }

    public static void createOrAddTransactionSignture(Transaction tx, List<ECKey> signEckeys) throws Exception {
        ArrayList<P2PHKSignature> p2PHKSignatures;
        TransactionSignature transactionSignature;
        if (signEckeys == null || signEckeys.size() == 0) {
            Log.error("TransactionSignature signEckeys is null!");
            throw new NullPointerException();
        }
        byte[] signBytes = tx.getTransactionSignature();
        if (null != signBytes && signBytes.length > 0) {
            transactionSignature = (TransactionSignature)Transaction.getInstance(signBytes, TransactionSignature.class);
            p2PHKSignatures = transactionSignature.getP2PHKSignatures();
        } else {
            p2PHKSignatures = new ArrayList<P2PHKSignature>();
            transactionSignature = new TransactionSignature();
        }
        p2PHKSignatures.addAll(SignatureUtil.createSignaturesByEckey(tx, signEckeys));
        transactionSignature.setP2PHKSignatures(p2PHKSignatures);
        tx.setTransactionSignature(transactionSignature.serialize());
    }

    public static List<P2PHKSignature> createSignaturesByEckey(Transaction tx, List<ECKey> eckeys) {
        ArrayList<P2PHKSignature> signatures = new ArrayList<P2PHKSignature>();
        for (ECKey ecKey : eckeys) {
            signatures.add(SignatureUtil.createSignatureByEckey(tx, ecKey));
        }
        return signatures;
    }

    public static List<P2PHKSignature> createSignaturesByEckey(NulsHash hash, List<ECKey> eckeys) {
        ArrayList<P2PHKSignature> signatures = new ArrayList<P2PHKSignature>();
        for (ECKey ecKey : eckeys) {
            signatures.add(SignatureUtil.createSignatureByEckey(hash, ecKey));
        }
        return signatures;
    }

    public static P2PHKSignature createSignatureByPriKey(Transaction tx, String priKey) {
        ECKey ecKey = ECKey.fromPrivate(new BigInteger(1, HexUtil.decode(priKey)));
        P2PHKSignature p2PHKSignature = new P2PHKSignature();
        p2PHKSignature.setPublicKey(ecKey.getPubKey());
        p2PHKSignature.setSignData(SignatureUtil.signDigest(tx.getHash().getBytes(), ecKey));
        return p2PHKSignature;
    }

    public static P2PHKSignature createSignatureByEckey(Transaction tx, ECKey ecKey) {
        P2PHKSignature p2PHKSignature = new P2PHKSignature();
        p2PHKSignature.setPublicKey(ecKey.getPubKey());
        p2PHKSignature.setSignData(SignatureUtil.signDigest(tx.getHash().getBytes(), ecKey));
        return p2PHKSignature;
    }

    public static P2PHKSignature createSignatureByEckey(NulsHash hash, ECKey ecKey) {
        P2PHKSignature p2PHKSignature = new P2PHKSignature();
        p2PHKSignature.setPublicKey(ecKey.getPubKey());
        p2PHKSignature.setSignData(SignatureUtil.signDigest(hash.getBytes(), ecKey));
        return p2PHKSignature;
    }

    public static boolean validMultiScriptSign(byte[] digestBytes, LinkedList<byte[]> signtures, LinkedList<byte[]> pubkeys) {
        while (signtures.size() > 0) {
            byte[] pubKey = pubkeys.pollFirst();
            if (ECKey.verify(digestBytes, signtures.getFirst(), pubKey)) {
                signtures.pollFirst();
            }
            if (signtures.size() <= pubkeys.size()) continue;
            return false;
        }
        return true;
    }

    public static NulsSignData signDigest(byte[] digest, ECKey ecKey) {
        byte[] signbytes = ecKey.sign(digest);
        NulsSignData nulsSignData = new NulsSignData();
        nulsSignData.setSignBytes(signbytes);
        return nulsSignData;
    }
}

