/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.crypto;

import network.nerve.core.crypto.HexUtil;
import org.bouncycastle.crypto.digests.KeccakDigest;

public class KeccakHash {
    public static String keccak(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        try {
            byte[] bytes = HexUtil.decode(src);
            return KeccakHash.keccak(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String keccak(byte[] bytes) {
        return KeccakHash.keccak(bytes, 256);
    }

    public static String keccak(byte[] bytes, int bitLength) {
        KeccakDigest digest = new KeccakDigest(bitLength);
        digest.update(bytes, 0, bytes.length);
        byte[] rsData = new byte[digest.getDigestSize()];
        digest.doFinal(rsData, 0);
        return HexUtil.encode(rsData);
    }

    public static byte[] keccakBytes(byte[] bytes, int bitLength) {
        KeccakDigest digest = new KeccakDigest(bitLength);
        digest.update(bytes, 0, bytes.length);
        byte[] rsData = new byte[digest.getDigestSize()];
        digest.doFinal(rsData, 0);
        return rsData;
    }
}

