/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.core.rpc.util;

import java.util.HashMap;
import java.util.Map;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.model.DateUtils;
import network.nerve.core.parse.JSONUtils;
import network.nerve.core.rpc.model.ModuleE;
import network.nerve.core.rpc.model.message.Response;
import network.nerve.core.rpc.netty.processor.ResponseMessageProcessor;
import network.nerve.core.thread.ThreadUtils;

public class NulsDateUtils
extends DateUtils
implements Runnable {
    private static NulsDateUtils instance = new NulsDateUtils();
    private long NET_REFRESH_TIME = 60000L;
    private static long offset;
    private boolean running;

    public static NulsDateUtils getInstance() {
        return instance;
    }

    public void start() {
        this.start(0L);
    }

    public void start(long refreshTime) {
        if (this.running) {
            return;
        }
        this.running = true;
        if (refreshTime > 0L) {
            this.NET_REFRESH_TIME = refreshTime;
        }
        Log.debug("----------- NulsDateUtils start -------------");
        ThreadUtils.createAndRunThread("NulsDateUtils", this, true);
    }

    @Override
    public void run() {
        while (true) {
            this.getNetworkTime();
            try {
                Thread.sleep(this.NET_REFRESH_TIME);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void getNetworkTime() {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("version", "1.0");
        try {
            HashMap hashMap = (HashMap)NulsDateUtils.request(ModuleE.NW.abbr, "nw_currentTimeMillis", params, 200L);
            long time = Long.valueOf(hashMap.get("currentTimeMillis").toString());
            offset = time - System.currentTimeMillis();
        }
        catch (NulsException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public static Object request(String moduleCode, String cmd, Map params, Long timeout) throws NulsException {
        try {
            Response cmdResp = null == timeout ? ResponseMessageProcessor.requestAndResponse(moduleCode, cmd, params) : ResponseMessageProcessor.requestAndResponse(moduleCode, cmd, params, timeout);
            Map resData = (Map)cmdResp.getResponseData();
            if (!cmdResp.isSuccess()) {
                String errorMsg = null;
                if (null == resData) {
                    errorMsg = String.format("Remote call fail. ResponseComment: %s ", cmdResp.getResponseComment());
                } else {
                    Map map = (Map)resData.get(cmd);
                    errorMsg = String.format("Remote call fail. msg: %s - code: %s - module: %s - interface: %s \n- params: %s ", map.get("msg"), map.get("code"), moduleCode, cmd, JSONUtils.obj2PrettyJson(params));
                }
                throw new Exception(errorMsg);
            }
            return resData.get(cmd);
        }
        catch (Exception e) {
            throw new NulsException(e);
        }
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis() + offset;
    }

    public static long getCurrentTimeSeconds() {
        long millis = System.currentTimeMillis() + offset;
        return millis / 1000L;
    }

    public static long getOffset() {
        return offset;
    }

    public static long getNanoTime() {
        return System.nanoTime() + offset * 1000000L;
    }
}

