/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.constant;

import com.google.common.primitives.UnsignedBytes;
import java.math.BigInteger;
import java.util.Comparator;
import network.nerve.core.crypto.HexUtil;
import network.nerve.core.rpc.model.ModuleE;

public interface AccountConstant {
    public static final String MODULE_DB_PATH = ModuleE.AC.name;
    public static final String CFG_SYSTEM_SECTION = "system";
    public static final String CFG_SYSTEM_LANGUAGE = "language";
    public static final String CFG_SYSTEM_DEFAULT_ENCODING = "encoding";
    public static final String CFG_SYSTEM_TKEYSTORE_FOLDER = "keyDir";
    public static final String KERNEL_MODULE_PORT = "kernelPort";
    public static final String CFG_DB_SECTION = "storage";
    public static final String DB_DATA_PATH = "dataDir";
    public static final String CFG_CHAIN_SECTION = "chain";
    public static final String MAIN_CHAIN_ID = "mainChainId";
    public static final String MAIN_ASSETS_ID = "mainAssetsId";
    public static final String ACCOUNT_LIST_CACHE = "ACCOUNT_LIST";
    public static final BigInteger ALIAS_FEE = BigInteger.valueOf(100000000L);
    public static final byte[] DESTORY_PUBKEY = HexUtil.decode("000000000000000000000000000000000000000000000000000000000000000000");
    public static final String ACCOUNTKEYSTORE_FILE_SUFFIX = ".keystore";
    public static final String SUCCESS_CODE = "1";
    public static final String ERROR_CODE = "0";
    public static final String SUCCESS_MSG = "success";
    public static final double RPC_VERSION = 1.0;
    public static final int PAGE_SIZE = 20;
    public static final String EVENT_TOPIC_CREATE_ACCOUNT = "evt_ac_createAccount";
    public static final String EVENT_TOPIC_REMOVE_ACCOUNT = "evt_ac_removeAccount";
    public static final String EVENT_TOPIC_UPDATE_PASSWORD = "evt_ac_updatePassword";
    public static final int INIT_CAPACITY_16 = 16;
    public static final int INIT_CAPACITY_8 = 8;
    public static final int INIT_CAPACITY_4 = 4;
    public static final int INIT_CAPACITY_2 = 2;
    public static final String ACCOUNT_ROOT_PATH = "io.nuls.account";
    public static final String RPC_PATH = "io.nuls.account.rpc";
    public static final byte NORMAL_TX_LOCKED = 0;
    public static final Comparator<String> PUBKEY_COMPARATOR = new Comparator<String>(){
        private Comparator<byte[]> COMPARATOR = UnsignedBytes.lexicographicalComparator();

        @Override
        public int compare(String k1, String k2) {
            return this.COMPARATOR.compare(HexUtil.decode(k1), HexUtil.decode(k2));
        }
    };
    public static final String OS_NAME = "os.name";
    public static final String OS_WINDOWS = "WINDOWS";
    public static final String SLASH = "/";
    public static final int TX_REMARK_MAX_LEN = 100;
}

