/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.util;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import network.nerve.core.parse.JSONUtils;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpClientUtil {
    private static final int READ_TIMEOUT = 100;
    private static final int CONNECT_TIMEOUT = 60;
    private static final int WRITE_TIMEOUT = 60;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final byte[] LOCKER = new byte[0];
    private static OkHttpClientUtil mInstance;
    private OkHttpClient okHttpClient;

    private OkHttpClientUtil() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        clientBuilder.readTimeout(100L, TimeUnit.SECONDS);
        clientBuilder.connectTimeout(60L, TimeUnit.SECONDS);
        clientBuilder.writeTimeout(60L, TimeUnit.SECONDS);
        this.okHttpClient = clientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClientUtil getInstance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = LOCKER;
        synchronized (LOCKER) {
            if (mInstance != null) return mInstance;
            mInstance = new OkHttpClientUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public Response getResponseData(String url) {
        Request.Builder builder = new Request.Builder();
        Request request = builder.get().url(url).build();
        Call call = this.okHttpClient.newCall(request);
        Response response = null;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public String getData(String url) throws Exception {
        return this.getData(url, null);
    }

    public String getData(String url, Map<String, Object> params) throws Exception {
        if (null != params && !params.isEmpty()) {
            StringBuffer buffer = new StringBuffer("");
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                buffer.append("&" + entry.getKey() + "=" + entry.getValue());
            }
            url = url + buffer.toString();
        }
        Request.Builder builder = new Request.Builder();
        Request request = builder.get().url(url).build();
        Call call = this.okHttpClient.newCall(request);
        Response response = null;
        response = call.execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new IOException("Unexpected code " + response);
    }

    public Response postData(String url, Map<String, Object> bodyParams) throws Exception {
        RequestBody body = RequestBody.create((String)JSONUtils.obj2json(bodyParams), (MediaType)JSON);
        Request.Builder requestBuilder = new Request.Builder();
        Request request = requestBuilder.post(body).url(url).build();
        Call call = this.okHttpClient.newCall(request);
        Response response = null;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public void getDataAsync(String url, final NetCallback netCallback) {
        Request.Builder builder = new Request.Builder();
        Request request = builder.get().url(url).build();
        Call call = this.okHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                netCallback.failed(call, e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                netCallback.success(call, response);
            }
        });
    }

    public void postDataAsync(String url, Map<String, Object> bodyParams, NetCallback netCallback) throws Exception {
        RequestBody body = RequestBody.create((String)JSONUtils.obj2json(bodyParams), (MediaType)JSON);
        this.buildRequest(url, netCallback, body);
    }

    public String postJson(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url(url).post(body).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new IOException("Unexpected code " + response);
    }

    public String postJson(String url, Map<String, Object> bodyParams) throws Exception {
        RequestBody body = RequestBody.create((String)JSONUtils.obj2json(bodyParams), (MediaType)JSON);
        Request request = new Request.Builder().url(url).post(body).header("content-type", JSON.toString()).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new IOException("Unexpected code " + response);
    }

    public void postJsonAsync(String url, String json, NetCallback netCallback) throws IOException {
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        this.buildRequest(url, netCallback, body);
    }

    private void buildRequest(String url, final NetCallback netCallback, RequestBody body) {
        Request.Builder requestBuilder = new Request.Builder();
        Request request = requestBuilder.post(body).url(url).build();
        Call call = this.okHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                netCallback.failed(call, e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                netCallback.success(call, response);
            }
        });
    }

    public static interface NetCallback {
        public void success(Call var1, Response var2) throws IOException;

        public void failed(Call var1, IOException var2);
    }
}

