/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.kit.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import network.nerve.SDKContext;
import network.nerve.core.constant.CommonCodeConstanst;
import network.nerve.core.log.Log;
import network.nerve.core.parse.JSONUtils;
import network.nerve.kit.model.dto.RestFulResult;
import network.nerve.kit.util.OkHttpClientUtil;

public class RestFulUtil {
    public static RestFulResult<Map<String, Object>> get(String url) {
        return RestFulUtil.get(url, null);
    }

    public static RestFulResult<Map<String, Object>> get(String url, Map<String, Object> params) {
        try {
            url = SDKContext.wallet_url + url;
            String resultStr = OkHttpClientUtil.getInstance().getData(url, params);
            RestFulResult result = RestFulUtil.toResult(resultStr);
            return result;
        }
        catch (Exception e) {
            Log.error(e);
            return RestFulResult.failed(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null);
        }
    }

    public static RestFulResult<List<Object>> getList(String url, Map<String, Object> params) {
        try {
            url = SDKContext.wallet_url + url;
            String resultStr = OkHttpClientUtil.getInstance().getData(url, params);
            RestFulResult result = RestFulUtil.toResultList(resultStr);
            return result;
        }
        catch (Exception e) {
            Log.error(e);
            return RestFulResult.failed(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null);
        }
    }

    public static RestFulResult<Map<String, Object>> post(String url, Map<String, Object> params) {
        try {
            url = SDKContext.wallet_url + url;
            String resultStr = OkHttpClientUtil.getInstance().postJson(url, params);
            RestFulResult result = RestFulUtil.toResult(resultStr);
            return result;
        }
        catch (Exception e) {
            Log.error(e);
            return RestFulResult.failed(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null);
        }
    }

    public static RestFulResult<Map<String, Object>> put(String url, Map<String, Object> params) {
        try {
            url = SDKContext.wallet_url + url;
            String resultStr = OkHttpClientUtil.getInstance().postJson(url, params);
            RestFulResult result = RestFulUtil.toResult(resultStr);
            return result;
        }
        catch (Exception e) {
            Log.error(e);
            return RestFulResult.failed(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null);
        }
    }

    private static RestFulResult toResult(String str) throws IOException {
        Map<String, Object> resultMap = JSONUtils.json2map(str);
        RestFulResult result = null;
        Boolean b = (Boolean)resultMap.get("success");
        if (b.booleanValue()) {
            result = RestFulResult.success(resultMap.get("data"));
        } else {
            Object dataObj = resultMap.get("data");
            if (dataObj instanceof Map) {
                Map data = (Map)resultMap.get("data");
                if (data != null) {
                    result = RestFulResult.failed(data.get("code").toString(), data.get("msg").toString());
                }
            } else {
                result = RestFulResult.failed(CommonCodeConstanst.SYS_UNKOWN_EXCEPTION.getCode(), resultMap.toString());
            }
        }
        return result;
    }

    private static RestFulResult toResultList(String str) throws IOException {
        Map<String, Object> resultMap = JSONUtils.json2map(str);
        RestFulResult result = null;
        Boolean b = (Boolean)resultMap.get("success");
        if (b.booleanValue()) {
            List data = (List)resultMap.get("data");
            result = RestFulResult.success(data);
        } else {
            Map data = (Map)resultMap.get("data");
            if (data != null) {
                result = RestFulResult.failed(data.get("code").toString(), data.get("msg").toString());
            }
        }
        return result;
    }

    public static void main(String[] args) {
        RestFulResult<Map<String, Object>> result = RestFulUtil.get("api/accountledger/balance/tNULSeBaMt7c7sybfvP7iAC2p9d1ickHZvH9Sc");
        System.out.println(result.getData());
    }
}

