/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.basic;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import network.nerve.base.data.BaseNulsData;
import network.nerve.base.data.NulsHash;
import network.nerve.base.data.Transaction;
import network.nerve.core.basic.VarInt;
import network.nerve.core.constant.ToolsConstant;
import network.nerve.core.exception.NulsException;
import network.nerve.core.log.Log;
import network.nerve.core.model.ByteUtils;
import network.nerve.core.parse.SerializeUtils;

public class NulsByteBuffer {
    private final byte[] payload;
    private int cursor;

    public NulsByteBuffer(byte[] bytes) {
        this(bytes, 0);
    }

    public NulsByteBuffer(byte[] bytes, int cursor) {
        if (null == bytes || bytes.length == 0 || cursor < 0) {
            throw new RuntimeException();
        }
        this.payload = bytes;
        this.cursor = cursor;
    }

    public long readUint32LE() throws NulsException {
        try {
            long u = SerializeUtils.readUint32LE(this.payload, this.cursor);
            this.cursor += 4;
            return u;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public short readUint8() throws NulsException {
        try {
            short val = SerializeUtils.readUint8LE(this.payload, this.cursor);
            ++this.cursor;
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public int readUint16() throws NulsException {
        try {
            int val = SerializeUtils.readUint16LE(this.payload, this.cursor);
            this.cursor += 2;
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public int readInt32() throws NulsException {
        try {
            int u = SerializeUtils.readInt32LE(this.payload, this.cursor);
            this.cursor += 4;
            return u;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public long readUint32() throws NulsException {
        try {
            long val = SerializeUtils.readUint32LE(this.payload, this.cursor);
            this.cursor += 4;
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public long readUint48() {
        long value = SerializeUtils.readUint48(this.payload, this.cursor);
        this.cursor += 6;
        if (value == 0xFFFFFFFFFFFFL) {
            return -1L;
        }
        return value;
    }

    public long readInt64() throws NulsException {
        try {
            long u = SerializeUtils.readInt64LE(this.payload, this.cursor);
            this.cursor += 8;
            return u;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public BigInteger readBigInteger() throws NulsException {
        try {
            byte[] bytes = Arrays.copyOfRange(this.payload, this.cursor, this.cursor += 32);
            BigInteger u = SerializeUtils.bigIntegerFromBytes(bytes);
            if (u.compareTo(BigInteger.ZERO) < 0) {
                throw new NulsException(new UnsupportedOperationException());
            }
            return u;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public long readVarInt() throws NulsException {
        return this.readVarInt(0);
    }

    public long readVarInt(int offset) throws NulsException {
        try {
            VarInt varint = new VarInt(this.payload, this.cursor + offset);
            this.cursor += offset + varint.getOriginalSizeInBytes();
            return varint.value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public byte readByte() throws NulsException {
        try {
            byte b = this.payload[this.cursor];
            ++this.cursor;
            return b;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public byte[] readBytes(int length) throws NulsException {
        try {
            byte[] b = new byte[length];
            System.arraycopy(this.payload, this.cursor, b, 0, length);
            this.cursor += length;
            return b;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NulsException(e);
        }
    }

    public byte[] readByLengthByte() throws NulsException {
        long length = this.readVarInt();
        if (length == 0L) {
            return null;
        }
        return this.readBytes((int)length);
    }

    public boolean readBoolean() throws NulsException {
        byte b = this.readByte();
        return 1 == b;
    }

    public void resetCursor() {
        this.cursor = 0;
    }

    public short readShort() throws NulsException {
        byte[] bytes = this.readBytes(2);
        if (null == bytes) {
            return 0;
        }
        return ByteUtils.bytesToShort(bytes);
    }

    public String readString() throws NulsException {
        try {
            byte[] bytes = this.readByLengthByte();
            if (null == bytes) {
                return "";
            }
            return new String(bytes, ToolsConstant.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            Log.error(e);
            throw new NulsException(e);
        }
    }

    public double readDouble() throws NulsException {
        byte[] bytes = this.readBytes(8);
        if (null == bytes) {
            return 0.0;
        }
        return ByteUtils.bytesToDouble(bytes);
    }

    public boolean isFinished() {
        return this.payload.length == this.cursor;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public <T extends BaseNulsData> T readNulsData(T nulsData) throws NulsException {
        if (this.payload == null) {
            return null;
        }
        int length = this.payload.length - this.cursor;
        if (length <= 0) {
            return null;
        }
        if (length >= 4) {
            byte[] byte4 = new byte[4];
            System.arraycopy(this.payload, this.cursor, byte4, 0, 4);
            if (Arrays.equals(ToolsConstant.PLACE_HOLDER, byte4)) {
                this.cursor += 4;
                return null;
            }
        }
        nulsData.parse(this);
        return nulsData;
    }

    public Transaction readTransaction() throws NulsException {
        try {
            Transaction transaction = new Transaction();
            transaction.parse(this);
            return transaction;
        }
        catch (Exception e) {
            Log.error(e);
            throw new NulsException(e);
        }
    }

    public NulsHash readHash() throws NulsException {
        return new NulsHash(this.readBytes(32));
    }

    public int getCursor() {
        return this.cursor;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }
}

