/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.base.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import network.nerve.base.basic.NulsByteBuffer;
import network.nerve.base.basic.NulsOutputStreamBuffer;
import network.nerve.base.data.BaseNulsData;
import network.nerve.core.exception.NulsException;
import network.nerve.core.parse.SerializeUtils;

public class RedPunishData
extends BaseNulsData {
    private byte[] address;
    private byte reasonCode;
    private byte[] evidence;

    @Override
    public int size() {
        int size = 0;
        size += this.address.length;
        ++size;
        return size += SerializeUtils.sizeOfBytes(this.evidence);
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.address);
        stream.write(this.reasonCode);
        stream.writeBytesWithLength(this.evidence);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.address = byteBuffer.readBytes(23);
        this.reasonCode = byteBuffer.readByte();
        this.evidence = byteBuffer.readByLengthByte();
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public byte getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(byte reasonCode) {
        this.reasonCode = reasonCode;
    }

    public byte[] getEvidence() {
        return this.evidence;
    }

    public void setEvidence(byte[] evidence) {
        this.evidence = evidence;
    }

    public Set<byte[]> getAddresses() {
        HashSet<byte[]> set = new HashSet<byte[]>();
        set.add(this.address);
        return set;
    }
}

